/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta;

import de.mud.jta.Plugin;
import de.mud.jta.PluginConfig;
import de.mud.jta.PluginLoader;
import de.mud.jta.Version;
import de.mud.jta.VisualPlugin;
import de.mud.jta.event.ConfigurationRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class Common
extends PluginLoader {
    public static final String DEFAULT_PATH = "de.mud.jta.plugin";

    public Common(Properties config) {
        super(Common.getPluginPath(config.getProperty("pluginPath")));
        System.out.println("** The Java(tm) Telnet Application");
        System.out.println("** Version 2.5 for Java 2");
        System.out.println("** Copyright (c) 1996-2002 Matthias L. Jugel, Marcus Mei\u00dfner");
        try {
            Version build = (Version)Class.forName("de.mud.jta.Build").newInstance();
            System.out.println("** Build: " + build.getDate());
        }
        catch (Exception e) {
            System.out.println("** Build: patched or selfmade, no date");
            System.err.println(e);
        }
        Vector names = Common.split(config.getProperty("plugins"), ',');
        if (names == null) {
            System.err.println("jta: no plugins found! aborting ...");
            return;
        }
        Enumeration e = names.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String id = null;
            int idx = name.indexOf("(");
            if (idx > 1) {
                if (name.indexOf(")", idx) > idx) {
                    id = name.substring(idx + 1, name.indexOf(")", idx));
                } else {
                    System.err.println("jta: missing ')' for plugin '" + name + "'");
                }
                name = name.substring(0, idx);
            }
            System.out.println("jta: loading plugin '" + name + "'" + (id != null && id.length() > 0 ? ", ID: '" + id + "'" : ""));
            Plugin plugin = this.addPlugin(name, id);
            if (plugin != null) continue;
            System.err.println("jta: ignoring plugin '" + name + "'" + (id != null && id.length() > 0 ? ", ID: '" + id + "'" : ""));
        }
        this.broadcast(new ConfigurationRequest(new PluginConfig(config)));
    }

    public Map getComponents() {
        Map plugins = this.getPlugins();
        Iterator pluginIt = plugins.keySet().iterator();
        HashMap<String, JComponent> components = new HashMap<String, JComponent>();
        while (pluginIt.hasNext()) {
            JComponent c;
            String name = (String)pluginIt.next();
            Plugin plugin = (Plugin)plugins.get(name);
            if (!(plugin instanceof VisualPlugin) || (c = ((VisualPlugin)((Object)plugin)).getPluginVisual()) == null) continue;
            String id = plugin.getId();
            components.put(name + (id != null ? "(" + id + ")" : ""), c);
        }
        return components;
    }

    public Map getMenus() {
        Map plugins = this.getPlugins();
        Iterator pluginIt = plugins.keySet().iterator();
        HashMap<String, JMenu> menus = new HashMap<String, JMenu>();
        while (pluginIt.hasNext()) {
            JMenu menu;
            String name = (String)pluginIt.next();
            Plugin plugin = (Plugin)plugins.get(name);
            if (!(plugin instanceof VisualPlugin) || (menu = ((VisualPlugin)((Object)plugin)).getPluginMenu()) == null) continue;
            String id = plugin.getId();
            menus.put(name + (id != null ? "(" + id + ")" : ""), menu);
        }
        return menus;
    }

    private static Vector getPluginPath(String path) {
        if (path == null) {
            path = DEFAULT_PATH;
        }
        return Common.split(path, ':');
    }

    public static Vector split(String s, char separator) {
        if (s == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int old = -1;
        int idx = s.indexOf(separator);
        while (idx >= 0) {
            v.addElement(s.substring(old + 1, idx));
            old = idx;
            idx = s.indexOf(separator, old + 1);
        }
        v.addElement(s.substring(old + 1));
        return v;
    }
}

