/*
 * Decompiled with CFR 0.152.
 */
package de.mud.telnet;

import de.mud.telnet.ScriptHandler;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class TelnetWrapper
extends TelnetProtocolHandler {
    private static final int debug = 0;
    protected ScriptHandler scriptHandler = new ScriptHandler();
    private Thread reader;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected String host;
    protected int port = 23;
    protected Vector script = new Vector();
    private String prompt = null;

    public void connect(String host, int port) throws IOException {
        try {
            this.socket = new Socket(host, port);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.reset();
        }
        catch (Exception e) {
            System.err.println("TelnetWrapper: " + e);
            this.disconnect();
            throw (IOException)e;
        }
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    public void notifyEndOfRecord() {
    }

    public void login(String user, String pwd) throws IOException {
        this.waitfor("login:");
        this.send(user);
        this.waitfor("Password:");
        this.send(pwd);
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public String send(String cmd) throws IOException {
        byte[] arr = (cmd + "\n").getBytes();
        this.transpose(arr);
        if (this.prompt != null) {
            return this.waitfor(this.prompt);
        }
        return null;
    }

    public String waitfor(String[] searchElements) throws IOException {
        ScriptHandler[] handlers = new ScriptHandler[searchElements.length];
        int i = 0;
        while (i < searchElements.length) {
            handlers[i] = new ScriptHandler();
            handlers[i].setup(searchElements[i]);
            ++i;
        }
        byte[] b = new byte[256];
        int n = 0;
        StringBuffer ret = new StringBuffer();
        while (n >= 0) {
            n = this.read(b);
            if (n <= 0) continue;
            String current = new String(b, 0, n);
            ret.append(current);
            int i2 = 0;
            while (i2 < handlers.length) {
                if (handlers[i2].match(b, n)) {
                    return ret.toString();
                }
                ++i2;
            }
        }
        return null;
    }

    public String waitfor(String match) throws IOException {
        String[] matches = new String[]{match};
        return this.waitfor(matches);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b) throws IOException {
        n = this.negotiate(b);
        if (n <= 0) ** GOTO lbl12
        return n;
lbl-1000:
        // 2 sources

        {
            if ((n = this.negotiate(b)) > 0) {
                return n;
            }
            if (n == 0) continue;
            n = this.in.read(b);
            if (n < 0) {
                return n;
            }
            this.inputfeed(b, n);
            n = this.negotiate(b);
lbl12:
            // 2 sources

            if (n > 0) break;
            ** while (true)
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public String getTerminalType() {
        return "dumb";
    }

    public Dimension getWindowSize() {
        return new Dimension(80, 24);
    }

    public void setLocalEcho(boolean echo) {
    }
}

