/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.MyRecordStore;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;

public class Settings
extends MyRecordStore {
    public static final int DEFAULT_BGCOLOR = 0;
    public static final int DEFAULT_FGCOLOR = 0xFFFFFF;
    public static final int ROT_NORMAL = 0;
    public static final int ROT_270 = 1;
    public static final int ROT_90 = 2;
    public static final int FONT_NORMAL = 0;
    public static final int FONT_SMALL = 1;
    public static final int FONT_MEDIUM = 2;
    public static final int FONT_LARGE = 3;
    private static final String RMS_NAME = "settings";
    public static int bgcolor;
    public static int fgcolor;
    public static int terminalCols;
    public static int terminalRows;
    public static String terminalType;
    public static int terminalRotated;
    public static int fontMode;
    private static Settings me;
    public static boolean terminalFullscreen;
    public static String sessionsImportUrl;
    public static int sshVersionPreferred;
    public static boolean ssh2StoreKey;
    public static byte[] ssh2x;
    public static byte[] ssh2y;
    public static int ssh2KeySize;

    public static void init() {
        Settings.defaults();
        me.load(RMS_NAME, false);
    }

    public static void saveSettings() {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(null);
        me.save(RMS_NAME, vector);
    }

    public static void defaults() {
        bgcolor = 0;
        fgcolor = 0xFFFFFF;
        terminalCols = 0;
        terminalRows = 0;
        terminalType = "";
        terminalRotated = 0;
        fontMode = 0;
        terminalFullscreen = false;
        sshVersionPreferred = 1;
        sessionsImportUrl = "http://";
        ssh2StoreKey = true;
        ssh2x = null;
        ssh2y = null;
        ssh2KeySize = 512;
    }

    protected Object read(DataInputStream dataInputStream) throws IOException {
        fgcolor = dataInputStream.readInt();
        bgcolor = dataInputStream.readInt();
        terminalCols = dataInputStream.readInt();
        terminalRows = dataInputStream.readInt();
        terminalType = dataInputStream.readUTF();
        terminalRotated = dataInputStream.readInt();
        fontMode = dataInputStream.readInt();
        terminalFullscreen = dataInputStream.readBoolean();
        sshVersionPreferred = dataInputStream.readInt();
        sessionsImportUrl = dataInputStream.readUTF();
        ssh2StoreKey = dataInputStream.readBoolean();
        ssh2x = this.readByteArray(dataInputStream);
        ssh2y = this.readByteArray(dataInputStream);
        ssh2KeySize = dataInputStream.readInt();
        return null;
    }

    protected void write(DataOutputStream dataOutputStream, Object object) throws IOException {
        dataOutputStream.writeInt(fgcolor);
        dataOutputStream.writeInt(bgcolor);
        dataOutputStream.writeInt(terminalCols);
        dataOutputStream.writeInt(terminalRows);
        dataOutputStream.writeUTF(terminalType);
        dataOutputStream.writeInt(terminalRotated);
        dataOutputStream.writeInt(fontMode);
        dataOutputStream.writeBoolean(terminalFullscreen);
        dataOutputStream.writeInt(sshVersionPreferred);
        dataOutputStream.writeUTF(sessionsImportUrl);
        dataOutputStream.writeBoolean(ssh2StoreKey);
        this.writeByteArray(dataOutputStream, ssh2x);
        this.writeByteArray(dataOutputStream, ssh2y);
        dataOutputStream.writeInt(ssh2KeySize);
    }

    private byte[] readByteArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        return byArray;
    }

    private void writeByteArray(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray != null) {
            dataOutputStream.writeInt(byArray.length);
            ((OutputStream)dataOutputStream).write(byArray);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    static {
        me = new Settings();
    }
}

