/*
 * Decompiled with CFR 0.152.
 */
package app.session;

import app.SessionSpec;
import app.Settings;
import app.session.Session;
import app.session.SessionIOHandler;
import java.io.IOException;
import ssh.SshIO;

public class SshSession
extends Session
implements SessionIOHandler {
    private SshIO sshIO;

    public void connect(SessionSpec sessionSpec, String string) {
        this.sshIO = new SshIO(this);
        this.sshIO.login = sessionSpec.username;
        this.sshIO.password = string != null ? string : sessionSpec.password;
        super.connect(sessionSpec, this);
    }

    protected int defaultPort() {
        return 22;
    }

    public void handleReceiveData(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = this.sshIO.handleSSH(byArray, n, n2);
        super.receiveData(byArray2, 0, byArray2.length);
    }

    public void handleSendData(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.sshIO.sendData(byArray, n, n2);
        } else {
            this.sshIO.Send_SSH_NOOP();
        }
    }

    public void sendData(byte[] byArray) throws IOException {
        super.sendData(byArray, 0, byArray.length);
    }

    public String getTerminalID() {
        if (Settings.terminalType.length() > 0) {
            return Settings.terminalType;
        }
        return this.emulation.getTerminalID();
    }

    public int getTerminalWidth() {
        return this.emulation.width;
    }

    public int getTerminalHeight() {
        return this.emulation.height;
    }
}

