/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.LineInputStream;
import app.Main;
import app.SessionManager;
import app.SessionSpec;
import app.Settings;
import gui.Activatable;
import gui.MessageForm;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class ImportSessionsForm
extends Form
implements Activatable,
Runnable,
CommandListener {
    private TextField tfUrl = new TextField("URL:", null, 255, 0);
    private Activatable back;

    public ImportSessionsForm() {
        super("Import Sessions");
        this.append((Item)this.tfUrl);
        this.addCommand(MessageForm.okCommand);
        this.addCommand(MessageForm.backCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == MessageForm.okCommand) {
            new Thread(this).start();
        } else if (command == MessageForm.backCommand && this.back != null) {
            this.back.activate();
        }
    }

    public void activate() {
        Main.setDisplay((Displayable)this);
    }

    public void activate(Activatable activatable) {
        this.back = activatable;
        this.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpConnection httpConnection = null;
        LineInputStream lineInputStream = null;
        try {
            String string;
            int n = 0;
            String string2 = this.tfUrl.getString();
            httpConnection = (HttpConnection)Connector.open((String)string2);
            int n2 = httpConnection.getResponseCode();
            if (n2 != 200) {
                throw new IOException("HTTP response code: " + n2);
            }
            lineInputStream = new LineInputStream(httpConnection.openInputStream());
            String string3 = lineInputStream.readLine();
            while (string3 != null) {
                int n3;
                int n4;
                string = "";
                String string4 = null;
                String string5 = "";
                SessionSpec sessionSpec = null;
                if (string3.startsWith("ssh ")) {
                    n4 = 4;
                    n3 = string3.indexOf(32, n4);
                    if (n3 != -1) {
                        int n5 = string3.indexOf(64, n4);
                        if (n5 != -1 && n5 < n3) {
                            string = string3.substring(n4, n5);
                            n4 = n5 + 1;
                        }
                        string4 = string3.substring(n4, n3);
                        string5 = string3.substring(n3 + 1).trim();
                        sessionSpec = new SessionSpec();
                        sessionSpec.type = "ssh";
                    }
                } else if (string3.startsWith("telnet ") && (n3 = string3.indexOf(32, n4 = 7)) != -1) {
                    string4 = string3.substring(n4, n3);
                    string5 = string3.substring(n3 + 1).trim();
                    sessionSpec = new SessionSpec();
                    sessionSpec.type = "telnet";
                }
                if (sessionSpec != null) {
                    sessionSpec.alias = string5;
                    sessionSpec.host = string4;
                    sessionSpec.username = string;
                    sessionSpec.password = "";
                    this.appendOrReplaceSession(sessionSpec);
                    ++n;
                }
                string3 = lineInputStream.readLine();
            }
            this.back.activate();
            Settings.sessionsImportUrl = string2;
            Settings.saveSettings();
            string = new Alert("Import Complete");
            string.setType(AlertType.INFO);
            string.setString("Imported " + n + " sessions");
            Main.alert((Alert)string, (Displayable)this.back);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Alert alert = new Alert("Import Failed");
            alert.setType(AlertType.ERROR);
            alert.setString(exception.getMessage());
            alert.setTimeout(-2);
            Main.alert(alert, (Displayable)this);
        }
        finally {
            if (lineInputStream != null) {
                try {
                    lineInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (httpConnection != null) {
                try {
                    httpConnection.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void appendOrReplaceSession(SessionSpec sessionSpec) {
        SessionSpec sessionSpec2 = null;
        int n = -1;
        Vector vector = SessionManager.getSessions();
        for (int i = 0; i < vector.size(); ++i) {
            sessionSpec2 = (SessionSpec)vector.elementAt(i);
            if (!sessionSpec2.type.equals(sessionSpec.type) || !sessionSpec.alias.equals(sessionSpec2.alias)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            SessionManager.addSession(sessionSpec);
        } else {
            sessionSpec2.alias = sessionSpec.alias;
            sessionSpec2.username = sessionSpec.username;
            sessionSpec2.host = sessionSpec.host;
            SessionManager.replaceSession(n, sessionSpec2);
        }
    }
}

