/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.Main;
import gui.Activatable;
import gui.ExtendedList;
import gui.MessageForm;
import gui.SessionsMenu;
import gui.session.macros.MacrosMenu;
import gui.settings.SettingsMenu;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class MainMenu
extends ExtendedList
implements CommandListener,
Activatable {
    private static Command quitCommand = new Command("Quit", 7, 2);
    private SessionsMenu sessionsMenu;
    private static MacrosMenu macrosMenu;
    private static Activatable settingsMenu;
    private static final String ITEM_SESSIONS = "Sessions";
    private static final String ITEM_MACROS = "Macros";
    private static final String ITEM_SETTINGS = "Settings";
    private static final String ITEM_ABOUT = "About MidpSSH";
    private static final String ITEM_HELP = "Help";
    private static final String ITEM_QUIT = "Quit";

    public MainMenu() {
        super("MidpSSH", 3);
        this.append(ITEM_SESSIONS, null);
        this.append(ITEM_MACROS, null);
        this.append(ITEM_SETTINGS, null);
        this.append(ITEM_ABOUT, null);
        this.append(ITEM_HELP, null);
        this.append(ITEM_QUIT, null);
        this.addCommand(quitCommand);
        this.setCommandListener(this);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            String string = this.getString(this.getSelectedIndex());
            if (string.equals(ITEM_SESSIONS)) {
                this.doSessions();
            } else if (string.equals(ITEM_MACROS)) {
                MainMenu.doMacros(this);
            } else if (string.equals(ITEM_SETTINGS)) {
                this.doSettings();
            } else if (string.equals(ITEM_ABOUT)) {
                this.doAbout();
            } else if (string.equals(ITEM_HELP)) {
                this.doHelp();
            } else if (string.equals(ITEM_QUIT)) {
                Main.quitApp();
            }
        } else if (command == quitCommand) {
            Main.quitApp();
        }
    }

    private void doSessions() {
        if (this.sessionsMenu == null) {
            this.sessionsMenu = new SessionsMenu();
        }
        this.sessionsMenu.activate(this);
    }

    public static void doMacros(Activatable activatable) {
        if (macrosMenu == null) {
            macrosMenu = new MacrosMenu();
        }
        macrosMenu.activate(activatable);
    }

    private void doSettings() {
        if (settingsMenu == null) {
            settingsMenu = new SettingsMenu();
        }
        settingsMenu.activate(this);
    }

    private void doAbout() {
        new MessageForm(ITEM_ABOUT, "Version 1.4.6\n\nMidpSSH is a Telnet and SSH application for Java compatible phones and other mobile devices.\n\nPlease visit the project website for more information:\nhttp://www.xk72.com/midpssh/\n\nMidpSSH is developed by Karl von Randow. MidpSSH is based upon FloydSSH and Telnet Floyd by Radek Polak.\n\nMidpSSH is distributed under the GPL licence. For more information please visit the website.").activate(this);
    }

    private void doHelp() {
        new MessageForm("MidpSSH Help", "Connecting\n\nTo connect to a remote server choose the Sessions option from the main menu - create a new session, entering in the host and other details. You can then connect to that server by choosing the new session.\n\nMore Information\n\nFor more information please visit the project website http://www.xk72.com/midpssh/").activate(this);
    }

    public void activate() {
        Main.setDisplay((Displayable)this);
    }

    public void activate(Activatable activatable) {
        this.activate();
    }
}

