/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.SessionManager;
import app.SessionSpec;
import gui.EditableForm;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;

public class SessionForm
extends EditableForm {
    public static final Command saveCommand = new Command("Save", 1, 1);
    public static final Command createCommand = new Command("Create", 1, 1);
    private int connectionIndex = 1;
    private boolean edit;
    private TextField tfAlias;
    private TextField tfHost;
    private TextField tfUsername;
    private TextField tfPassword;
    private ChoiceGroup cgType;
    private static String[] typeNames = new String[]{"SSH", "Telnet"};
    private static String[] typeCodes = new String[]{"ssh", "telnet"};

    public SessionForm(boolean bl) {
        super(bl ? "Edit Session" : "New Session");
        this.edit = bl;
        this.tfAlias = new TextField("Alias:", null, 255, 0);
        this.tfHost = new TextField("Host:", null, 255, 0);
        this.tfUsername = new TextField("Username:", null, 255, 0);
        this.tfPassword = new TextField("Password:", null, 255, 65536);
        this.cgType = new ChoiceGroup("Type", 1);
        for (int i = 0; i < typeNames.length; ++i) {
            this.cgType.append(typeNames[i], null);
        }
        this.append((Item)this.tfAlias);
        this.append((Item)this.tfHost);
        this.append((Item)new StringItem(null, "To specify an alternative port append a colon and the port number to the host name."));
        this.append((Item)this.cgType);
        this.append((Item)new StringItem("Authentication:\n", "For SSH connections only."));
        this.append((Item)this.tfUsername);
        this.append((Item)this.tfPassword);
        if (bl) {
            this.addCommand(saveCommand);
        } else {
            this.addCommand(createCommand);
        }
    }

    public void activate() {
        if (!this.edit) {
            this.tfAlias.setString("");
            this.tfHost.setString("");
            this.tfUsername.setString("");
            this.tfPassword.setString("");
        }
        super.activate();
    }

    public void setConnectionIndex(int n) {
        this.connectionIndex = n;
        SessionSpec sessionSpec = SessionManager.getSession(n);
        if (sessionSpec != null) {
            this.tfAlias.setString(sessionSpec.alias);
            this.tfHost.setString(sessionSpec.host);
            if (sessionSpec.type != null) {
                for (int i = 0; i < typeCodes.length; ++i) {
                    if (!typeCodes[i].equals(sessionSpec.type)) continue;
                    this.cgType.setSelectedIndex(i, true);
                }
            }
            this.tfUsername.setString(sessionSpec.username);
            this.tfPassword.setString(sessionSpec.password);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == saveCommand) {
            this.doSave();
        } else if (command == createCommand) {
            this.doCreate();
        } else {
            super.commandAction(command, displayable);
        }
    }

    private void doSave() {
        if (this.connectionIndex != -1 && this.validateForm()) {
            String string = this.tfAlias.getString();
            String string2 = this.selectedConnectionType();
            String string3 = this.tfHost.getString();
            String string4 = this.tfUsername.getString();
            String string5 = this.tfPassword.getString();
            SessionSpec sessionSpec = new SessionSpec();
            sessionSpec.alias = string;
            sessionSpec.type = string2;
            sessionSpec.host = string3;
            sessionSpec.username = string4;
            sessionSpec.password = string5;
            SessionManager.replaceSession(this.connectionIndex, sessionSpec);
            this.doBack();
        }
    }

    private void doCreate() {
        if (this.validateForm()) {
            String string = this.tfAlias.getString();
            String string2 = this.selectedConnectionType();
            String string3 = this.tfHost.getString();
            String string4 = this.tfUsername.getString();
            String string5 = this.tfPassword.getString();
            SessionSpec sessionSpec = new SessionSpec();
            sessionSpec.alias = string;
            sessionSpec.type = string2;
            sessionSpec.host = string3;
            sessionSpec.username = string4;
            sessionSpec.password = string5;
            SessionManager.addSession(sessionSpec);
            this.doBack();
        }
    }

    protected boolean validateForm() {
        String string = this.tfAlias.getString();
        String string2 = this.tfHost.getString();
        String string3 = this.selectedConnectionType();
        String string4 = this.tfUsername.getString();
        String string5 = this.tfPassword.getString();
        Object object = string3 != null ? (string3.equals("ssh") ? (string.length() > 0 && string2.length() > 0 && string4.length() > 0 ? null : "Please fill in the Alias, Host and Username fields.") : (string.length() > 0 && string2.length() > 0 ? null : "Please fill in the Alias and Host fields.")) : "Please choose the connection type.";
        if (object != null) {
            this.showErrorMessage((String)object);
            return false;
        }
        return true;
    }

    protected String selectedConnectionType() {
        int n = this.cgType.getSelectedIndex();
        if (n < 0 || n >= typeCodes.length) {
            return null;
        }
        return typeCodes[n];
    }
}

