/*
 * Decompiled with CFR 0.152.
 */
package gui;

import app.Main;
import app.SessionManager;
import app.SessionSpec;
import app.session.Session;
import app.session.SshSession;
import app.session.TelnetSession;
import gui.EditableMenu;
import gui.ImportSessionsForm;
import gui.SessionForm;
import gui.session.PasswordDialog;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public class SessionsMenu
extends EditableMenu {
    private static Command connectCommand = new Command("Connect", 8, 1);
    private static SessionForm newConnectionForm = new SessionForm(false);
    private static SessionForm editConnectionForm = new SessionForm(true);
    private static Command importCommand = new Command("Import", 1, 20);
    private ImportSessionsForm importSessionsForm;

    public SessionsMenu() {
        super("Sessions");
        this.replaceSelectCommand(connectCommand);
        this.addCommand(importCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == importCommand) {
            if (this.importSessionsForm == null) {
                this.importSessionsForm = new ImportSessionsForm();
            }
            this.importSessionsForm.activate(this);
        } else {
            super.commandAction(command, displayable);
        }
    }

    protected void addItems() {
        this.deleteAll();
        Vector vector = SessionManager.getSessions();
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                SessionSpec sessionSpec = (SessionSpec)vector.elementAt(i);
                this.append(sessionSpec.alias, null);
            }
        }
    }

    protected void doSelect(int n) {
        SessionSpec sessionSpec;
        if (n != -1 && (sessionSpec = SessionManager.getSession(n)) != null) {
            Session session;
            if (sessionSpec.type.equals("ssh")) {
                session = new SshSession();
                String string = sessionSpec.password;
                if (string == null || string.length() == 0) {
                    new PasswordDialog((SshSession)session, sessionSpec).activate(this);
                } else {
                    ((SshSession)session).connect(sessionSpec, (String)null);
                    Main.openSession(session);
                }
            }
            if (sessionSpec.type.equals("telnet")) {
                session = new TelnetSession();
                ((TelnetSession)session).connect(sessionSpec);
                Main.openSession(session);
            }
        }
    }

    protected void doEdit(int n) {
        if (n != -1) {
            editConnectionForm.setConnectionIndex(n);
            editConnectionForm.activate(this);
        }
    }

    protected void doDelete(int n) {
        if (n != -1) {
            SessionManager.deleteSession(n);
            this.delete(n);
        }
    }

    protected void doNew() {
        newConnectionForm.activate(this);
    }
}

