/*
 * Decompiled with CFR 0.152.
 */
package gui.session.macros;

import app.session.MacroSetManager;
import gui.EditableForm;
import gui.SessionForm;
import gui.session.macros.Macro;
import gui.session.macros.MacroSet;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class MacroForm
extends EditableForm {
    public static final int MODE_MACRO_SET = 1;
    public static final int MODE_MACRO = 2;
    private int macroSetIndex;
    private int macroIndex;
    private boolean edit;
    private TextField tfName;
    private TextField tfValue;
    private ChoiceGroup cgType;
    private boolean isMacroSet;

    public MacroForm(boolean bl, boolean bl2) {
        super(!bl2 ? (bl ? "Edit Macro" : "New Macro") : (bl ? "Edit Macro Set" : "New Macro Set"));
        this.isMacroSet = bl2;
        if (bl2) {
            this.tfName = new TextField("Macro Set Name:", null, 255, 0);
            this.append((Item)this.tfName);
        } else {
            this.tfValue = new TextField("Value:", null, 255, 0);
            this.tfName = new TextField("Name (Optional):", null, 255, 0);
            this.cgType = new ChoiceGroup("Mode", 1);
            this.cgType.append("Enter", null);
            this.cgType.append("Type", null);
            this.append((Item)this.tfName);
            this.append((Item)this.tfValue);
            this.append((Item)this.cgType);
        }
        this.edit = bl;
        if (bl) {
            this.addCommand(SessionForm.saveCommand);
        } else {
            this.addCommand(SessionForm.createCommand);
        }
    }

    public void activate() {
        if (!this.edit) {
            this.tfName.setString("");
            if (this.tfValue != null) {
                this.tfValue.setString("");
            }
        }
        super.activate();
    }

    public void setMacroSetIndex(int n) {
        MacroSet macroSet;
        this.macroSetIndex = n;
        if (this.isMacroSet && (macroSet = MacroSetManager.getMacroSet(n)) != null) {
            this.tfName.setString(macroSet.name);
        }
    }

    public void setMacroIndices(int n, int n2) {
        this.macroSetIndex = n;
        this.macroIndex = n2;
        MacroSet macroSet = MacroSetManager.getMacroSet(n);
        Macro macro = macroSet.getMacro(n2);
        this.tfName.setString(macro.name);
        String string = macro.value;
        if (string.endsWith("\n")) {
            this.cgType.setSelectedIndex(0, true);
            string = string.substring(0, string.length() - 1);
        } else {
            this.cgType.setSelectedIndex(1, true);
        }
        this.tfValue.setString(string);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == SessionForm.saveCommand) {
            this.doSave();
        } else if (command == SessionForm.createCommand) {
            this.doCreate();
        } else {
            super.commandAction(command, displayable);
        }
    }

    private void doSave() {
        if (this.macroSetIndex != -1 && this.validateForm()) {
            if (this.isMacroSet) {
                MacroSet macroSet = MacroSetManager.getMacroSet(this.macroSetIndex);
                macroSet.name = this.tfName.getString();
                MacroSetManager.replaceMacroSet(this.macroSetIndex, macroSet);
            } else {
                MacroSet macroSet = MacroSetManager.getMacroSet(this.macroSetIndex);
                String string = this.tfValue.getString();
                if (this.cgType.getSelectedIndex() == 0) {
                    string = string + "\n";
                }
                Macro macro = new Macro(this.tfName.getString(), string);
                macroSet.replaceMacro(this.macroIndex, macro);
            }
            this.doBack();
        }
    }

    private void doCreate() {
        if (this.validateForm()) {
            if (this.isMacroSet) {
                MacroSet macroSet = new MacroSet();
                macroSet.name = this.tfName.getString();
                MacroSetManager.addMacroSet(macroSet);
            } else {
                MacroSet macroSet = MacroSetManager.getMacroSet(this.macroSetIndex);
                String string = this.tfValue.getString();
                if (this.cgType.getSelectedIndex() == 0) {
                    string = string + "\n";
                }
                Macro macro = new Macro(this.tfName.getString(), string);
                macroSet.addMacro(macro);
            }
            this.doBack();
        }
    }

    protected boolean validateForm() {
        String string = null;
        if (this.isMacroSet) {
            if (this.tfName.getString() == null || this.tfName.getString().length() == 0) {
                string = "Please fill in the Macro Set Name";
            }
        } else if (this.tfValue.getString() == null || this.tfValue.getString().length() == 0) {
            string = "Please fill in the value";
        }
        if (string != null) {
            this.showErrorMessage(string);
            return false;
        }
        return true;
    }
}

