/*
 * Decompiled with CFR 0.152.
 */
package gui.session.macros;

import app.session.MacroSetManager;
import gui.session.macros.Macro;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MacroSet {
    private static final byte VERSION = 1;
    public String name;
    public Vector macros = new Vector();

    public void read(DataInputStream dataInputStream) throws IOException {
        byte by = dataInputStream.readByte();
        this.name = dataInputStream.readUTF();
        int n = dataInputStream.readByte();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            String string2 = dataInputStream.readUTF();
            Macro macro = new Macro(string, string2);
            this.macros.addElement(macro);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.writeUTF(this.name);
        dataOutputStream.writeByte(this.macros.size());
        for (int i = 0; i < this.macros.size(); ++i) {
            Macro macro = (Macro)this.macros.elementAt(i);
            dataOutputStream.writeUTF(macro.name);
            dataOutputStream.writeUTF(macro.value);
        }
    }

    public Macro getMacro(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.macros.size()) {
            return null;
        }
        return (Macro)this.macros.elementAt(n);
    }

    public void addMacro(Macro macro) {
        this.macros.addElement(macro);
        MacroSetManager.saveMacroSets();
    }

    public void deleteMacro(int n) {
        if (n < 0) {
            return;
        }
        if (n >= this.macros.size()) {
            return;
        }
        this.macros.removeElementAt(n);
        MacroSetManager.saveMacroSets();
    }

    public void replaceMacro(int n, Macro macro) {
        if (n < 0) {
            return;
        }
        if (n >= this.macros.size()) {
            this.macros.addElement(macro);
        } else {
            this.macros.setElementAt(macro, n);
        }
        MacroSetManager.saveMacroSets();
    }
}

