/*
 * Decompiled with CFR 0.152.
 */
package gui.session.macros;

import app.Main;
import app.session.MacroSetManager;
import app.session.Session;
import gui.EditableMenu;
import gui.session.InputDialog;
import gui.session.macros.Macro;
import gui.session.macros.MacroForm;
import gui.session.macros.MacroSet;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;

public class MacrosMenu
extends EditableMenu {
    protected static Command useCommand = new Command("Use", 8, 1);
    private MacroSet macroSet;
    private int macroSetIndex;
    private boolean isMacroSets;

    public MacrosMenu() {
        super("Macro Sets");
        this.isMacroSets = true;
    }

    public MacrosMenu(MacroSet macroSet, int n) {
        super("Macros: " + macroSet.name);
        this.isMacroSets = false;
        this.macroSet = macroSet;
        this.macroSetIndex = n;
        if (Main.currentSession() != null) {
            this.addCommand(useCommand);
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == useCommand) {
            int n = this.getSelectedIndex();
            if (n >= 0 && n < this.size()) {
                Session session = Main.currentSession();
                if (session != null) {
                    Macro macro = this.macroSet.getMacro(n);
                    if (macro != null) {
                        InputDialog inputDialog = new InputDialog();
                        inputDialog.activate(session);
                        inputDialog.setString(macro.value.trim());
                    }
                } else {
                    this.doEdit(n);
                }
            }
        } else {
            super.commandAction(command, displayable);
        }
    }

    protected void addItems() {
        block5: {
            block4: {
                this.deleteAll();
                if (!this.isMacroSets) break block4;
                Vector vector = MacroSetManager.getMacroSets();
                if (vector == null) break block5;
                for (int i = 0; i < vector.size(); ++i) {
                    MacroSet macroSet = (MacroSet)vector.elementAt(i);
                    this.append(macroSet.name, null);
                }
                break block5;
            }
            Vector vector = this.macroSet.macros;
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Macro macro = (Macro)vector.elementAt(i);
                    String string = macro.name;
                    if (string == null || string.length() == 0) {
                        string = macro.value.trim();
                    }
                    this.append(string, null);
                }
            }
        }
    }

    protected void doDelete(int n) {
        if (n != -1) {
            if (this.isMacroSets) {
                MacroSetManager.deleteMacroSet(n);
            } else {
                this.macroSet.deleteMacro(n);
            }
            this.delete(n);
        }
    }

    protected void doSelect(int n) {
        if (n != -1) {
            if (this.isMacroSets) {
                MacroSet macroSet = MacroSetManager.getMacroSet(n);
                MacrosMenu macrosMenu = new MacrosMenu(macroSet, n);
                macrosMenu.activate(this);
            } else {
                Session session = Main.currentSession();
                if (session != null) {
                    Macro macro = this.macroSet.getMacro(n);
                    if (macro != null) {
                        session.typeString(macro.value);
                        session.activate();
                    }
                } else {
                    this.doEdit(n);
                }
            }
        }
    }

    protected void doEdit(int n) {
        if (n != -1) {
            MacroForm macroForm = new MacroForm(true, this.isMacroSets);
            if (this.isMacroSets) {
                macroForm.setMacroSetIndex(n);
            } else {
                macroForm.setMacroIndices(this.macroSetIndex, n);
            }
            macroForm.activate(this);
        }
    }

    protected void doNew() {
        MacroForm macroForm = new MacroForm(false, this.isMacroSets);
        if (!this.isMacroSets) {
            macroForm.setMacroSetIndex(this.macroSetIndex);
        }
        macroForm.activate(this);
    }
}

