/*
 * Decompiled with CFR 0.152.
 */
package gui.settings;

import app.Main;
import app.Settings;
import gui.EditableForm;
import gui.MessageForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import ssh.v2.DHKeyExchange;

public class SettingsForm
extends EditableForm {
    public static final int MODE_TERMINAL = 1;
    public static final int MODE_DISPLAY = 2;
    public static final int MODE_FONTS = 3;
    public static final int MODE_SSH = 4;
    private int mode;
    protected TextField tfType = new TextField("Type", "", 20, 0);
    protected TextField tfCols = new TextField("Cols", "", 3, 2);
    protected TextField tfRows = new TextField("Rows", "", 3, 2);
    protected TextField tfFg = new TextField("Foreground", "", 6, 0);
    protected TextField tfBg = new TextField("Background", "", 6, 0);
    protected ChoiceGroup cgFont = new ChoiceGroup("Font Size", 1);
    protected ChoiceGroup cgSsh = new ChoiceGroup("Preferred Protocol", 1);
    protected ChoiceGroup cgSshKeys = new ChoiceGroup("Store Keys", 1);
    protected ChoiceGroup cgSshKeySize = new ChoiceGroup("Key Size", 1);
    private static final int[] sshKeySizes = new int[]{32, 64, 128, 256, 512, 1024};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SettingsForm(String string, int n) {
        super(string);
        this.mode = n;
        switch (n) {
            case 1: {
                this.append((Item)new StringItem("Terminal Type", "The terminal type reported to the remote server. The default type is VT320."));
                this.append((Item)this.tfType);
                break;
            }
            case 2: {
                this.append((Item)new StringItem("Orientation", "Not available on this device."));
                this.append((Item)new StringItem("Terminal Size", "The default is to use the maximum available screen area."));
                this.append((Item)this.tfCols);
                this.append((Item)this.tfRows);
                break;
            }
            case 3: {
                this.cgFont.append("Tiny", null);
                this.cgFont.append("Small", null);
                this.cgFont.append("Medium", null);
                this.cgFont.append("Large", null);
                this.append((Item)this.cgFont);
                this.append((Item)this.tfFg);
                this.append((Item)this.tfBg);
                break;
            }
            case 4: {
                this.cgSsh.append("SSH1", null);
                this.cgSsh.append("SSH2", null);
                this.append((Item)this.cgSsh);
                this.cgSshKeys.append("On", null);
                this.cgSshKeys.append("Off", null);
                this.append((Item)this.cgSshKeys);
                for (int i = 0; i < sshKeySizes.length; ++i) {
                    this.cgSshKeySize.append("" + sshKeySizes[i], null);
                }
                this.append((Item)this.cgSshKeySize);
            }
        }
        this.addCommand(MessageForm.okCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == MessageForm.okCommand) {
            this.save();
        } else {
            super.commandAction(command, displayable);
        }
    }

    public void activate() {
        block0 : switch (this.mode) {
            case 1: {
                this.tfType.setString(Settings.terminalType);
                break;
            }
            case 2: {
                int n = Settings.terminalCols;
                int n2 = Settings.terminalRows;
                if (n > 0) {
                    this.tfCols.setString("" + n);
                } else {
                    this.tfCols.setString("");
                }
                if (n2 > 0) {
                    this.tfRows.setString("" + n2);
                    break;
                }
                this.tfRows.setString("");
                break;
            }
            case 3: {
                switch (Settings.fontMode) {
                    case 0: {
                        this.cgFont.setSelectedIndex(0, true);
                        break;
                    }
                    case 1: {
                        this.cgFont.setSelectedIndex(1, true);
                        break;
                    }
                    case 2: {
                        this.cgFont.setSelectedIndex(2, true);
                        break;
                    }
                    case 3: {
                        this.cgFont.setSelectedIndex(3, true);
                    }
                }
                this.tfFg.setString(SettingsForm.toHex(Settings.fgcolor));
                this.tfBg.setString(SettingsForm.toHex(Settings.bgcolor));
                break;
            }
            case 4: {
                switch (Settings.sshVersionPreferred) {
                    case 2: {
                        this.cgSsh.setSelectedIndex(1, true);
                        break;
                    }
                    default: {
                        this.cgSsh.setSelectedIndex(0, true);
                    }
                }
                this.cgSshKeys.setSelectedIndex(Settings.ssh2StoreKey ? 0 : 1, true);
                for (int i = 0; i < sshKeySizes.length; ++i) {
                    if (Settings.ssh2KeySize != sshKeySizes[i]) continue;
                    this.cgSshKeySize.setSelectedIndex(i, true);
                    break block0;
                }
                break;
            }
        }
        super.activate();
    }

    private void save() {
        boolean bl = this.doSave();
        if (bl) {
            Settings.saveSettings();
            this.doBack();
        }
    }

    protected boolean doSave() {
        switch (this.mode) {
            case 1: {
                Settings.terminalType = this.tfType.getString();
                break;
            }
            case 2: {
                try {
                    Settings.terminalCols = Integer.parseInt(this.tfCols.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.terminalCols = 0;
                }
                try {
                    Settings.terminalRows = Integer.parseInt(this.tfRows.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.terminalRows = 0;
                }
                break;
            }
            case 3: {
                switch (this.cgFont.getSelectedIndex()) {
                    case 0: {
                        Settings.fontMode = 0;
                        break;
                    }
                    case 1: {
                        Settings.fontMode = 1;
                        break;
                    }
                    case 2: {
                        Settings.fontMode = 2;
                        break;
                    }
                    case 3: {
                        Settings.fontMode = 3;
                    }
                }
                try {
                    int n;
                    Settings.fgcolor = n = SettingsForm.fromHex(this.tfFg.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.fgcolor = 0xFFFFFF;
                }
                try {
                    int n;
                    Settings.bgcolor = n = SettingsForm.fromHex(this.tfBg.getString());
                }
                catch (NumberFormatException numberFormatException) {
                    Settings.bgcolor = 0;
                }
                break;
            }
            case 4: {
                boolean bl;
                Settings.sshVersionPreferred = this.cgSsh.getSelectedIndex() == 1 ? 2 : 1;
                Settings.ssh2StoreKey = bl = this.cgSshKeys.getSelectedIndex() == 0;
                int n = sshKeySizes[this.cgSshKeySize.getSelectedIndex()];
                if (n != Settings.ssh2KeySize) {
                    Settings.ssh2KeySize = n;
                    Settings.ssh2x = null;
                    Settings.ssh2y = null;
                }
                if (bl) {
                    if (Settings.ssh2x != null && Settings.ssh2y != null) break;
                    Alert alert = new Alert("MidpSSH");
                    alert.setString("Please wait while the SSH2 key is generated");
                    alert.setTimeout(1);
                    alert.setCommandListener(new CommandListener(){

                        public void commandAction(Command command, Displayable displayable) {
                            byte[][] byArray = DHKeyExchange.generateKeyPairBytes(Settings.ssh2KeySize);
                            Settings.ssh2x = byArray[0];
                            Settings.ssh2y = byArray[1];
                            Settings.saveSettings();
                            SettingsForm.this.doBack();
                        }
                    });
                    Main.setDisplay((Displayable)alert);
                    return false;
                }
                Settings.ssh2x = null;
                Settings.ssh2y = null;
            }
        }
        return true;
    }

    private static int fromHex(String string) throws NumberFormatException {
        string = string.toLowerCase();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n <<= 4;
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                n += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n += c - 97 + 10;
                continue;
            }
            throw new NumberFormatException(string);
        }
        return n;
    }

    private static String toHex(int n) {
        char[] cArray = new char[32];
        int n2 = 32;
        do {
            cArray[--n2] = digits[n & 0xF];
        } while (n2 > 26 || (n >>>= 4) != 0);
        return new String(cArray, n2, 32 - n2);
    }
}

