/*
 * Decompiled with CFR 0.152.
 */
package gui.settings;

import app.Main;
import app.Settings;
import gui.Activatable;
import gui.ExtendedList;
import gui.MessageForm;
import gui.settings.SettingsForm;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;

public class SettingsMenu
extends ExtendedList
implements Activatable,
CommandListener {
    protected static final int SETTINGS_OPTIONS = 2;
    private Activatable back;

    protected SettingsMenu(String string) {
        super(string, 3);
        this.append("Terminal", null);
        this.append("Display", null);
        this.append("Fonts", null);
        this.append("SSH", null);
        this.append("Restore Defaults", null);
        this.addCommand(MessageForm.backCommand);
        this.setCommandListener(this);
    }

    public SettingsMenu() {
        this("Settings");
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == List.SELECT_COMMAND) {
            this.doSelect(this.getSelectedIndex());
        } else if (command == MessageForm.backCommand) {
            this.doBack();
        }
    }

    protected void doSelect(int n) {
        switch (n) {
            case 0: {
                this.showSettingsForm(n, 1);
                break;
            }
            case 1: {
                this.showSettingsForm(n, 2);
                break;
            }
            case 2: {
                this.showSettingsForm(n, 3);
                break;
            }
            case 3: {
                this.showSettingsForm(n, 4);
                break;
            }
            case 4: {
                Settings.defaults();
                Settings.saveSettings();
                Main.alertBackToMain(new Alert("Settings", "Default settings have been restored.", null, AlertType.INFO));
            }
        }
    }

    private void showSettingsForm(int n, int n2) {
        SettingsForm settingsForm = new SettingsForm(this.getString(n), n2);
        settingsForm.activate(this);
    }

    private void doBack() {
        this.back.activate();
    }

    public void activate() {
        Main.setDisplay((Displayable)this);
    }

    public void activate(Activatable activatable) {
        this.back = activatable;
        this.activate();
    }
}

