/*
 * Decompiled with CFR 0.152.
 */
package ssh;

import app.Settings;
import app.session.SshSession;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import ssh.SshMisc;
import ssh.SshPacket;
import ssh.v1.Cipher;
import ssh.v1.MD5;
import ssh.v1.SshCrypto;
import ssh.v1.SshPacket1;
import ssh.v2.DHKeyExchange;
import ssh.v2.SHA1Digest;
import ssh.v2.SshCrypto2;
import ssh.v2.SshPacket2;

public class SshIO {
    private static MD5 md5 = new MD5();
    private SshSession sshSession;
    private String idstr = "";
    private String idstr_sent = "SSH/JTA (c) Marcus Meissner, Matthias L. Jugel\n";
    private SshCrypto crypto = null;
    String cipher_type;
    public static Random rnd = new Random();
    private int remotemajor;
    private int remoteminor;
    private int mymajor;
    private int myminor;
    private int useprotocol;
    public String login;
    public String password;
    private String dataToSend = null;
    private byte lastPacketSentType;
    private int phase = 0;
    private final int PHASE_INIT;
    private final int PHASE_SSH_RECEIVE_PACKET;
    private final byte SSH_MSG_NONE;
    private final byte SSH_MSG_DISCONNECT;
    private final byte SSH_SMSG_PUBLIC_KEY = (byte)2;
    private final byte SSH_CMSG_SESSION_KEY = (byte)3;
    private final byte SSH_CMSG_USER = (byte)4;
    private final byte SSH_CMSG_AUTH_PASSWORD = (byte)9;
    private final byte SSH_CMSG_REQUEST_PTY = (byte)10;
    private final byte SSH_CMSG_EXEC_SHELL = (byte)12;
    private final byte SSH_SMSG_SUCCESS = (byte)14;
    private final byte SSH_SMSG_FAILURE = (byte)15;
    private final byte SSH_CMSG_STDIN_DATA = (byte)16;
    private final byte SSH_SMSG_STDOUT_DATA = (byte)17;
    private final byte SSH_SMSG_STDERR_DATA = (byte)18;
    private final byte SSH_SMSG_EXITSTATUS = (byte)20;
    private final byte SSH_MSG_IGNORE = (byte)32;
    private final byte SSH_CMSG_EXIT_CONFIRMATION = (byte)33;
    private final byte SSH_MSG_DEBUG = (byte)36;
    private static final byte SSH2_MSG_DISCONNECT = 1;
    private static final byte SSH2_MSG_IGNORE = 2;
    private static final byte SSH2_MSG_UNIMPLEMENTED = 3;
    private static final byte SSH2_MSG_SERVICE_REQUEST = 5;
    private static final byte SSH2_MSG_SERVICE_ACCEPT = 6;
    private static final byte SSH2_MSG_KEXINIT = 20;
    private static final byte SSH2_MSG_NEWKEYS = 21;
    private static final byte SSH2_MSG_KEXDH_INIT = 30;
    private static final byte SSH2_MSG_KEXDH_REPLY = 31;
    private static final byte SSH2_MSG_USERAUTH_REQUEST = 50;
    private static final byte SSH2_MSG_USERAUTH_FAILURE = 51;
    private static final byte SSH2_MSG_USERAUTH_SUCCESS = 52;
    private static final byte SSH2_MSG_USERAUTH_BANNER = 53;
    private static final byte SSH2_MSG_CHANNEL_OPEN = 90;
    private static final byte SSH2_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    private static final byte SSH2_MSG_CHANNEL_OPEN_FAILURE = 92;
    private static final byte SSH2_MSG_CHANNEL_WINDOW_ADJUST = 93;
    private static final byte SSH2_MSG_CHANNEL_DATA = 94;
    private static final byte SSH2_MSG_CHANNEL_EXTENDED_DATA = 95;
    private static final byte SSH2_MSG_CHANNEL_EOF = 96;
    private static final byte SSH2_MSG_CHANNEL_CLOSE = 97;
    private static final byte SSH2_MSG_CHANNEL_REQUEST = 98;
    private static final byte SSH2_MSG_CHANNEL_SUCCESS = 99;
    private static final byte SSH2_MSG_CHANNEL_FAILURE = 100;
    private String kexalgs;
    private String hostkeyalgs;
    private String encalgs2c;
    private String encalgc2s;
    private String macalgs2c;
    private String macalgc2s;
    private String compalgc2s;
    private String compalgs2c;
    private String langc2s;
    private String langs2;
    private int outgoingseq = 0;
    private int incomingseq = 0;
    private int SSH_CIPHER_NONE = 0;
    private int SSH_CIPHER_IDEA = 1;
    private int SSH_CIPHER_DES = 2;
    private int SSH_CIPHER_3DES = 3;
    private int SSH_CIPHER_TSS = 4;
    private int SSH_CIPHER_RC4 = 5;
    private int SSH_CIPHER_BLOWFISH = 6;
    private final int SSH_AUTH_RHOSTS;
    private final int SSH_AUTH_RSA;
    private final int SSH_AUTH_PASSWORD;
    private final int SSH_AUTH_RHOSTS_RSA;
    private boolean cansenddata = false;
    SshPacket currentpacket;
    byte[] one = new byte[1];
    private DHKeyExchange dhkex;
    private byte[] session_id;

    public SshIO(SshSession sshSession) {
        this.PHASE_INIT = 0;
        this.PHASE_SSH_RECEIVE_PACKET = 1;
        this.SSH_MSG_NONE = 0;
        this.SSH_MSG_DISCONNECT = 1;
        this.SSH_AUTH_RHOSTS = 1;
        this.SSH_AUTH_RSA = 2;
        this.SSH_AUTH_PASSWORD = 3;
        this.SSH_AUTH_RHOSTS_RSA = 4;
        this.sshSession = sshSession;
        this.crypto = null;
    }

    public void write(byte[] byArray) throws IOException {
        this.sshSession.sendData(byArray);
    }

    private void write(byte by) throws IOException {
        this.one[0] = by;
        this.write(this.one);
    }

    public void disconnect() {
        this.login = "";
        this.password = "";
        this.phase = 0;
        this.crypto = null;
    }

    protected void sendDisconnect() throws IOException {
        this.sendDisconnect(11, "Finished");
    }

    protected void sendDisconnect(int n, String string) throws IOException {
        if (this.useprotocol == 2) {
            SshPacket2 sshPacket2 = new SshPacket2(1);
            sshPacket2.putInt32(n);
            sshPacket2.putString(string);
            sshPacket2.putString("en");
            this.sendPacket2(sshPacket2);
        } else {
            SshPacket1 sshPacket1 = new SshPacket1(1);
            sshPacket1.putInt32(n);
            sshPacket1.putString(string);
            sshPacket1.putString("en");
            this.sendPacket1(sshPacket1);
        }
        this.disconnect();
    }

    public void sendData(byte[] byArray, int n, int n2) throws IOException {
        String string = new String(byArray, n, n2);
        this.dataToSend = this.dataToSend == null ? string : this.dataToSend + string;
        if (this.cansenddata) {
            if (this.useprotocol == 2) {
                SshPacket2 sshPacket2 = new SshPacket2(94);
                sshPacket2.putInt32(0);
                sshPacket2.putString(this.dataToSend);
                this.sendPacket2(sshPacket2);
            } else {
                this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
            }
            this.dataToSend = null;
        }
    }

    public byte[] handleSSH(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        if (this.phase == 0) {
            while (n < n3) {
                byte by = byArray[n++];
                this.idstr = this.idstr + (char)by;
                if (by != 10) continue;
                ++this.phase;
                this.remotemajor = Integer.parseInt(this.idstr.substring(4, 5));
                String string = this.idstr.substring(6, 8);
                if (!Character.isDigit(string.charAt(1))) {
                    string = string.substring(0, 1);
                }
                this.remoteminor = Integer.parseInt(string);
                if (this.remotemajor == 2) {
                    this.mymajor = 2;
                    this.myminor = 0;
                    this.useprotocol = 2;
                } else if (this.remoteminor == 99 && Settings.sshVersionPreferred == 2) {
                    this.mymajor = 2;
                    this.myminor = 0;
                    this.useprotocol = 2;
                } else {
                    this.mymajor = 1;
                    this.myminor = 5;
                    this.useprotocol = 1;
                }
                this.idstr_sent = "SSH-" + this.mymajor + "." + this.myminor + "-" + this.idstr_sent;
                this.write(this.idstr_sent.getBytes());
                if (this.useprotocol == 2) {
                    this.currentpacket = new SshPacket2(null);
                    continue;
                }
                this.currentpacket = new SshPacket1(null);
            }
            if (n == n3) {
                return "".getBytes();
            }
            return "SSH PHASE_INIT error\n".getBytes();
        }
        String string = "";
        while (n < n3) {
            n = this.currentpacket.addPayload(byArray, n, n3 - n);
            if (!this.currentpacket.isFinished()) continue;
            if (this.useprotocol == 1) {
                string = string + this.handlePacket1((SshPacket1)this.currentpacket);
                this.currentpacket = new SshPacket1(this.crypto);
                continue;
            }
            string = string + this.handlePacket2((SshPacket2)this.currentpacket);
            this.currentpacket = new SshPacket2((SshCrypto2)this.crypto);
        }
        return string.getBytes();
    }

    private String handlePacket1(SshPacket1 sshPacket1) throws IOException {
        switch (sshPacket1.getType()) {
            case 32: {
                return "";
            }
            case 1: {
                String string = sshPacket1.getString();
                this.disconnect();
                return string;
            }
            case 2: {
                byte[] byArray = sshPacket1.getBytes(8);
                byte[] byArray2 = sshPacket1.getBytes(4);
                byte[] byArray3 = sshPacket1.getMpInt();
                byte[] byArray4 = sshPacket1.getMpInt();
                byte[] byArray5 = sshPacket1.getBytes(4);
                byte[] byArray6 = sshPacket1.getMpInt();
                byte[] byArray7 = sshPacket1.getMpInt();
                byte[] byArray8 = sshPacket1.getBytes(4);
                byte[] byArray9 = sshPacket1.getBytes(4);
                byte[] byArray10 = sshPacket1.getBytes(4);
                String string = this.Send_SSH_CMSG_SESSION_KEY(byArray, byArray4, byArray7, byArray9, byArray3, byArray6);
                if (string != null) {
                    return string;
                }
                byte[] byArray11 = new byte[byArray6.length + byArray7.length];
                System.arraycopy(byArray7, 0, byArray11, 0, byArray7.length);
                System.arraycopy(byArray3, 0, byArray11, byArray7.length, byArray3.length);
                String string2 = this.fingerprint(byArray11);
                return string2 + "\r\n\r\n";
            }
            case 14: {
                if (this.lastPacketSentType == 3) {
                    this.Send_SSH_CMSG_USER();
                    break;
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "Empty password login.\r\n";
                }
                if (this.lastPacketSentType == 9) {
                    this.Send_SSH_CMSG_REQUEST_PTY();
                    return "Login & password accepted\r\n";
                }
                if (this.lastPacketSentType == 10) {
                    this.cansenddata = true;
                    if (this.dataToSend != null) {
                        this.Send_SSH_CMSG_STDIN_DATA(this.dataToSend);
                        this.dataToSend = null;
                    }
                    this.Send_SSH_CMSG_EXEC_SHELL();
                    break;
                }
                if (this.lastPacketSentType != 12) break;
                break;
            }
            case 15: {
                if (this.lastPacketSentType == 9) {
                    this.disconnect();
                    return "Login & password not accepted\r\n";
                }
                if (this.lastPacketSentType == 4) {
                    this.Send_SSH_CMSG_AUTH_PASSWORD();
                    break;
                }
                if (this.lastPacketSentType != 10) break;
                break;
            }
            case 17: {
                return sshPacket1.getString();
            }
            case 18: {
                String string = "Error : " + sshPacket1.getString();
                return string;
            }
            case 20: {
                int n = sshPacket1.getInt32();
                this.Send_SSH_CMSG_EXIT_CONFIRMATION();
                this.disconnect();
                break;
            }
            case 36: {
                String string = sshPacket1.getString();
                return "";
            }
        }
        return "";
    }

    private void sendPacket1(SshPacket1 sshPacket1) throws IOException {
        this.write(sshPacket1.getPayLoad(this.crypto));
        this.lastPacketSentType = sshPacket1.getType();
    }

    private String fingerprint(byte[] byArray) {
        MD5 mD5 = new MD5();
        byte[] byArray2 = mD5.digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray2[i] & 0xFF;
            String string = Integer.toHexString(n2);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
            if (i + 1 >= n) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    private String handlePacket2(SshPacket2 sshPacket2) throws IOException {
        switch (sshPacket2.getType()) {
            case 1: {
                int n = sshPacket2.getInt32();
                String string = sshPacket2.getString();
                return "\r\nDisconnected: " + string + "\r\n";
            }
            case 21: {
                this.sendPacket2(new SshPacket2(21));
                this.updateKeys(this.dhkex);
                SshPacket2 sshPacket22 = new SshPacket2(5);
                sshPacket22.putString("ssh-userauth");
                this.sendPacket2(sshPacket22);
                return "Requesting authentication\r\n";
            }
            case 6: {
                SshPacket2 sshPacket23 = new SshPacket2(50);
                sshPacket23.putString(this.login);
                sshPacket23.putString("ssh-connection");
                sshPacket23.putString("password");
                sshPacket23.putByte((byte)0);
                sshPacket23.putString(this.password);
                this.sendPacket2(sshPacket23);
                return "Sent authentication\r\n";
            }
            case 52: {
                SshPacket2 sshPacket24 = new SshPacket2(90);
                sshPacket24.putString("session");
                sshPacket24.putInt32(0);
                sshPacket24.putInt32(0x100000);
                sshPacket24.putInt32(16384);
                this.sendPacket2(sshPacket24);
                return "Authentication accepted\r\n";
            }
            case 91: {
                int n = sshPacket2.getInt32();
                int n2 = sshPacket2.getInt32();
                int n3 = sshPacket2.getInt32();
                int n4 = sshPacket2.getInt32();
                SshPacket2 sshPacket25 = new SshPacket2(98);
                sshPacket25.putInt32(n2);
                sshPacket25.putString("pty-req");
                sshPacket25.putByte((byte)0);
                sshPacket25.putString(this.getTerminalID());
                sshPacket25.putInt32(this.getTerminalWidth());
                sshPacket25.putInt32(this.getTerminalHeight());
                sshPacket25.putInt32(0);
                sshPacket25.putInt32(0);
                sshPacket25.putString("");
                this.sendPacket2(sshPacket25);
                sshPacket25 = new SshPacket2(98);
                sshPacket25.putInt32(n2);
                sshPacket25.putString("shell");
                sshPacket25.putByte((byte)0);
                this.sendPacket2(sshPacket25);
                this.cansenddata = true;
                return "Shell opened\r\n";
            }
            case 94: {
                int n = sshPacket2.getInt32();
                String string = sshPacket2.getString();
                return string;
            }
            case 51: {
                String string = sshPacket2.getString();
                byte by = sshPacket2.getByte();
                return "Login and password not accepted.\r\nAvailable methods are: " + string + "\r\n";
            }
            case 2: 
            case 53: 
            case 93: 
            case 96: 
            case 98: {
                break;
            }
            case 97: {
                this.sendDisconnect();
                break;
            }
            case 20: {
                byte[] byArray = sshPacket2.getBytes(16);
                String string = sshPacket2.getString();
                String string2 = sshPacket2.getString();
                String string3 = sshPacket2.getString();
                String string4 = sshPacket2.getString();
                String string5 = sshPacket2.getString();
                String string6 = sshPacket2.getString();
                String string7 = sshPacket2.getString();
                String string8 = sshPacket2.getString();
                String string9 = sshPacket2.getString();
                String string10 = sshPacket2.getString();
                byte[] byArray2 = sshPacket2.getBytes(1);
                SshPacket2 sshPacket26 = new SshPacket2(20);
                byte[] byArray3 = new byte[16];
                Random random = new Random();
                for (int i = 0; i < byArray3.length; ++i) {
                    byArray3[i] = (byte)random.nextInt();
                }
                sshPacket26.putBytes(byArray3);
                sshPacket26.putString("diffie-hellman-group1-sha1");
                sshPacket26.putString("ssh-dss");
                this.cipher_type = "DES3";
                String string11 = "3des-cbc";
                sshPacket26.putString(string11);
                sshPacket26.putString(string11);
                sshPacket26.putString("hmac-sha1");
                sshPacket26.putString("hmac-sha1");
                sshPacket26.putString("none");
                sshPacket26.putString("none");
                sshPacket26.putString("");
                sshPacket26.putString("");
                sshPacket26.putByte((byte)0);
                sshPacket26.putInt32(0);
                byte[] byArray4 = sshPacket26.getData();
                this.sendPacket2(sshPacket26);
                if (Settings.ssh2StoreKey) {
                    if (Settings.ssh2x == null || Settings.ssh2y == null) {
                        byte[][] byArray5 = DHKeyExchange.generateKeyPairBytes(Settings.ssh2KeySize);
                        Settings.ssh2x = byArray5[0];
                        Settings.ssh2y = byArray5[1];
                        Settings.saveSettings();
                    }
                    this.dhkex = new DHKeyExchange(Settings.ssh2x, Settings.ssh2y);
                } else {
                    this.dhkex = new DHKeyExchange(Settings.ssh2KeySize);
                }
                this.dhkex.setV_S(this.idstr.trim().getBytes());
                this.dhkex.setV_C(this.idstr_sent.trim().getBytes());
                this.dhkex.setI_S(this.add20(sshPacket2.getData()));
                this.dhkex.setI_C(this.add20(byArray4));
                sshPacket26 = new SshPacket2(30);
                sshPacket26.putMpInt(this.dhkex.getE());
                this.sendPacket2(sshPacket26);
                return "Negotiating...";
            }
            case 31: {
                byte[] byArray = sshPacket2.getByteString();
                byte[] byArray6 = sshPacket2.getMpInt();
                byte[] byArray7 = sshPacket2.getByteString();
                boolean bl = this.dhkex.next(byArray, byArray6, byArray7);
                if (bl) {
                    return "OK\r\n" + this.dhkex.getKeyAlg() + " " + this.fingerprint(byArray) + "\r\n\r\n";
                }
                this.sendDisconnect(3, "Key exchange failed");
                return "FAILED\r\n";
            }
            case 3: {
                return "SSH2: Unimplemented\r\n";
            }
            default: {
                return "SSH2: handlePacket2 Unknown type " + sshPacket2.getType() + "\r\n";
            }
        }
        return "";
    }

    private void sendPacket2(SshPacket2 sshPacket2) throws IOException {
        this.write(sshPacket2.getPayLoad((SshCrypto2)this.crypto, this.outgoingseq));
        ++this.outgoingseq;
        this.lastPacketSentType = sshPacket2.getType();
    }

    private void updateKeys(DHKeyExchange dHKeyExchange) {
        byte[] byArray;
        byte[] byArray2;
        int n;
        byte[] byArray3 = dHKeyExchange.getK();
        byte[] byArray4 = dHKeyExchange.getH();
        SHA1Digest sHA1Digest = new SHA1Digest();
        if (this.session_id == null) {
            this.session_id = new byte[byArray4.length];
            System.arraycopy(byArray4, 0, this.session_id, 0, byArray4.length);
        }
        SshPacket2 sshPacket2 = new SshPacket2(null);
        sshPacket2.putMpInt(byArray3);
        sshPacket2.putBytes(byArray4);
        sshPacket2.putByte((byte)65);
        sshPacket2.putBytes(this.session_id);
        byte[] byArray5 = sshPacket2.getData();
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray6 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray6, 0);
        int n2 = n = byArray5.length - this.session_id.length - 1;
        byArray5[n2] = (byte)(byArray5[n2] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray7 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray7, 0);
        int n3 = n;
        byArray5[n3] = (byte)(byArray5[n3] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray8 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray8, 0);
        int n4 = n;
        byArray5[n4] = (byte)(byArray5[n4] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray9 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray9, 0);
        int n5 = n;
        byArray5[n5] = (byte)(byArray5[n5] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray10 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray10, 0);
        int n6 = n;
        byArray5[n6] = (byte)(byArray5[n6] + 1);
        sHA1Digest.update(byArray5, 0, byArray5.length);
        byte[] byArray11 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray11, 0);
        int n7 = 24;
        while (n7 > byArray9.length) {
            sshPacket2 = new SshPacket2(null);
            sshPacket2.putMpInt(byArray3);
            sshPacket2.putBytes(byArray4);
            sshPacket2.putBytes(byArray9);
            byArray5 = sshPacket2.getData();
            sHA1Digest.update(byArray5, 0, byArray5.length);
            byArray2 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray2, 0);
            byArray = new byte[byArray9.length + byArray2.length];
            System.arraycopy(byArray9, 0, byArray, 0, byArray9.length);
            System.arraycopy(byArray2, 0, byArray, byArray9.length, byArray2.length);
            byArray9 = byArray;
        }
        while (n7 > byArray8.length) {
            sshPacket2 = new SshPacket2(null);
            sshPacket2.putMpInt(byArray3);
            sshPacket2.putBytes(byArray4);
            sshPacket2.putBytes(byArray8);
            byArray5 = sshPacket2.getData();
            sHA1Digest.update(byArray5, 0, byArray5.length);
            byArray2 = new byte[sHA1Digest.getDigestSize()];
            sHA1Digest.doFinal(byArray2, 0);
            byArray = new byte[byArray8.length + byArray2.length];
            System.arraycopy(byArray8, 0, byArray, 0, byArray8.length);
            System.arraycopy(byArray2, 0, byArray, byArray8.length, byArray2.length);
            byArray8 = byArray;
        }
        this.crypto = new SshCrypto2(byArray6, byArray7, byArray8, byArray9, byArray10, byArray11);
    }

    private byte[] add20(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = 20;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return byArray2;
    }

    private String Send_SSH_CMSG_SESSION_KEY(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws IOException {
        byte by;
        byte[] byArray7 = new byte[byArray3.length + byArray2.length + byArray.length];
        System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
        System.arraycopy(byArray2, 0, byArray7, byArray3.length, byArray2.length);
        System.arraycopy(byArray, 0, byArray7, byArray3.length + byArray2.length, byArray.length);
        byte[] byArray8 = md5.digest(byArray7);
        if ((byArray4[3] & (byte)(1 << this.SSH_CIPHER_BLOWFISH)) != 0 && this.hasCipher("Blowfish")) {
            by = (byte)this.SSH_CIPHER_BLOWFISH;
            this.cipher_type = "Blowfish";
        } else if ((byArray4[3] & 1 << this.SSH_CIPHER_IDEA) != 0 && this.hasCipher("IDEA")) {
            by = (byte)this.SSH_CIPHER_IDEA;
            this.cipher_type = "IDEA";
        } else if ((byArray4[3] & 1 << this.SSH_CIPHER_3DES) != 0 && this.hasCipher("DES3")) {
            by = (byte)this.SSH_CIPHER_3DES;
            this.cipher_type = "DES3";
        } else if ((byArray4[3] & 1 << this.SSH_CIPHER_DES) != 0 && this.hasCipher("DES")) {
            by = (byte)this.SSH_CIPHER_DES;
            this.cipher_type = "DES";
        } else {
            this.disconnect();
            return "\rIncompatible ciphers, closing connection.\r\n";
        }
        byte[] byArray9 = new byte[16];
        byte[] byArray10 = new byte[16];
        byArray9 = md5.digest(("" + rnd.nextLong() * new Date().getTime()).getBytes());
        byArray10 = byArray9;
        byArray9 = md5.digest(SshMisc.addArrayOfBytes(md5.digest((this.password + this.login).getBytes()), byArray9));
        byArray10 = md5.digest(SshMisc.addArrayOfBytes(md5.digest((this.password + this.login).getBytes()), byArray10));
        byte[] byArray11 = SshMisc.addArrayOfBytes(byArray9, byArray10);
        byte[] byArray12 = SshMisc.XORArrayOfBytes(byArray9, byArray8);
        byArray12 = SshMisc.addArrayOfBytes(byArray12, byArray10);
        byte[] byArray13 = byArray2.length <= byArray3.length ? SshCrypto.encrypteRSAPkcs1Twice(byArray12, byArray5, byArray2, byArray6, byArray3) : SshCrypto.encrypteRSAPkcs1Twice(byArray12, byArray6, byArray3, byArray5, byArray2);
        int n = 0;
        SshPacket1 sshPacket1 = new SshPacket1(3);
        sshPacket1.putByte(by);
        sshPacket1.putBytes(byArray);
        sshPacket1.putBytes(byArray13);
        sshPacket1.putInt32(n);
        this.sendPacket1(sshPacket1);
        this.crypto = new SshCrypto(this.cipher_type, byArray11);
        return null;
    }

    private boolean hasCipher(String string) {
        return Cipher.getInstance(string) != null;
    }

    private String Send_SSH_CMSG_USER() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(4);
        sshPacket1.putString(this.login);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_AUTH_PASSWORD() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(9);
        sshPacket1.putString(this.password);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_EXEC_SHELL() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(12);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_STDIN_DATA(String string) throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(16);
        sshPacket1.putString(string);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_REQUEST_PTY() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(10);
        sshPacket1.putString(this.getTerminalID());
        sshPacket1.putInt32(this.getTerminalHeight());
        sshPacket1.putInt32(this.getTerminalWidth());
        sshPacket1.putInt32(0);
        sshPacket1.putInt32(0);
        sshPacket1.putByte((byte)0);
        this.sendPacket1(sshPacket1);
        return "";
    }

    private String Send_SSH_CMSG_EXIT_CONFIRMATION() throws IOException {
        SshPacket1 sshPacket1 = new SshPacket1(33);
        this.sendPacket1(sshPacket1);
        return "";
    }

    public String Send_SSH_NOOP() throws IOException {
        if (this.useprotocol == 1) {
            SshPacket1 sshPacket1 = new SshPacket1(0);
            this.sendPacket1(sshPacket1);
        } else {
            SshPacket2 sshPacket2 = new SshPacket2(2);
            sshPacket2.putString("");
            this.sendPacket2(sshPacket2);
        }
        return "";
    }

    protected String getTerminalID() {
        return this.sshSession.getTerminalID();
    }

    protected int getTerminalHeight() {
        return this.sshSession.getTerminalHeight();
    }

    protected int getTerminalWidth() {
        return this.sshSession.getTerminalWidth();
    }
}

