/*
 * Decompiled with CFR 0.152.
 */
package ssh.v1;

import ssh.SshMisc;
import ssh.SshPacket;
import ssh.v1.BigInteger;
import ssh.v1.SshCrypto;

public class SshPacket1
extends SshPacket {
    private static final boolean debug = false;
    private byte[] packet_length_array = new byte[4];
    private int packet_length = 0;
    private byte[] padding = null;
    private byte[] crc_array = new byte[4];
    private byte[] block = null;
    private byte[] encryptedBlock = null;
    private byte[] decryptedBlock = null;
    private SshCrypto crypto = null;
    private int position = 0;
    private int phase_packet = 0;
    private static final int PHASE_packet_length = 0;
    private static final int PHASE_block = 1;

    public SshPacket1(SshCrypto sshCrypto) {
        this.position = 0;
        this.phase_packet = 0;
        this.crypto = sshCrypto;
    }

    public SshPacket1(byte by) {
        this.setType(by);
    }

    public byte[] getMpInt() {
        return this.getBytes((this.getInt16() + 7) / 8);
    }

    public void putMpInt(byte[] byArray) {
        int n;
        for (n = 0; n < byArray.length && byArray[n] == 0; ++n) {
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, n, byArray2, 0, byArray.length - n);
        this.putInt16(byArray2.length * 8);
        this.putBytes(byArray2);
    }

    public void putMpInt(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        this.putMpInt(byArray);
    }

    public byte[] getPayLoad(SshCrypto sshCrypto) {
        int n;
        byte[] byArray = this.getData();
        this.packet_length = byArray != null ? byArray.length + 5 : 5;
        this.packet_length_array[3] = (byte)(this.packet_length & 0xFF);
        this.packet_length_array[2] = (byte)(this.packet_length >> 8 & 0xFF);
        this.packet_length_array[1] = (byte)(this.packet_length >> 16 & 0xFF);
        this.packet_length_array[0] = (byte)(this.packet_length >> 24 & 0xFF);
        this.padding = new byte[8 - this.packet_length % 8];
        if (sshCrypto == null) {
            for (n = 0; n < this.padding.length; ++n) {
                this.padding[n] = 0;
            }
        } else {
            for (n = 0; n < this.padding.length; ++n) {
                this.padding[n] = SshMisc.getNotZeroRandomByte();
            }
        }
        this.block = new byte[this.packet_length + this.padding.length];
        System.arraycopy(this.padding, 0, this.block, 0, this.padding.length);
        n = this.padding.length;
        this.block[n++] = this.getType();
        if (this.packet_length > 5) {
            System.arraycopy(byArray, 0, this.block, n, byArray.length);
            n += byArray.length;
        }
        long l = SshMisc.crc32(this.block, n);
        this.crc_array[3] = (byte)(l & 0xFFL);
        this.crc_array[2] = (byte)(l >> 8 & 0xFFL);
        this.crc_array[1] = (byte)(l >> 16 & 0xFFL);
        this.crc_array[0] = (byte)(l >> 24 & 0xFFL);
        System.arraycopy(this.crc_array, 0, this.block, n, 4);
        if (sshCrypto != null) {
            this.block = sshCrypto.encrypt(this.block);
        }
        byte[] byArray2 = new byte[this.block.length + 4];
        System.arraycopy(this.packet_length_array, 0, byArray2, 0, 4);
        System.arraycopy(this.block, 0, byArray2, 4, this.block.length);
        return byArray2;
    }

    public int addPayload(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position++] = byArray[n++];
                    if (this.position < 4) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    this.position = 0;
                    ++this.phase_packet;
                    if (this.packet_length > 262144) {
                        throw new IllegalStateException("SshPacket1: Invalid packet_length " + this.packet_length);
                    }
                    int n4 = 8 * (this.packet_length / 8 + 1);
                    this.block = new byte[n4];
                    break;
                }
                case 1: {
                    byte[] byArray2;
                    int n4;
                    if (this.block.length > this.position && n < n3) {
                        n4 = n3 - n;
                        if (n4 > this.block.length - this.position) {
                            n4 = this.block.length - this.position;
                        }
                        System.arraycopy(byArray, n, this.block, this.position, n4);
                        n += n4;
                        this.position += n4;
                    }
                    if (this.position != this.block.length) break;
                    n4 = 0;
                    int n5 = 8 - this.packet_length % 8;
                    this.padding = new byte[n5];
                    this.decryptedBlock = this.crypto != null ? this.crypto.decrypt(this.block) : this.block;
                    if (this.decryptedBlock.length != n5 + this.packet_length) {
                        throw new IllegalStateException("SshPacket1: invalid decrypted packet length");
                    }
                    for (int i = 0; i < this.padding.length; ++i) {
                        this.padding[i] = this.decryptedBlock[n4++];
                    }
                    this.setType(this.decryptedBlock[n4++]);
                    if (this.packet_length > 5) {
                        byArray2 = new byte[this.packet_length - 5];
                        System.arraycopy(this.decryptedBlock, n4, byArray2, 0, this.packet_length - 5);
                        n4 += this.packet_length - 5;
                    } else {
                        byArray2 = null;
                    }
                    this.putData(byArray2);
                    for (int i = 0; i < this.crc_array.length; ++i) {
                        this.crc_array[i] = this.decryptedBlock[n4++];
                    }
                    if (!this.checkCrc()) {
                        throw new IllegalStateException("SshPacket1: CRC wrong in received packet!");
                    }
                    return n;
                }
            }
        }
        return n;
    }

    private boolean checkCrc() {
        byte[] byArray = new byte[4];
        long l = SshMisc.crc32(this.decryptedBlock, this.decryptedBlock.length - 4);
        byArray[3] = (byte)(l & 0xFFL);
        byArray[2] = (byte)(l >> 8 & 0xFFL);
        byArray[1] = (byte)(l >> 16 & 0xFFL);
        byArray[0] = (byte)(l >> 24 & 0xFFL);
        if (byArray[3] != this.crc_array[3]) {
            return false;
        }
        if (byArray[2] != this.crc_array[2]) {
            return false;
        }
        if (byArray[1] != this.crc_array[1]) {
            return false;
        }
        return byArray[0] == this.crc_array[0];
    }
}

