/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import java.util.Random;
import ssh.v2.BigInteger;
import ssh.v2.DSASigner;
import ssh.v2.SHA1Digest;
import ssh.v2.SshPacket2;

public class DHKeyExchange {
    public static final BigInteger g = new BigInteger(new byte[]{2});
    public static final BigInteger p = new BigInteger(new byte[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -55, 15, -38, -94, 33, 104, -62, 52, -60, -58, 98, -117, -128, -36, 28, -47, 41, 2, 78, 8, -118, 103, -52, 116, 2, 11, -66, -90, 59, 19, -101, 34, 81, 74, 8, 121, -114, 52, 4, -35, -17, -107, 25, -77, -51, 58, 67, 27, 48, 43, 10, 109, -14, 95, 20, 55, 79, -31, 53, 109, 109, 81, -62, 69, -28, -123, -75, 118, 98, 94, 126, -58, -12, 76, 66, -23, -90, 55, -19, 107, 11, -1, 92, -74, -12, 6, -73, -19, -18, 56, 107, -5, 90, -119, -97, -91, -82, -97, 36, 17, 124, 75, 31, -26, 73, 40, 102, 81, -20, -26, 83, -127, -1, -1, -1, -1, -1, -1, -1, -1});
    static final int RSA = 0;
    static final int DSS = 1;
    private byte[] V_S;
    private byte[] V_C;
    private byte[] I_S;
    private byte[] I_C;
    private byte[] K_S;
    private byte[] H;
    private byte[] e;
    private byte[] f;
    private byte[] K;
    private BigInteger x;
    private BigInteger y;
    private String keyalg;

    public DHKeyExchange(int n) {
        BigInteger[] bigIntegerArray = DHKeyExchange.generateKeyPair(n);
        this.x = bigIntegerArray[0];
        this.y = bigIntegerArray[1];
    }

    public DHKeyExchange(byte[] byArray, byte[] byArray2) {
        this.x = new BigInteger(byArray);
        this.y = new BigInteger(byArray2);
    }

    public byte[] getE() {
        if (this.e == null) {
            this.e = this.y.toByteArray();
        }
        return this.e;
    }

    public static BigInteger[] generateKeyPair(int n) {
        n = Math.min(n, p.bitLength() - 1 - 1);
        BigInteger bigInteger = new BigInteger(n, new Random());
        BigInteger bigInteger2 = g.modPow(bigInteger, p);
        return new BigInteger[]{bigInteger, bigInteger2};
    }

    public static byte[][] generateKeyPairBytes(int n) {
        BigInteger[] bigIntegerArray = DHKeyExchange.generateKeyPair(n);
        return new byte[][]{bigIntegerArray[0].toByteArray(), bigIntegerArray[1].toByteArray()};
    }

    private BigInteger calculateAgreement(BigInteger bigInteger) {
        return bigInteger.modPow(this.x, p);
    }

    public byte[] getK() {
        if (this.K == null) {
            this.K = this.calculateAgreement(new BigInteger(this.f)).toByteArray();
        }
        return this.K;
    }

    public boolean next(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        boolean bl;
        this.f = byArray2;
        this.getK();
        SshPacket2 sshPacket2 = new SshPacket2(null);
        sshPacket2.putString(this.V_C);
        sshPacket2.putString(this.V_S);
        sshPacket2.putString(this.I_C);
        sshPacket2.putString(this.I_S);
        sshPacket2.putString(byArray);
        sshPacket2.putMpInt(this.e);
        sshPacket2.putMpInt(byArray2);
        sshPacket2.putMpInt(this.K);
        byte[] byArray4 = sshPacket2.getData();
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray4, 0, byArray4.length);
        this.H = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(this.H, 0);
        SshPacket2 sshPacket22 = new SshPacket2(null);
        sshPacket22.putBytes(byArray);
        this.keyalg = sshPacket22.getString();
        if (this.keyalg.equals("ssh-dss")) {
            byte[] byArray5 = sshPacket22.getByteString();
            byte[] byArray6 = sshPacket22.getByteString();
            byte[] byArray7 = sshPacket22.getByteString();
            byte[] byArray8 = sshPacket22.getByteString();
            DSASigner dSASigner = new DSASigner();
            dSASigner.setY(new BigInteger(byArray8));
            dSASigner.setP(new BigInteger(byArray5));
            dSASigner.setQ(new BigInteger(byArray6));
            dSASigner.setG(new BigInteger(byArray7));
            bl = dSASigner.verifySignature(this.H, byArray3);
        } else {
            bl = false;
        }
        return bl;
    }

    public void setI_C(byte[] byArray) {
        this.I_C = byArray;
    }

    public void setI_S(byte[] byArray) {
        this.I_S = byArray;
    }

    public void setV_C(byte[] byArray) {
        this.V_C = byArray;
    }

    public void setV_S(byte[] byArray) {
        this.V_S = byArray;
    }

    public byte[] getH() {
        return this.H;
    }

    public String getKeyAlg() {
        return this.keyalg;
    }
}

