/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import ssh.v2.BigInteger;
import ssh.v2.SHA1Digest;
import ssh.v2.SshPacket2;

public class DSASigner {
    private BigInteger x;
    private BigInteger y;
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        SshPacket2 sshPacket2 = new SshPacket2(null);
        sshPacket2.putBytes(byArray2);
        byte[] byArray3 = sshPacket2.getByteString();
        byte[] byArray4 = sshPacket2.getByteString();
        int n = byArray4.length / 2;
        byte[] byArray5 = new byte[n];
        byArray5[0] = 0;
        System.arraycopy(byArray4, 0, byArray5, 0, n);
        BigInteger bigInteger = new BigInteger(1, byArray5);
        System.arraycopy(byArray4, n, byArray5, 0, n);
        BigInteger bigInteger2 = new BigInteger(1, byArray5);
        return this.verifySignature(byArray, bigInteger, bigInteger2);
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        SHA1Digest sHA1Digest = new SHA1Digest();
        sHA1Digest.update(byArray, 0, byArray.length);
        byte[] byArray2 = new byte[sHA1Digest.getDigestSize()];
        sHA1Digest.doFinal(byArray2, 0);
        byArray = byArray2;
        BigInteger bigInteger3 = new BigInteger(1, byArray);
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) >= 0 || this.q.compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 || this.q.compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(this.q);
        BigInteger bigInteger6 = bigInteger3.multiply(bigInteger5).mod(this.q);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(this.q);
        bigInteger6 = this.g.modPow(bigInteger6, this.p);
        bigInteger7 = this.y.modPow(bigInteger7, this.p);
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(this.p).mod(this.q);
        return bigInteger8.equals(bigInteger);
    }

    public void setX(BigInteger bigInteger) {
        this.x = bigInteger;
    }

    public void setY(BigInteger bigInteger) {
        this.y = bigInteger;
    }

    public void setG(BigInteger bigInteger) {
        this.g = bigInteger;
    }

    public void setP(BigInteger bigInteger) {
        this.p = bigInteger;
    }

    public void setQ(BigInteger bigInteger) {
        this.q = bigInteger;
    }
}

