/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import ssh.v2.HMac;
import ssh.v2.SHA1Digest;

public class HMACSHA1 {
    private String name = "hmac-sha1";
    private int bsize = 20;
    private HMac mac;
    private byte[] tmp = new byte[4];

    public int getBlockSize() {
        return this.bsize;
    }

    public void init(byte[] byArray) {
        if (byArray.length > this.bsize) {
            byte[] byArray2 = new byte[this.bsize];
            System.arraycopy(byArray, 0, byArray2, 0, this.bsize);
            byArray = byArray2;
        }
        this.mac = new HMac(new SHA1Digest());
        this.mac.init(byArray);
    }

    public void update(int n) {
        this.tmp[0] = (byte)(n >>> 24);
        this.tmp[1] = (byte)(n >>> 16);
        this.tmp[2] = (byte)(n >>> 8);
        this.tmp[3] = (byte)n;
        this.update(this.tmp, 0, 4);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.mac.update(byArray, n, n2);
    }

    public byte[] doFinal() {
        byte[] byArray = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray, 0);
        return byArray;
    }

    public String getName() {
        return this.name;
    }
}

