/*
 * Decompiled with CFR 0.152.
 */
package ssh.v2;

import java.io.IOException;
import ssh.SshMisc;
import ssh.SshPacket;
import ssh.v2.HMACSHA1;
import ssh.v2.SshCrypto2;

public class SshPacket2
extends SshPacket {
    private static final boolean debug = true;
    private byte[] packet_length_array = new byte[8];
    private int packet_length = 0;
    private int padlen = 0;
    private byte[] crc_array = new byte[4];
    private int position = 0;
    private int phase_packet = 0;
    private final int PHASE_packet_length;
    private final int PHASE_block;
    private SshCrypto2 crypto = null;
    private byte[] block;

    public SshPacket2(SshCrypto2 sshCrypto2) {
        this.PHASE_packet_length = 0;
        this.PHASE_block = 1;
        this.position = 0;
        this.phase_packet = 0;
        this.crypto = sshCrypto2;
    }

    public SshPacket2(byte by) {
        this.PHASE_packet_length = 0;
        this.PHASE_block = 1;
        this.setType(by);
    }

    public byte[] getMpInt() {
        return this.getBytes(this.getInt32());
    }

    public void putMpInt(byte[] byArray) {
        int n = byArray.length;
        if ((byArray[0] & 0x80) != 0) {
            this.putInt32(++n);
            this.putByte((byte)0);
        } else {
            this.putInt32(n);
        }
        this.putBytes(byArray);
    }

    public byte[] getPayLoad(SshCrypto2 sshCrypto2, long l) throws IOException {
        Object object;
        int n;
        int n2;
        byte[] byArray = this.getData();
        int n3 = 8;
        this.packet_length = 6;
        if (byArray != null) {
            this.packet_length += byArray.length;
        }
        if ((n2 = n3 - this.packet_length % n3) < 4) {
            n2 += n3;
        }
        byte[] byArray2 = new byte[n2];
        if (sshCrypto2 == null) {
            for (n = 0; n < n2; ++n) {
                byArray2[n] = 0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                byArray2[n] = SshMisc.getNotZeroRandomByte();
            }
        }
        byte[] byArray3 = new byte[this.packet_length + n2];
        int n4 = n2 + this.packet_length - 4;
        byArray3[3] = (byte)(n4 & 0xFF);
        byArray3[2] = (byte)(n4 >> 8 & 0xFF);
        byArray3[1] = (byte)(n4 >> 16 & 0xFF);
        byArray3[0] = (byte)(n4 >> 24 & 0xFF);
        byArray3[4] = (byte)n2;
        byArray3[5] = this.getType();
        System.arraycopy(byArray, 0, byArray3, 6, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, 6 + byArray.length, n2);
        byte[] byArray4 = null;
        if (sshCrypto2 != null && (object = sshCrypto2.getSndHmac()) != null) {
            ((HMACSHA1)object).update((int)l);
            ((HMACSHA1)object).update(byArray3, 0, byArray3.length);
            byArray4 = ((HMACSHA1)object).doFinal();
        }
        if (sshCrypto2 != null) {
            byArray3 = sshCrypto2.encrypt(byArray3);
        }
        object = new byte[byArray3.length + (byArray4 != null ? byArray4.length : 0)];
        System.arraycopy(byArray3, 0, object, 0, byArray3.length);
        if (byArray4 != null) {
            System.arraycopy(byArray4, 0, object, byArray3.length, byArray4.length);
        }
        return object;
    }

    public int addPayload(byte[] byArray, int n, int n2) {
        Object var5_4 = null;
        int n3 = 0;
        int n4 = n + n2;
        if (this.crypto != null) {
            n3 = this.crypto.getRcvHmac().getBlockSize();
        }
        while (n < n4) {
            switch (this.phase_packet) {
                case 0: {
                    this.packet_length_array[this.position++] = byArray[n++];
                    if (this.position != 8) break;
                    this.packet_length = (this.packet_length_array[3] & 0xFF) + ((this.packet_length_array[2] & 0xFF) << 8) + ((this.packet_length_array[1] & 0xFF) << 16) + ((this.packet_length_array[0] & 0xFF) << 24);
                    byte[] byArray2 = this.crypto != null ? this.crypto.decrypt(this.packet_length_array) : this.packet_length_array;
                    this.packet_length = (byArray2[3] & 0xFF) + ((byArray2[2] & 0xFF) << 8) + ((byArray2[1] & 0xFF) << 16) + ((byArray2[0] & 0xFF) << 24);
                    this.padlen = byArray2[4];
                    this.position = 3;
                    this.packet_length += n3;
                    this.block = new byte[this.packet_length - 1];
                    System.arraycopy(byArray2, 5, this.block, 0, 3);
                    ++this.phase_packet;
                    break;
                }
                case 1: {
                    if (this.block.length > this.position && n < n4) {
                        int n5 = n4 - n;
                        if (n5 > this.block.length - this.position) {
                            n5 = this.block.length - this.position;
                        }
                        System.arraycopy(byArray, n, this.block, this.position, n5);
                        n += n5;
                        this.position += n5;
                    }
                    if (this.position != this.block.length) break;
                    this.packet_length -= n3;
                    byte[] byArray3 = new byte[this.block.length - n3 - 3];
                    System.arraycopy(this.block, 3, byArray3, 0, byArray3.length);
                    if (this.crypto != null) {
                        byArray3 = this.crypto.decrypt(byArray3);
                    }
                    byte[] byArray4 = new byte[byArray3.length + 3];
                    System.arraycopy(this.block, 0, byArray4, 0, 3);
                    System.arraycopy(byArray3, 0, byArray4, 3, byArray3.length);
                    byArray3 = byArray4;
                    this.setType(byArray3[0]);
                    if (this.packet_length > this.padlen + 1 + 1) {
                        byte[] byArray5 = new byte[this.packet_length - 2 - this.padlen];
                        System.arraycopy(byArray3, 1, byArray5, 0, byArray5.length);
                        this.putData(byArray5);
                    } else {
                        this.putData(null);
                    }
                    return n;
                }
            }
        }
        return n;
    }
}

