/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import java.io.IOException;
import telnet.Dimension;

public abstract class TelnetProtocolHandler {
    private byte[] tempbuf = new byte[0];
    private byte[] crlf = new byte[2];
    private byte[] cr = new byte[2];
    private byte neg_state = 0;
    private static final byte STATE_DATA = 0;
    private static final byte STATE_IAC = 1;
    private static final byte STATE_IACSB = 2;
    private static final byte STATE_IACWILL = 3;
    private static final byte STATE_IACDO = 4;
    private static final byte STATE_IACWONT = 5;
    private static final byte STATE_IACDONT = 6;
    private static final byte STATE_IACSBIAC = 7;
    private static final byte STATE_IACSBDATA = 8;
    private static final byte STATE_IACSBDATAIAC = 9;
    private byte current_sb;
    private static final byte IAC = -1;
    private static final byte EOR = -17;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte NOP = -15;
    private static final byte SE = -16;
    private static final byte TELOPT_BINARY = 0;
    private static final byte TELOPT_ECHO = 1;
    private static final byte TELOPT_SGA = 3;
    private static final byte TELOPT_EOR = 25;
    private static final byte TELOPT_NAWS = 31;
    private static final byte TELOPT_TTYPE = 24;
    private static final byte[] IACWILL = new byte[]{-1, -5};
    private static final byte[] IACWONT = new byte[]{-1, -4};
    private static final byte[] IACDO = new byte[]{-1, -3};
    private static final byte[] IACDONT = new byte[]{-1, -2};
    private static final byte[] IACSB = new byte[]{-1, -6};
    private static final byte[] IACSE = new byte[]{-1, -16};
    private static final byte TELQUAL_IS = 0;
    private static final byte TELQUAL_SEND = 1;
    private byte[] receivedDX;
    private byte[] receivedWX;
    private byte[] sentDX;
    private byte[] sentWX;

    public TelnetProtocolHandler() {
        this.reset();
        this.crlf[0] = 13;
        this.crlf[1] = 10;
        this.cr[0] = 13;
        this.cr[1] = 0;
    }

    protected abstract String getTerminalType();

    protected abstract Dimension getWindowSize();

    protected abstract void setLocalEcho(boolean var1);

    protected abstract void notifyEndOfRecord();

    protected abstract void write(byte[] var1) throws IOException;

    public void reset() {
        this.neg_state = 0;
        this.receivedDX = new byte[256];
        this.sentDX = new byte[256];
        this.receivedWX = new byte[256];
        this.sentWX = new byte[256];
    }

    public void sendTelnetControl(byte by) throws IOException {
        byte[] byArray = new byte[]{-1, by};
        this.write(byArray);
    }

    public void sendTelnetNOP() throws IOException {
        this.sendTelnetControl((byte)-15);
    }

    private void handle_sb(byte by, byte[] byArray, int n) throws IOException {
        switch (by) {
            case 24: {
                if (n <= 0 || byArray[0] != 1) break;
                this.write(new byte[]{-1, -6, 24, 0});
                String string = this.getTerminalType();
                this.write(string.getBytes());
                this.write(IACSE);
            }
        }
    }

    public void startup() throws IOException {
    }

    public void transpose(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        int n3 = 0;
        int n4 = n + n2;
        byte[] byArray3 = new byte[n2 * 2];
        block4: for (int i = n; i < n4; ++i) {
            switch (byArray[i]) {
                case -1: {
                    byArray3[n3++] = -1;
                    byArray3[n3++] = -1;
                    continue block4;
                }
                case 10: 
                case 13: {
                    if (this.receivedDX[128] != -3) {
                        while (byArray3.length - n3 < this.crlf.length) {
                            byArray2 = new byte[byArray3.length * 2];
                            System.arraycopy(byArray3, 0, byArray2, 0, n3);
                            byArray3 = byArray2;
                        }
                        for (int j = 0; j < this.crlf.length; ++j) {
                            byArray3[n3++] = this.crlf[j];
                        }
                        continue block4;
                    }
                    byArray3[n3++] = byArray[i];
                    continue block4;
                }
                default: {
                    byArray3[n3++] = byArray[i];
                }
            }
        }
        byArray2 = new byte[n3];
        System.arraycopy(byArray3, 0, byArray2, 0, n3);
        this.write(byArray2);
    }

    public void setCRLF(String string) {
        this.crlf = string.getBytes();
    }

    public void setCR(String string) {
        this.cr = string.getBytes();
    }

    public int negotiate(byte[] byArray, int n, int n2) throws IOException {
        Object object;
        byte[] byArray2 = new byte[this.tempbuf.length];
        int n3 = this.tempbuf.length;
        byte[] byArray3 = this.tempbuf;
        byte[] byArray4 = new byte[3];
        int n4 = 0;
        int n5 = 0;
        int n6 = n;
        boolean bl = false;
        int n7 = n + n2;
        if (n3 == 0) {
            return -1;
        }
        block57: while (!bl && n5 < n3 && n < n7) {
            byte by;
            if ((by = byArray3[n5++]) >= 128) {
                by = (byte)(by - 256);
            }
            switch (this.neg_state) {
                case 0: {
                    if (by == -1) {
                        this.neg_state = 1;
                        bl = true;
                        continue block57;
                    }
                    byArray[n++] = by;
                    continue block57;
                }
                case 1: {
                    switch (by) {
                        case -1: {
                            this.neg_state = 0;
                            byArray[n++] = -1;
                            continue block57;
                        }
                        case -5: {
                            this.neg_state = (byte)3;
                            continue block57;
                        }
                        case -4: {
                            this.neg_state = (byte)5;
                            continue block57;
                        }
                        case -2: {
                            this.neg_state = (byte)6;
                            continue block57;
                        }
                        case -3: {
                            this.neg_state = (byte)4;
                            continue block57;
                        }
                        case -17: {
                            this.notifyEndOfRecord();
                            bl = true;
                            this.neg_state = 0;
                            continue block57;
                        }
                        case -6: {
                            this.neg_state = (byte)2;
                            n4 = 0;
                            continue block57;
                        }
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 3: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -3;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            by2 = -3;
                            break;
                        }
                        case 25: {
                            by2 = -3;
                            break;
                        }
                        case 0: {
                            by2 = -3;
                            break;
                        }
                        default: {
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -5 != this.receivedWX[by + 128]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.write(byArray4);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 5: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            this.setLocalEcho(true);
                            by2 = -2;
                            break;
                        }
                        case 3: {
                            by2 = -2;
                            break;
                        }
                        case 25: {
                            by2 = -2;
                            break;
                        }
                        case 0: {
                            by2 = -2;
                            break;
                        }
                        default: {
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -4 != this.receivedWX[by + 128]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.write(byArray4);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 4: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -5;
                            this.setLocalEcho(true);
                            break;
                        }
                        case 3: {
                            by2 = -5;
                            break;
                        }
                        case 24: {
                            by2 = -5;
                            break;
                        }
                        case 0: {
                            by2 = -5;
                            break;
                        }
                        case 31: {
                            object = this.getWindowSize();
                            this.receivedDX[by] = -3;
                            if (object == null) {
                                this.write(new byte[]{-1, -4, 31});
                                by2 = -4;
                                this.sentWX[by] = -4;
                                break;
                            }
                            by2 = -5;
                            this.sentWX[by] = -5;
                            byArray4[0] = -1;
                            byArray4[1] = -5;
                            byArray4[2] = 31;
                            this.write(byArray4);
                            this.write(new byte[]{-1, -6, 31, (byte)(object.width >> 8), (byte)(object.width & 0xFF), (byte)(object.height >> 8), (byte)(object.height & 0xFF), -1, -16});
                            break;
                        }
                        default: {
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[128 + by] || -3 != this.receivedDX[128 + by]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.write(byArray4);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -3;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 6: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            by2 = -4;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            by2 = -4;
                            break;
                        }
                        case 31: {
                            by2 = -4;
                            break;
                        }
                        case 0: {
                            by2 = -4;
                            break;
                        }
                        default: {
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[by + 128] || -2 != this.receivedDX[by + 128]) {
                        this.write(new byte[]{-1, by2, by});
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -2;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 7: {
                    if (by == -1) {
                        n4 = 0;
                        this.current_sb = by;
                        this.neg_state = (byte)8;
                        continue block57;
                    }
                    this.neg_state = 0;
                    continue block57;
                }
                case 2: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)7;
                            continue block57;
                        }
                    }
                    this.current_sb = by;
                    n4 = 0;
                    this.neg_state = (byte)8;
                    continue block57;
                }
                case 8: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)9;
                            continue block57;
                        }
                    }
                    byArray2[n4++] = by;
                    continue block57;
                }
                case 9: {
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)8;
                            byArray2[n4++] = -1;
                            continue block57;
                        }
                        case -16: {
                            this.handle_sb(this.current_sb, byArray2, n4);
                            this.current_sb = 0;
                            this.neg_state = 0;
                            continue block57;
                        }
                        case -6: {
                            this.handle_sb(this.current_sb, byArray2, n4);
                            this.neg_state = (byte)2;
                            continue block57;
                        }
                    }
                    this.neg_state = 0;
                    continue block57;
                }
            }
            this.neg_state = 0;
        }
        object = new byte[n3 - n5];
        System.arraycopy(this.tempbuf, n5, object, 0, n3 - n5);
        this.tempbuf = object;
        return n - n6;
    }

    public void inputfeed(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[this.tempbuf.length + n2];
        System.arraycopy(this.tempbuf, 0, byArray2, 0, this.tempbuf.length);
        System.arraycopy(byArray, n, byArray2, this.tempbuf.length, n2);
        this.tempbuf = byArray2;
    }
}

