/*
 * Decompiled with CFR 0.152.
 */
package terminal;

import java.io.IOException;
import terminal.Terminal;

public abstract class VT320 {
    public static final int VK_ENTER = 10;
    public static final int VK_BACK_SPACE = 8;
    public static final int VK_TAB = 9;
    public static final int VK_CANCEL = 3;
    public static final int VK_CLEAR = 12;
    public static final int VK_SHIFT = 16;
    public static final int VK_CONTROL = 17;
    public static final int VK_ALT = 18;
    public static final int VK_PAUSE = 19;
    public static final int VK_CAPS_LOCK = 20;
    public static final int VK_ESCAPE = 27;
    public static final int VK_SPACE = 32;
    public static final int VK_PAGE_UP = 33;
    public static final int VK_PAGE_DOWN = 34;
    public static final int VK_END = 35;
    public static final int VK_HOME = 36;
    public static final int VK_LEFT = 37;
    public static final int VK_UP = 38;
    public static final int VK_RIGHT = 39;
    public static final int VK_DOWN = 40;
    public static final int VK_COMMA = 44;
    public static final int VK_MINUS = 45;
    public static final int VK_PERIOD = 46;
    public static final int VK_SLASH = 47;
    public static final int VK_0 = 48;
    public static final int VK_1 = 49;
    public static final int VK_2 = 50;
    public static final int VK_3 = 51;
    public static final int VK_4 = 52;
    public static final int VK_5 = 53;
    public static final int VK_6 = 54;
    public static final int VK_7 = 55;
    public static final int VK_8 = 56;
    public static final int VK_9 = 57;
    public static final int VK_SEMICOLON = 59;
    public static final int VK_EQUALS = 61;
    public static final int VK_A = 65;
    public static final int VK_B = 66;
    public static final int VK_C = 67;
    public static final int VK_D = 68;
    public static final int VK_E = 69;
    public static final int VK_F = 70;
    public static final int VK_G = 71;
    public static final int VK_H = 72;
    public static final int VK_I = 73;
    public static final int VK_J = 74;
    public static final int VK_K = 75;
    public static final int VK_L = 76;
    public static final int VK_M = 77;
    public static final int VK_N = 78;
    public static final int VK_O = 79;
    public static final int VK_P = 80;
    public static final int VK_Q = 81;
    public static final int VK_R = 82;
    public static final int VK_S = 83;
    public static final int VK_T = 84;
    public static final int VK_U = 85;
    public static final int VK_V = 86;
    public static final int VK_W = 87;
    public static final int VK_X = 88;
    public static final int VK_Y = 89;
    public static final int VK_Z = 90;
    public static final int VK_OPEN_BRACKET = 91;
    public static final int VK_BACK_SLASH = 92;
    public static final int VK_CLOSE_BRACKET = 93;
    public static final int VK_NUMPAD0 = 96;
    public static final int VK_NUMPAD1 = 97;
    public static final int VK_NUMPAD2 = 98;
    public static final int VK_NUMPAD3 = 99;
    public static final int VK_NUMPAD4 = 100;
    public static final int VK_NUMPAD5 = 101;
    public static final int VK_NUMPAD6 = 102;
    public static final int VK_NUMPAD7 = 103;
    public static final int VK_NUMPAD8 = 104;
    public static final int VK_NUMPAD9 = 105;
    public static final int VK_MULTIPLY = 106;
    public static final int VK_ADD = 107;
    public static final int VK_SEPARATER = 108;
    public static final int VK_SEPARATOR = 108;
    public static final int VK_SUBTRACT = 109;
    public static final int VK_DECIMAL = 110;
    public static final int VK_DIVIDE = 111;
    public static final int VK_DELETE = 127;
    public static final int VK_NUM_LOCK = 144;
    public static final int VK_SCROLL_LOCK = 145;
    public static final int VK_F1 = 112;
    public static final int VK_F2 = 113;
    public static final int VK_F3 = 114;
    public static final int VK_F4 = 115;
    public static final int VK_F5 = 116;
    public static final int VK_F6 = 117;
    public static final int VK_F7 = 118;
    public static final int VK_F8 = 119;
    public static final int VK_F9 = 120;
    public static final int VK_F10 = 121;
    public static final int VK_F11 = 122;
    public static final int VK_F12 = 123;
    public static final int VK_INSERT = 155;
    public static final int KEY_CONTROL = 1;
    public static final int KEY_SHIFT = 2;
    public static final int KEY_ALT = 4;
    public static final int KEY_ACTION = 8;
    private int writeBufferIndex = 0;
    private byte[] writeBuffer = new byte[128];
    public boolean localecho = false;
    private byte[] stringConversionBuffer = new byte[10];
    private String terminalID = "vt320";
    private String answerBack = "answerBack\n";
    public int R;
    public int C;
    int attributes = 0;
    int Sc;
    int Sr;
    int Sa;
    int Stm;
    int Sbm;
    char Sgr;
    char Sgl;
    char[] Sgx;
    int insertmode = 0;
    int statusmode = 0;
    boolean vt52mode = false;
    boolean keypadmode = false;
    boolean output8bit = false;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean wraparound = true;
    boolean sendcrlf = true;
    boolean capslock = false;
    boolean numlock = false;
    int mouserpt = 0;
    byte mousebut = 0;
    boolean useibmcharset = false;
    int lastwaslf = 0;
    boolean usedcharsets = false;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char SS2 = '\u008e';
    private static final char SS3 = '\u008f';
    private static final char DCS = '\u0090';
    private static final char HTS = '\u0088';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static final int TSTATE_CSI_EX = 12;
    private static final int TSTATE_ESCSPACE = 13;
    private static final int TSTATE_VT52X = 14;
    private static final int TSTATE_VT52Y = 15;
    private static final int TSTATE_CSI_TICKS = 16;
    char[] gx = new char[]{'B', '0', 'B', 'B'};
    char gl = '\u0000';
    char gr = (char)2;
    int onegl = -1;
    private static final String scoansi_acs = "Tm7k3x4u?kZl@mYjEnB\u2566DqCtAvM\u2550:\u2551N\u2557I\u2554;\u2557H\u255a0a<\u255d";
    private static char[] DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
    private String[] FunctionKey;
    private String[] Numpad;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String[] TabKey;
    private String[] KeyUp;
    private String[] KeyDown;
    private String[] KeyLeft;
    private String[] KeyRight;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] Remove;
    private String[] Insert;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] PrevScn;
    private String[] NextScn;
    private String[] Escape;
    private String[] BackSpace;
    private String[] NUMDot;
    private String[] NUMPlus;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[30];
    private int DCEvar;
    private static final char[] unimap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00a2', '\u00a3', '\u00a5', '\u20a7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u2310', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u2518', '\u250c', '\u2588', '\u2584', '\u258c', '\u2590', '\u2580', '\u03b1', '\u00df', '\u0393', '\u03c0', '\u03a3', '\u03c3', '\u00b5', '\u03c4', '\u03a6', '\u0398', '\u03a9', '\u03b4', '\u221e', '\u03c6', '\u03b5', '\u2229', '\u2261', '\u00b1', '\u2265', '\u2264', '\u2320', '\u2321', '\u00f7', '\u2248', '\u00b0', '\u2219', '\u00b7', '\u221a', '\u207f', '\u00b2', '\u25a0', '\u00a0'};
    public int height;
    public int width;
    public boolean[] update;
    public char[][] charArray;
    public int[][] charAttributes;
    public int bufSize;
    public int maxBufSize;
    public int screenBase;
    public int windowBase;
    public int scrollMarker;
    private int topMargin;
    private int bottomMargin;
    protected boolean showcursor = true;
    protected int cursorX;
    protected int cursorY;
    public static final boolean SCROLL_UP = false;
    public static final boolean SCROLL_DOWN = true;
    public static final int NORMAL = 0;
    public static final int BOLD = 1;
    public static final int UNDERLINE = 2;
    public static final int INVERT = 4;
    public static final int LOW = 8;
    public static final int COLOR = 4080;
    public static final int COLOR_FG = 240;
    public static final int COLOR_BG = 3840;
    protected Terminal display;

    public VT320(int n, int n2) {
        int n3;
        this.setScreenSize(n, n2);
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setBufferSize(n2);
        int n4 = n;
        if (n4 < 132) {
            n4 = 132;
        }
        this.Tabs = new byte[n4];
        for (n3 = 0; n3 < n4; n3 += 8) {
            this.Tabs[n3] = 1;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Remove = new String[4];
        this.Insert = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Escape = new String[4];
        this.BackSpace = new String[4];
        this.TabKey = new String[4];
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.KeyHome[3] = "\u001b[H";
        this.KeyHome[2] = "\u001b[H";
        this.KeyHome[1] = "\u001b[H";
        this.KeyHome[0] = "\u001b[H";
        this.KeyEnd[3] = "\u001b[F";
        this.KeyEnd[2] = "\u001b[F";
        this.KeyEnd[1] = "\u001b[F";
        this.KeyEnd[0] = "\u001b[F";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.Escape[3] = "\u001b";
        this.Escape[2] = "\u001b";
        this.Escape[1] = "\u001b";
        this.Escape[0] = "\u001b";
        if (this.vms) {
            this.BackSpace[1] = "\n";
            this.BackSpace[2] = "\u0018";
            this.BackSpace[3] = "\u007f";
            this.BackSpace[0] = "\u007f";
        } else {
            this.BackSpace[3] = "\b";
            this.BackSpace[2] = "\b";
            this.BackSpace[1] = "\b";
            this.BackSpace[0] = "\b";
        }
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        for (n3 = 0; n3 < 20; ++n3) {
            this.FunctionKeyShift[n3] = "";
            this.FunctionKeyAlt[n3] = "";
            this.FunctionKeyCtrl[n3] = "";
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.TabKey[0] = "\t";
        this.TabKey[1] = "\u001bOP\t";
        this.TabKey[3] = "";
        this.TabKey[2] = "";
        this.KeyUp = new String[4];
        this.KeyUp[0] = "\u001b[A";
        this.KeyDown = new String[4];
        this.KeyDown[0] = "\u001b[B";
        this.KeyRight = new String[4];
        this.KeyRight[0] = "\u001b[C";
        this.KeyLeft = new String[4];
        this.KeyLeft[0] = "\u001b[D";
        this.Numpad = new String[10];
        this.Numpad[0] = "\u001bOp";
        this.Numpad[1] = "\u001bOq";
        this.Numpad[2] = "\u001bOr";
        this.Numpad[3] = "\u001bOs";
        this.Numpad[4] = "\u001bOt";
        this.Numpad[5] = "\u001bOu";
        this.Numpad[6] = "\u001bOv";
        this.Numpad[7] = "\u001bOw";
        this.Numpad[8] = "\u001bOx";
        this.Numpad[9] = "\u001bOy";
        this.KPMinus = this.PF4;
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.NUMPlus = new String[4];
        this.NUMPlus[0] = "+";
        this.NUMDot = new String[4];
        this.NUMDot[0] = ".";
    }

    public VT320() {
        this(80, 24);
    }

    protected void write(byte[] byArray, int n, int n2) {
        if (this.writeBufferIndex + n2 > this.writeBuffer.length) {
            if (this.writeBufferIndex > 0) {
                this.flush();
                this.write(byArray, n, n2);
            } else {
                System.arraycopy(byArray, n, this.writeBuffer, 0, this.writeBuffer.length);
                this.writeBufferIndex = this.writeBuffer.length;
                this.flush();
                this.write(byArray, n + this.writeBuffer.length, n2 - this.writeBuffer.length);
            }
        } else {
            System.arraycopy(byArray, n, this.writeBuffer, this.writeBufferIndex, n2);
            this.writeBufferIndex += n2;
        }
    }

    protected void flush() {
        try {
            this.sendData(this.writeBuffer, 0, this.writeBufferIndex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writeBufferIndex = 0;
    }

    public abstract void sendData(byte[] var1, int var2, int var3) throws IOException;

    public void beep() {
    }

    public void putString(String string) {
        int n = string.length();
        if (n > 0) {
            this.markLine(this.R, 1);
            for (int i = 0; i < n; ++i) {
                this.putChar(string.charAt(i), false);
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    protected void sendTelnetCommand(byte by) {
    }

    public void mousePressed(int n, int n2, int n3) {
        if (this.mouserpt == 0) {
            return;
        }
        int n4 = n3;
        this.mousebut = (byte)3;
        if ((n4 & 0x10) == 16) {
            this.mousebut = 0;
        }
        if ((n4 & 8) == 8) {
            this.mousebut = 1;
        }
        if ((n4 & 4) == 4) {
            this.mousebut = (byte)2;
        }
        int n5 = this.mouserpt == 9 ? 0x20 | this.mousebut : this.mousebut | 0x20 | (n4 & 7) << 2;
        byte[] byArray = new byte[]{27, 91, 77, (byte)n5, (byte)(32 + n + 1), (byte)(32 + n2 + 1)};
        this.write(byArray, 0, byArray.length);
        this.flush();
    }

    public void mouseReleased(int n, int n2, int n3) {
        if (this.mouserpt == 0) {
            return;
        }
        int n4 = this.mouserpt == 9 ? 32 + this.mousebut : 35;
        byte[] byArray = new byte[]{27, 91, 77, (byte)n4, (byte)(32 + n + 1), (byte)(32 + n2 + 1)};
        this.write(byArray, 0, byArray.length);
        this.flush();
        this.mousebut = 0;
    }

    public void setLocalEcho(boolean bl) {
        this.localecho = bl;
    }

    public void setVMS(boolean bl) {
        this.vms = bl;
    }

    public void setIBMCharset(boolean bl) {
        this.useibmcharset = bl;
    }

    public void setTerminalID(String string) {
        this.terminalID = string;
    }

    public void setAnswerBack(String string) {
        this.answerBack = VT320.unEscape(string);
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    private boolean write(String string, boolean bl) {
        if (string == null) {
            return true;
        }
        if (this.stringConversionBuffer.length < string.length()) {
            this.stringConversionBuffer = new byte[string.length()];
        }
        for (int i = 0; i < string.length(); ++i) {
            this.stringConversionBuffer[i] = (byte)string.charAt(i);
        }
        this.write(this.stringConversionBuffer, 0, string.length());
        if (bl) {
            this.putString(string);
        }
        return true;
    }

    private boolean write(String string) {
        return this.write(string, this.localecho);
    }

    static String unEscape(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        while ((n = string.indexOf(92, n2)) >= 0 && ++n <= string.length()) {
            string2 = string2 + string.substring(n2, n - 1);
            if (n == string.length()) {
                return string2;
            }
            switch (string.charAt(n)) {
                case 'b': {
                    string2 = string2 + "\b";
                    break;
                }
                case 'e': {
                    string2 = string2 + "\u001b";
                    break;
                }
                case 'n': {
                    string2 = string2 + "\n";
                    break;
                }
                case 'r': {
                    string2 = string2 + "\r";
                    break;
                }
                case 't': {
                    string2 = string2 + "\t";
                    break;
                }
                case 'v': {
                    string2 = string2 + "\u000b";
                    break;
                }
                case 'a': {
                    string2 = string2 + "\u0012";
                    break;
                }
                default: {
                    if (string.charAt(n) >= '0' && string.charAt(n) <= '9') {
                        int n3;
                        for (n3 = n; n3 < string.length() && string.charAt(n3) >= '0' && string.charAt(n3) <= '9'; ++n3) {
                        }
                        string2 = string2 + (char)Integer.parseInt(string.substring(n, n3));
                        n = n3 - 1;
                        break;
                    }
                    string2 = string2 + string.substring(n++, n);
                }
            }
            n2 = ++n;
        }
        if (n2 <= string.length()) {
            string2 = string2 + string.substring(n2);
        }
        return string2;
    }

    private boolean writeSpecial(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() >= 3 && string.charAt(0) == '\u001b' && string.charAt(1) == 'O') {
            if (this.vt52mode) {
                string = string.charAt(2) >= 'P' && string.charAt(2) <= 'S' ? "\u001b" + string.substring(2) : "\u001b?" + string.substring(2);
            } else if (this.output8bit) {
                string = "\u008f" + string.substring(2);
            }
        }
        if (string.length() >= 3 && string.charAt(0) == '\u001b' && string.charAt(1) == '[' && this.output8bit) {
            string = "\u009b" + string.substring(2);
        }
        return this.write(string, false);
    }

    public void keyPressed(int n, int n2) {
        boolean bl = (n2 & 1) != 0;
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        int n3 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl2) {
            stringArray = this.FunctionKeyShift;
            n3 = 1;
        }
        if (bl) {
            stringArray = this.FunctionKeyCtrl;
            n3 = 2;
        }
        if (bl3) {
            stringArray = this.FunctionKeyAlt;
            n3 = 3;
        }
        switch (n) {
            case 19: {
                if (!bl2 && !bl) break;
                this.sendTelnetCommand((byte)-13);
                break;
            }
            case 112: {
                this.writeSpecial(stringArray[1]);
                break;
            }
            case 113: {
                this.writeSpecial(stringArray[2]);
                break;
            }
            case 114: {
                this.writeSpecial(stringArray[3]);
                break;
            }
            case 115: {
                this.writeSpecial(stringArray[4]);
                break;
            }
            case 116: {
                this.writeSpecial(stringArray[5]);
                break;
            }
            case 117: {
                this.writeSpecial(stringArray[6]);
                break;
            }
            case 118: {
                this.writeSpecial(stringArray[7]);
                break;
            }
            case 119: {
                this.writeSpecial(stringArray[8]);
                break;
            }
            case 120: {
                this.writeSpecial(stringArray[9]);
                break;
            }
            case 121: {
                this.writeSpecial(stringArray[10]);
                break;
            }
            case 122: {
                this.writeSpecial(stringArray[11]);
                break;
            }
            case 123: {
                this.writeSpecial(stringArray[12]);
                break;
            }
            case 38: {
                this.writeSpecial(this.KeyUp[n3]);
                break;
            }
            case 40: {
                this.writeSpecial(this.KeyDown[n3]);
                break;
            }
            case 37: {
                this.writeSpecial(this.KeyLeft[n3]);
                break;
            }
            case 39: {
                this.writeSpecial(this.KeyRight[n3]);
                break;
            }
            case 34: {
                this.writeSpecial(this.NextScn[n3]);
                break;
            }
            case 33: {
                this.writeSpecial(this.PrevScn[n3]);
                break;
            }
            case 155: {
                this.writeSpecial(this.Insert[n3]);
                break;
            }
            case 127: {
                this.writeSpecial(this.Remove[n3]);
                break;
            }
            case 8: {
                this.writeSpecial(this.BackSpace[n3]);
                if (!this.localecho) break;
                if (this.BackSpace[n3] == "\b") {
                    this.putString("\b \b");
                    break;
                }
                this.putString(this.BackSpace[n3]);
                break;
            }
            case 36: {
                this.writeSpecial(this.KeyHome[n3]);
                break;
            }
            case 35: {
                this.writeSpecial(this.KeyEnd[n3]);
                break;
            }
            case 144: {
                if (this.vms && bl) {
                    this.writeSpecial(this.PF1);
                }
                if (bl) break;
                this.numlock = !this.numlock;
                break;
            }
            case 20: {
                this.capslock = !this.capslock;
                break;
            }
        }
        this.flush();
    }

    public void stringTyped(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this._keyTyped(0, string.charAt(i), 0);
        }
        this.flush();
    }

    public void keyTyped(int n, char c, int n2) {
        this._keyTyped(n, c, n2);
        this.flush();
    }

    private void _keyTyped(int n, char c, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = bl = (n2 & 4) != 0;
        if (c == '\t') {
            if (bl3) {
                this.write(this.TabKey[1], false);
            } else if (bl2) {
                this.write(this.TabKey[2], false);
            } else if (bl) {
                this.write(this.TabKey[3], false);
            } else {
                this.write(this.TabKey[0], false);
            }
            return;
        }
        if (bl) {
            this.write("" + (char)(c | 0x80));
            return;
        }
        if (!(n != 10 && c != '\n' || bl2)) {
            this.write("\r", false);
            if (this.localecho) {
                this.putString("\r\n");
            }
            return;
        }
        if ((!this.vms && c == '2' || c == ' ') && bl2) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (c == '\u007f' && !bl2) {
                if (bl3) {
                    this.writeSpecial(this.Insert[0]);
                } else {
                    this.writeSpecial(this.Remove[0]);
                }
                return;
            }
            if (bl2) {
                switch (c) {
                    case '0': {
                        this.writeSpecial(this.Numpad[0]);
                        return;
                    }
                    case '1': {
                        this.writeSpecial(this.Numpad[1]);
                        return;
                    }
                    case '2': {
                        this.writeSpecial(this.Numpad[2]);
                        return;
                    }
                    case '3': {
                        this.writeSpecial(this.Numpad[3]);
                        return;
                    }
                    case '4': {
                        this.writeSpecial(this.Numpad[4]);
                        return;
                    }
                    case '5': {
                        this.writeSpecial(this.Numpad[5]);
                        return;
                    }
                    case '6': {
                        this.writeSpecial(this.Numpad[6]);
                        return;
                    }
                    case '7': {
                        this.writeSpecial(this.Numpad[7]);
                        return;
                    }
                    case '8': {
                        this.writeSpecial(this.Numpad[8]);
                        return;
                    }
                    case '9': {
                        this.writeSpecial(this.Numpad[9]);
                        return;
                    }
                    case '.': {
                        this.writeSpecial(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.writeSpecial(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.writeSpecial(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.writeSpecial(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.writeSpecial(this.PF2);
                        return;
                    }
                    case '*': {
                        this.writeSpecial(this.PF3);
                        return;
                    }
                }
            }
        }
        int n3 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl3) {
            stringArray = this.FunctionKeyShift;
            n3 = 1;
        }
        if (bl2) {
            stringArray = this.FunctionKeyCtrl;
            n3 = 2;
        }
        if (bl) {
            stringArray = this.FunctionKeyAlt;
            n3 = 3;
        }
        if (n == 27) {
            this.writeSpecial(this.Escape[n3]);
            return;
        }
        if ((n2 & 8) != 0) {
            switch (n) {
                case 96: {
                    this.writeSpecial(this.Numpad[0]);
                    return;
                }
                case 97: {
                    this.writeSpecial(this.Numpad[1]);
                    return;
                }
                case 98: {
                    this.writeSpecial(this.Numpad[2]);
                    return;
                }
                case 99: {
                    this.writeSpecial(this.Numpad[3]);
                    return;
                }
                case 100: {
                    this.writeSpecial(this.Numpad[4]);
                    return;
                }
                case 101: {
                    this.writeSpecial(this.Numpad[5]);
                    return;
                }
                case 102: {
                    this.writeSpecial(this.Numpad[6]);
                    return;
                }
                case 103: {
                    this.writeSpecial(this.Numpad[7]);
                    return;
                }
                case 104: {
                    this.writeSpecial(this.Numpad[8]);
                    return;
                }
                case 105: {
                    this.writeSpecial(this.Numpad[9]);
                    return;
                }
                case 110: {
                    this.writeSpecial(this.NUMDot[n3]);
                    return;
                }
                case 107: {
                    this.writeSpecial(this.NUMPlus[n3]);
                    return;
                }
            }
        }
        if (c != '\b' && c != '\u007f' && c != '\r' && c != '\n') {
            if (bl2) {
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 97 + 65);
                }
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c - 65 + 1);
                    this.write("" + c);
                } else {
                    switch (c) {
                        case '@': {
                            c = '\u0000';
                            break;
                        }
                        case '[': {
                            c = (char)27;
                            break;
                        }
                        case '\\': {
                            c = (char)28;
                            break;
                        }
                        case ']': {
                            c = (char)29;
                            break;
                        }
                        case '^': {
                            c = (char)30;
                            break;
                        }
                        case '_': {
                            c = (char)31;
                        }
                    }
                    this.write("" + c);
                }
            } else if (bl3) {
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c - 97 + 65);
                }
                this.write("" + c);
            } else {
                this.write("" + c);
            }
            return;
        }
    }

    public char map_cp850_unicode(char c) {
        if (c >= '\u0100') {
            return c;
        }
        return unimap[c];
    }

    private void _SetCursor(int n, int n2) {
        int n3 = this.height;
        int n4 = this.getTopMargin();
        this.R = n < 0 ? 0 : n;
        int n5 = this.C = n2 < 0 ? 0 : n2;
        if (!this.moveoutsidemargins) {
            this.R += n4;
            n3 = this.getBottomMargin();
        }
        if (this.R > n3) {
            this.R = n3;
        }
    }

    private void putChar(char c, boolean bl) {
        int n = this.height;
        int n2 = this.width;
        int n3 = this.getTopMargin();
        int n4 = this.getBottomMargin();
        boolean bl2 = false;
        this.markLine(this.R, 1);
        if (c > '\u00ff') {
            // empty if block
        }
        block0 : switch (this.term_state) {
            case 0: {
                int n5;
                if (!this.useibmcharset) {
                    n5 = 1;
                    switch (c) {
                        case '\u009d': {
                            this.osc = "";
                            this.term_state = 6;
                            break;
                        }
                        case '\u008d': {
                            if (this.R > n3) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        case '\u0090': {
                            this.dcs = "";
                            this.term_state = 3;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    if (n5 != 0) break;
                }
                switch (c) {
                    case '\u008f': {
                        this.onegl = 3;
                        break;
                    }
                    case '\u008e': {
                        this.onegl = 2;
                        break;
                    }
                    case '\u009b': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\u0005': {
                        this.write(this.answerBack, false);
                        this.flush();
                        break;
                    }
                    case '\f': {
                        this.deleteArea(0, 0, n2, n, this.attributes);
                        this.R = 0;
                        this.C = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        do {
                            ++this.C;
                        } while (this.C < n2 && this.Tabs[this.C] == 0);
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        if (!this.vms) {
                            if (this.lastwaslf != 0 && this.lastwaslf != c) break;
                            this.lastwaslf = c;
                        }
                        if (this.R == n4 || this.R >= n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u0007': {
                        this.beep();
                        break;
                    }
                    case '\u000e': {
                        this.gl = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case '\u000f': {
                        this.gl = '\u0000';
                        this.usedcharsets = true;
                        break;
                    }
                    default: {
                        n5 = this.gl;
                        if (this.onegl >= 0) {
                            n5 = this.onegl;
                            this.onegl = -1;
                        }
                        this.lastwaslf = 0;
                        if (c < ' ' && c != '\u0000' && c == '\u0000') break;
                        if (this.C >= n2) {
                            if (this.wraparound) {
                                if (this.R < n - 1) {
                                    ++this.R;
                                } else {
                                    this.insertLine(this.R, 1, false);
                                }
                                this.C = 0;
                            } else {
                                this.C = n2 - 1;
                            }
                        }
                        if (this.usedcharsets) {
                            if (c >= ' ' && c <= '\u007f') {
                                switch (this.gx[n5]) {
                                    case '0': {
                                        if (this.terminalID.equals("scoansi") || this.terminalID.equals("ansi")) {
                                            for (int i = 0; i < scoansi_acs.length(); i += 2) {
                                                if (c != scoansi_acs.charAt(i)) continue;
                                                c = scoansi_acs.charAt(i + 1);
                                                break;
                                            }
                                        }
                                        if (c < '_' || c > '~') break;
                                        c = DECSPECIAL[(short)c - 95];
                                        bl2 = true;
                                        break;
                                    }
                                    case '<': {
                                        c = (char)(c & 0x7F | 0x80);
                                        bl2 = true;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': {
                                        bl2 = true;
                                        break;
                                    }
                                }
                            }
                            if (!bl2 && c >= '\u0080' && c <= '\u00ff') {
                                switch (this.gx[this.gr]) {
                                    case '0': {
                                        if (c < '\u00df' || c > '\u00fe') break;
                                        c = DECSPECIAL[c - 223];
                                        bl2 = true;
                                        break;
                                    }
                                    case '<': 
                                    case 'A': 
                                    case 'B': {
                                        bl2 = true;
                                        break;
                                    }
                                }
                            }
                        }
                        if (!bl2 && this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            this.putChar(this.C, this.R, c, this.attributes);
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (c < ' ' && c != '\u001b') {
                    this.term_state = 0;
                    break;
                }
                if (c == '\\' && this.osc.charAt(this.osc.length() - 1) == '\u001b') {
                    this.term_state = 0;
                    break;
                }
                this.osc = this.osc + c;
                break;
            }
            case 13: {
                this.term_state = 0;
                switch (c) {
                    case 'F': {
                        this.output8bit = false;
                        break block0;
                    }
                    case 'G': {
                        this.output8bit = true;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.term_state = 0;
                switch (c) {
                    case ' ': {
                        this.term_state = 13;
                        break;
                    }
                    case '#': {
                        this.term_state = 5;
                        break;
                    }
                    case 'c': {
                        this.gx[0] = 66;
                        this.gx[1] = 48;
                        this.gx[2] = 66;
                        this.gx[3] = 66;
                        this.gl = '\u0000';
                        this.gr = '\u0001';
                        int n6 = this.width;
                        if (n6 < 132) {
                            n6 = 132;
                        }
                        this.Tabs = new byte[n6];
                        for (int i = 0; i < n6; i += 8) {
                            this.Tabs[i] = 1;
                        }
                        break block0;
                    }
                    case '[': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case ']': {
                        this.osc = "";
                        this.term_state = 6;
                        break;
                    }
                    case 'P': {
                        this.dcs = "";
                        this.term_state = 3;
                        break;
                    }
                    case 'A': {
                        --this.R;
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'B': {
                        ++this.R;
                        if (this.R <= n - 1) break block0;
                        this.R = n - 1;
                        break;
                    }
                    case 'C': {
                        ++this.C;
                        if (this.C < n2) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'I': {
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'E': {
                        if (this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.C = 0;
                        break;
                    }
                    case 'D': {
                        if (this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case 'J': {
                        if (this.R < n - 1) {
                            this.deleteArea(0, this.R + 1, n2, n - this.R - 1, this.attributes);
                        }
                        if (this.C >= n2 - 1) break block0;
                        this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                        break;
                    }
                    case 'K': {
                        if (this.C >= n2 - 1) break block0;
                        this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                        break;
                    }
                    case 'M': {
                        if (this.R > n4) break;
                        if (this.R > n3) {
                            --this.R;
                            break;
                        }
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'H': {
                        if (this.C >= n2) {
                            this.C = n2 - 1;
                        }
                        this.Tabs[this.C] = 1;
                        break;
                    }
                    case 'N': {
                        this.onegl = 2;
                        break;
                    }
                    case 'O': {
                        this.onegl = 3;
                        break;
                    }
                    case '=': {
                        this.keypadmode = true;
                        break;
                    }
                    case '<': {
                        this.vt52mode = false;
                        break;
                    }
                    case '>': {
                        this.keypadmode = false;
                        break;
                    }
                    case '7': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sgl = this.gl;
                        this.Sgr = this.gr;
                        this.Sa = this.attributes;
                        this.Sgx = new char[4];
                        for (int i = 0; i < 4; ++i) {
                            this.Sgx[i] = this.gx[i];
                        }
                        this.Stm = this.getTopMargin();
                        this.Sbm = this.getBottomMargin();
                        break;
                    }
                    case '8': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.gl = this.Sgl;
                        this.gr = this.Sgr;
                        for (int i = 0; i < 4; ++i) {
                            this.gx[i] = this.Sgx[i];
                        }
                        this.setTopMargin(this.Stm);
                        this.setBottomMargin(this.Sbm);
                        this.attributes = this.Sa;
                        break;
                    }
                    case '(': {
                        this.term_state = 7;
                        this.usedcharsets = true;
                        break;
                    }
                    case ')': {
                        this.term_state = 8;
                        this.usedcharsets = true;
                        break;
                    }
                    case '*': {
                        this.term_state = 9;
                        this.usedcharsets = true;
                        break;
                    }
                    case '+': {
                        this.term_state = 10;
                        this.usedcharsets = true;
                        break;
                    }
                    case '~': {
                        this.gr = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case 'n': {
                        this.gl = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case '}': {
                        this.gr = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'o': {
                        this.gl = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case '|': {
                        this.gr = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'Y': {
                        this.term_state = 15;
                        break;
                    }
                }
                break;
            }
            case 14: {
                this.C = c - 37;
                this.term_state = 15;
                break;
            }
            case 15: {
                this.R = c - 37;
                this.term_state = 0;
                break;
            }
            case 7: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[0] = c;
                }
                this.term_state = 0;
                break;
            }
            case 8: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[1] = c;
                }
                this.term_state = 0;
                break;
            }
            case 9: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[2] = c;
                }
                this.term_state = 0;
                break;
            }
            case 10: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[3] = c;
                }
                this.term_state = 0;
                break;
            }
            case 5: {
                switch (c) {
                    case '8': {
                        for (int i = 0; i < n2; ++i) {
                            for (int j = 0; j < n; ++j) {
                                this.putChar(i, j, 'E', 0);
                            }
                        }
                        break;
                    }
                }
                this.term_state = 0;
                break;
            }
            case 3: {
                if (c == '\\' && this.dcs.charAt(this.dcs.length() - 1) == '\u001b') {
                    this.term_state = 0;
                    break;
                }
                this.dcs = this.dcs + c;
                break;
            }
            case 4: {
                this.term_state = 0;
                block93 : switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 4;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case 's': {
                        break;
                    }
                    case 'r': {
                        block240: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 3: {
                                    this.setScreenSize(80, this.height);
                                    continue block240;
                                }
                                case 4: {
                                    continue block240;
                                }
                                case 5: {
                                    continue block240;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    continue block240;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    continue block240;
                                }
                                case 12: {
                                    continue block240;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[i];
                                    continue block240;
                                }
                            }
                        }
                        break block0;
                    }
                    case 'h': {
                        block241: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001bOA";
                                    this.KeyDown[0] = "\u001bOB";
                                    this.KeyRight[0] = "\u001bOC";
                                    this.KeyLeft[0] = "\u001bOD";
                                    continue block241;
                                }
                                case 2: {
                                    this.vt52mode = false;
                                    continue block241;
                                }
                                case 3: {
                                    this.setScreenSize(132, this.height);
                                    continue block241;
                                }
                                case 6: {
                                    this.moveoutsidemargins = false;
                                    continue block241;
                                }
                                case 7: {
                                    this.wraparound = true;
                                    continue block241;
                                }
                                case 25: {
                                    this.showCursor(true);
                                    this.redraw();
                                    continue block241;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[i];
                                    continue block241;
                                }
                            }
                        }
                        break block0;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                break block93;
                            }
                            case 4: {
                                break block93;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        block242: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001b[A";
                                    this.KeyDown[0] = "\u001b[B";
                                    this.KeyRight[0] = "\u001b[C";
                                    this.KeyLeft[0] = "\u001b[D";
                                    continue block242;
                                }
                                case 2: {
                                    this.vt52mode = true;
                                    continue block242;
                                }
                                case 3: {
                                    this.setScreenSize(80, this.height);
                                    continue block242;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    continue block242;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    continue block242;
                                }
                                case 25: {
                                    this.showCursor(false);
                                    this.redraw();
                                    continue block242;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = 0;
                                    continue block242;
                                }
                            }
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 15: {
                                this.write("\u001b[?13n", false);
                                this.flush();
                                break block93;
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case 12: {
                this.term_state = 0;
                switch (c) {
                    case '\u001b': {
                        this.term_state = 1;
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                this.term_state = 0;
                switch (c) {
                    case 'p': {
                        if (this.DCEvars[0] == 61) {
                            this.output8bit = false;
                            break block0;
                        }
                        if (this.DCEvars[1] == 1) {
                            this.output8bit = false;
                            break block0;
                        }
                        this.output8bit = true;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                this.term_state = 0;
                switch (c) {
                    case '}': {
                        this.statusmode = this.DCEvars[0];
                        break block0;
                    }
                    case '~': {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.term_state = 0;
                block147 : switch (c) {
                    case '\"': {
                        this.term_state = 16;
                        break;
                    }
                    case '$': {
                        this.term_state = 11;
                        break;
                    }
                    case '!': {
                        this.term_state = 12;
                        break;
                    }
                    case '?': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 2;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case 'c': {
                        String string = "";
                        if (this.terminalID.equals("vt320")) {
                            string = "63;";
                        }
                        if (this.terminalID.equals("vt220")) {
                            string = "62;";
                        }
                        if (this.terminalID.equals("vt100")) {
                            string = "61;";
                        }
                        this.write("\u001b[?" + string + "1;2c", false);
                        this.flush();
                        break;
                    }
                    case 'q': {
                        break;
                    }
                    case 'g': {
                        switch (this.DCEvars[0]) {
                            case 3: {
                                this.Tabs = new byte[this.width];
                                break block147;
                            }
                            case 0: {
                                this.Tabs[this.C] = 0;
                            }
                        }
                        break;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 1;
                                break block147;
                            }
                            case 20: {
                                this.sendcrlf = true;
                                break block147;
                            }
                        }
                        break;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                break block147;
                            }
                            case 4: {
                                break block147;
                            }
                            case 5: {
                                break block147;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 0;
                                break block147;
                            }
                            case 20: {
                                this.sendcrlf = false;
                                break block147;
                            }
                        }
                        break;
                    }
                    case 'A': {
                        int n7 = this.R > n4 ? n4 + 1 : (this.R >= n3 ? n3 : 0);
                        this.R = this.DCEvars[0] == 0 ? --this.R : (this.R -= this.DCEvars[0]);
                        if (this.R >= n7) break block0;
                        this.R = n7;
                        break;
                    }
                    case 'B': {
                        int n8 = this.R < n3 ? n3 - 1 : (this.R <= n4 ? n4 : n - 1);
                        this.R = this.DCEvars[0] == 0 ? ++this.R : (this.R += this.DCEvars[0]);
                        if (this.R <= n8) break block0;
                        this.R = n8;
                        break;
                    }
                    case 'C': {
                        this.C = this.DCEvars[0] == 0 ? ++this.C : (this.C += this.DCEvars[0]);
                        if (this.C <= n2 - 1) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'd': {
                        this.R = this.DCEvars[0];
                        break;
                    }
                    case 'D': {
                        this.C = this.DCEvars[0] == 0 ? --this.C : (this.C -= this.DCEvars[0]);
                        if (this.C >= 0) break block0;
                        this.C = 0;
                        break;
                    }
                    case 'r': {
                        if (this.DCEvar > 0) {
                            this.R = this.DCEvars[1] - 1;
                            if (this.R < 0) {
                                this.R = n - 1;
                            } else if (this.R >= n) {
                                this.R = n - 1;
                            }
                        } else {
                            this.R = n - 1;
                        }
                        this.setBottomMargin(this.R);
                        if (this.R >= this.DCEvars[0]) {
                            this.R = this.DCEvars[0] - 1;
                            if (this.R < 0) {
                                this.R = 0;
                            }
                        }
                        this.setTopMargin(this.R);
                        this._SetCursor(0, 0);
                        break;
                    }
                    case 'G': {
                        this.C = this.DCEvars[0];
                        break;
                    }
                    case 'H': {
                        this._SetCursor(this.DCEvars[0] - 1, this.DCEvars[1] - 1);
                        break;
                    }
                    case 'f': {
                        this.R = this.DCEvars[0] - 1;
                        this.C = this.DCEvars[1] - 1;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'S': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(n - 1, false);
                            break;
                        }
                        this.insertLine(n - 1, this.DCEvars[0], false);
                        break;
                    }
                    case 'L': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(this.R, true);
                            break;
                        }
                        this.insertLine(this.R, this.DCEvars[0], true);
                        break;
                    }
                    case 'T': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(0, true);
                            break;
                        }
                        this.insertLine(0, this.DCEvars[0], true);
                        break;
                    }
                    case 'M': {
                        if (this.DCEvars[0] == 0) {
                            this.deleteLine(this.R);
                            break;
                        }
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.deleteLine(this.R);
                        }
                        break block0;
                    }
                    case 'K': {
                        switch (this.DCEvars[0]) {
                            case 0: 
                            case 6: {
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                                break block147;
                            }
                            case 1: {
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block147;
                            }
                            case 2: {
                                this.deleteArea(0, this.R, n2, 1, this.attributes);
                            }
                        }
                        break;
                    }
                    case 'J': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.R < n - 1) {
                                    this.deleteArea(0, this.R + 1, n2, n - this.R - 1, this.attributes);
                                }
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                                break block147;
                            }
                            case 1: {
                                if (this.R > 0) {
                                    this.deleteArea(0, 0, n2, this.R, this.attributes);
                                }
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block147;
                            }
                            case 2: {
                                this.deleteArea(0, 0, n2, n, this.attributes);
                            }
                        }
                        break;
                    }
                    case '@': {
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.insertChar(this.C, this.R, ' ', this.attributes);
                        }
                        break block0;
                    }
                    case 'X': {
                        int n9 = this.DCEvars[0];
                        if (n9 == 0) {
                            n9 = 1;
                        }
                        if (n9 + this.C > n2) {
                            n9 = n2 - this.C;
                        }
                        this.deleteArea(this.C, this.R, n9, 1, this.attributes);
                        break;
                    }
                    case 'P': {
                        if (this.DCEvars[0] == 0) {
                            this.DCEvars[0] = 1;
                        }
                        for (int i = 0; i < this.DCEvars[0]; ++i) {
                            this.deleteChar(this.C, this.R);
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 5: {
                                this.writeSpecial("\u001b[0n");
                                this.flush();
                                break block147;
                            }
                            case 6: {
                                this.writeSpecial("\u001b[" + this.R + ";" + this.C + "R");
                                this.flush();
                                break block147;
                            }
                        }
                        break;
                    }
                    case 's': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        break;
                    }
                    case 'u': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        break;
                    }
                    case 'm': {
                        if (this.DCEvar == 0 && this.DCEvars[0] == 0) {
                            this.attributes = 0;
                        }
                        block246: for (int i = 0; i <= this.DCEvar; ++i) {
                            switch (this.DCEvars[i]) {
                                case 0: {
                                    if (this.DCEvar <= 0) continue block246;
                                    if (this.terminalID.equals("scoansi")) {
                                        this.attributes &= 0xFF0;
                                        continue block246;
                                    }
                                    this.attributes = 0;
                                    continue block246;
                                }
                                case 1: {
                                    this.attributes |= 1;
                                    this.attributes &= 0xFFFFFFF7;
                                    continue block246;
                                }
                                case 2: {
                                    if (this.terminalID.equals("scoansi") && this.DCEvar - i >= 2) {
                                        this.attributes &= 0xFFFFF00E;
                                        int n10 = this.DCEvars[i + 1];
                                        if ((n10 & 8) == 8) {
                                            this.attributes |= 1;
                                        }
                                        n10 = (n10 & 1) << 2 | n10 & 2 | (n10 & 4) >> 2;
                                        this.attributes |= n10 + 1 << 4;
                                        n10 = this.DCEvars[i + 2];
                                        n10 = (n10 & 1) << 2 | n10 & 2 | (n10 & 4) >> 2;
                                        this.attributes |= n10 + 1 << 8;
                                        i += 2;
                                        continue block246;
                                    }
                                    this.attributes |= 8;
                                    continue block246;
                                }
                                case 4: {
                                    this.attributes |= 2;
                                    continue block246;
                                }
                                case 7: {
                                    this.attributes |= 4;
                                    continue block246;
                                }
                                case 5: {
                                    continue block246;
                                }
                                case 10: {
                                    this.gl = '\u0000';
                                    this.usedcharsets = true;
                                    continue block246;
                                }
                                case 11: 
                                case 12: {
                                    this.gl = '\u0001';
                                    this.usedcharsets = true;
                                    continue block246;
                                }
                                case 21: {
                                    this.attributes &= 0xFFFFFFF6;
                                    continue block246;
                                }
                                case 25: {
                                    continue block246;
                                }
                                case 27: {
                                    this.attributes &= 0xFFFFFFFB;
                                    continue block246;
                                }
                                case 24: {
                                    this.attributes &= 0xFFFFFFFD;
                                    continue block246;
                                }
                                case 22: {
                                    this.attributes &= 0xFFFFFFFE;
                                    continue block246;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.attributes &= 0xFFFFFF0F;
                                    this.attributes |= this.DCEvars[i] - 30 + 1 << 4;
                                    continue block246;
                                }
                                case 39: {
                                    this.attributes &= 0xFFFFFF0F;
                                    continue block246;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.attributes &= 0xFFFFF0FF;
                                    this.attributes |= this.DCEvars[i] - 40 + 1 << 8;
                                    continue block246;
                                }
                                case 49: {
                                    this.attributes &= 0xFFFFF0FF;
                                    continue block246;
                                }
                            }
                        }
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > n2) {
            this.C = n2;
        }
        if (this.R > n) {
            this.R = n;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (bl) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void reset() {
        this.gx[0] = 66;
        this.gx[1] = 48;
        this.gx[2] = 66;
        this.gx[3] = 66;
        this.gl = '\u0000';
        this.gr = '\u0001';
        int n = this.width;
        if (n < 132) {
            n = 132;
        }
        this.Tabs = new byte[n];
        for (int i = 0; i < n; i += 8) {
            this.Tabs[i] = 1;
        }
        this.term_state = 0;
    }

    public void putChar(int n, int n2, char c) {
        this.putChar(n, n2, c, 0);
    }

    public void putChar(int n, int n2, char c, int n3) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        this.charArray[this.screenBase + n2][n] = c;
        this.charAttributes[this.screenBase + n2][n] = n3;
        this.markLine(n2, 1);
    }

    public char getChar(int n, int n2) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        return this.charArray[this.screenBase + n2][n];
    }

    public int getAttributes(int n, int n2) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        return this.charAttributes[this.screenBase + n2][n];
    }

    public void insertChar(int n, int n2, char c, int n3) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        System.arraycopy(this.charArray[this.screenBase + n2], n, this.charArray[this.screenBase + n2], n + 1, this.width - n - 1);
        System.arraycopy(this.charAttributes[this.screenBase + n2], n, this.charAttributes[this.screenBase + n2], n + 1, this.width - n - 1);
        this.putChar(n, n2, c, n3);
    }

    public void deleteChar(int n, int n2) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        if (n < this.width - 1) {
            System.arraycopy(this.charArray[this.screenBase + n2], n + 1, this.charArray[this.screenBase + n2], n, this.width - n - 1);
            System.arraycopy(this.charAttributes[this.screenBase + n2], n + 1, this.charAttributes[this.screenBase + n2], n, this.width - n - 1);
        }
        this.putChar(this.width - 1, n2, '\u0000');
    }

    public void putString(int n, int n2, String string) {
        this.putString(n, n2, string, 0);
    }

    public void putString(int n, int n2, String string, int n3) {
        for (int i = 0; i < string.length() && n + i < this.width; ++i) {
            this.putChar(n + i, n2, string.charAt(i), n3);
        }
    }

    public void insertLine(int n) {
        this.insertLine(n, 1, false);
    }

    public void insertLine(int n, int n2) {
        this.insertLine(n, n2, false);
    }

    public void insertLine(int n, boolean bl) {
        this.insertLine(n, 1, bl);
    }

    public void insertLine(int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5;
        n = this.checkBounds(n, 0, this.height - 1);
        char[][] cArray = null;
        int[][] nArray = null;
        int n6 = 0;
        int n7 = this.screenBase;
        if (n > this.bottomMargin) {
            return;
        }
        int n8 = n < this.topMargin ? 0 : (n > this.bottomMargin ? (this.bottomMargin + 1 < this.height ? this.bottomMargin + 1 : this.height - 1) : (n5 = this.topMargin));
        int n9 = n > this.bottomMargin ? this.height - 1 : (n < this.topMargin ? (this.topMargin > 0 ? this.topMargin - 1 : 0) : (n4 = this.bottomMargin));
        if (bl) {
            if (n2 > n4 - n5) {
                n2 = n4 - n5;
            }
            cArray = new char[n4 - n - (n2 - 1)][this.width];
            nArray = new int[n4 - n - (n2 - 1)][this.width];
            System.arraycopy(this.charArray, n7 + n, cArray, 0, n4 - n - (n2 - 1));
            System.arraycopy(this.charAttributes, n7 + n, nArray, 0, n4 - n - (n2 - 1));
            System.arraycopy(cArray, 0, this.charArray, n7 + n + n2, n4 - n - (n2 - 1));
            System.arraycopy(nArray, 0, this.charAttributes, n7 + n + n2, n4 - n - (n2 - 1));
            cArray = this.charArray;
            nArray = this.charAttributes;
        } else {
            try {
                if (n2 > n4 - n5 + 1) {
                    n2 = n4 - n5 + 1;
                }
                if (this.bufSize < this.maxBufSize) {
                    if (this.bufSize + n2 > this.maxBufSize) {
                        n6 = n2 - (this.maxBufSize - this.bufSize);
                        this.scrollMarker += n6;
                        this.bufSize = this.maxBufSize;
                        this.windowBase = this.screenBase = this.maxBufSize - this.height - 1;
                    } else {
                        this.scrollMarker += n2;
                        this.screenBase += n2;
                        this.windowBase += n2;
                        this.bufSize += n2;
                    }
                    cArray = new char[this.bufSize][this.width];
                    nArray = new int[this.bufSize][this.width];
                } else {
                    n6 = n2;
                    cArray = this.charArray;
                    nArray = this.charAttributes;
                }
                if (n7 > 0) {
                    System.arraycopy(this.charArray, n6, cArray, 0, n7 - n6);
                    System.arraycopy(this.charAttributes, n6, nArray, 0, n7 - n6);
                }
                if (n5 > 0) {
                    System.arraycopy(this.charArray, n7, cArray, this.screenBase, n5);
                    System.arraycopy(this.charAttributes, n7, nArray, this.screenBase, n5);
                }
                if (n7 > 0) {
                    System.arraycopy(this.charArray, n7 + n5, cArray, n7 - n6, n2);
                    System.arraycopy(this.charAttributes, n7 + n5, nArray, n7 - n6, n2);
                }
                for (n3 = 0; n3 < n - n5 - (n2 - 1); ++n3) {
                    cArray[this.screenBase + n5 + n3] = this.charArray[n7 + n5 + n2 + n3];
                    nArray[this.screenBase + n5 + n3] = this.charAttributes[n7 + n5 + n2 + n3];
                }
                if (n < this.height - 1) {
                    System.arraycopy(this.charArray, n7 + n + 1, cArray, this.screenBase + n + 1, this.height - 1 - n);
                    System.arraycopy(this.charAttributes, n7 + n + 1, nArray, this.screenBase + n + 1, this.height - 1 - n);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        this.scrollMarker -= n2;
        for (n3 = 0; n3 < n2; ++n3) {
            cArray[this.screenBase + n + (bl ? n3 : -n3)] = new char[this.width];
            nArray[this.screenBase + n + (bl ? n3 : -n3)] = new int[this.width];
        }
        this.charArray = cArray;
        this.charAttributes = nArray;
        if (bl) {
            this.markLine(n, n4 - n + 1);
        } else {
            this.markLine(n5, n - n5 + 1);
        }
    }

    public void deleteLine(int n) {
        int n2 = (n = this.checkBounds(n, 0, this.height - 1)) > this.bottomMargin ? this.height - 1 : (n < this.topMargin ? this.topMargin : this.bottomMargin + 1);
        System.arraycopy(this.charArray, this.screenBase + n + 1, this.charArray, this.screenBase + n, n2 - n - 1);
        System.arraycopy(this.charAttributes, this.screenBase + n + 1, this.charAttributes, this.screenBase + n, n2 - n - 1);
        this.charArray[this.screenBase + n2 - 1] = new char[this.width];
        this.charAttributes[this.screenBase + n2 - 1] = new int[this.width];
        this.markLine(n, n2 - n);
    }

    public void deleteArea(int n, int n2, int n3, int n4, int n5) {
        int n6;
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        char[] cArray = new char[n3];
        int[] nArray = new int[n3];
        for (n6 = 0; n6 < n3; ++n6) {
            nArray[n6] = n5;
        }
        for (n6 = 0; n6 < n4 && n2 + n6 < this.height; ++n6) {
            System.arraycopy(cArray, 0, this.charArray[this.screenBase + n2 + n6], n, n3);
            System.arraycopy(nArray, 0, this.charAttributes[this.screenBase + n2 + n6], n, n3);
        }
        this.markLine(n2, n4);
    }

    public void deleteArea(int n, int n2, int n3, int n4) {
        n = this.checkBounds(n, 0, this.width - 1);
        n2 = this.checkBounds(n2, 0, this.height - 1);
        char[] cArray = new char[n3];
        int[] nArray = new int[n3];
        for (int i = 0; i < n4 && n2 + i < this.height; ++i) {
            System.arraycopy(cArray, 0, this.charArray[this.screenBase + n2 + i], n, n3);
            System.arraycopy(nArray, 0, this.charAttributes[this.screenBase + n2 + i], n, n3);
        }
        this.markLine(n2, n4);
    }

    public void showCursor(boolean bl) {
        if (bl != this.showcursor) {
            this.markLine(this.cursorY, 1);
        }
        this.showcursor = bl;
    }

    public void setCursorPosition(int n, int n2) {
        this.cursorX = this.checkBounds(n, 0, this.width - 1);
        this.cursorY = this.checkBounds(n2, 0, this.height - 1);
        this.markLine(this.cursorY, 1);
    }

    public int getCursorColumn() {
        return this.cursorX;
    }

    public int getCursorRow() {
        return this.cursorY;
    }

    public void setWindowBase(int n) {
        if (n > this.screenBase) {
            n = this.screenBase;
        } else if (n < 0) {
            n = 0;
        }
        this.windowBase = n;
        this.update[0] = true;
        this.redraw();
    }

    public int getWindowBase() {
        return this.windowBase;
    }

    public void setTopMargin(int n) {
        if (n > this.bottomMargin) {
            this.topMargin = this.bottomMargin;
            this.bottomMargin = n;
        } else {
            this.topMargin = n;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.height - 1) {
            this.bottomMargin = this.height - 1;
        }
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(int n) {
        if (n < this.topMargin) {
            this.bottomMargin = this.topMargin;
            this.topMargin = n;
        } else {
            this.bottomMargin = n;
        }
        if (this.topMargin < 0) {
            this.topMargin = 0;
        }
        if (this.bottomMargin > this.height - 1) {
            this.bottomMargin = this.height - 1;
        }
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public void setBufferSize(int n) {
        if (n < this.height) {
            n = this.height;
        }
        if (n < this.maxBufSize) {
            int n2;
            char[][] cArray = new char[n][this.width];
            int[][] nArray = new int[n][this.width];
            int n3 = this.bufSize - n < 0 ? 0 : this.bufSize - n;
            int n4 = n2 = this.bufSize - n < 0 ? this.bufSize : n;
            if (this.charArray != null) {
                System.arraycopy(this.charArray, n3, cArray, 0, n2);
            }
            if (this.charAttributes != null) {
                System.arraycopy(this.charAttributes, n3, nArray, 0, n2);
            }
            this.charArray = cArray;
            this.charAttributes = nArray;
            this.bufSize = n2;
            this.windowBase = this.screenBase = this.bufSize - this.height;
        }
        this.maxBufSize = n;
        this.update[0] = true;
        this.redraw();
    }

    public int getBufferSize() {
        return this.bufSize;
    }

    public int getMaxBufferSize() {
        return this.maxBufSize;
    }

    public void setScreenSize(int n, int n2) {
        int n3 = this.bufSize;
        if (n < 1 || n2 < 1) {
            return;
        }
        if (n2 > this.maxBufSize) {
            this.maxBufSize = n2;
        }
        if (n2 > this.bufSize) {
            this.bufSize = n2;
            this.screenBase = 0;
            this.windowBase = 0;
        }
        if (this.windowBase + n2 >= this.bufSize) {
            this.windowBase = this.bufSize - n2;
        }
        if (this.screenBase + n2 >= this.bufSize) {
            this.screenBase = this.bufSize - n2;
        }
        char[][] cArray = new char[this.bufSize][n];
        int[][] nArray = new int[this.bufSize][n];
        if (this.charArray != null && this.charAttributes != null) {
            for (int i = 0; i < n3 && i < this.bufSize; ++i) {
                System.arraycopy(this.charArray[i], 0, cArray[i], 0, n < this.width ? n : this.width);
                System.arraycopy(this.charAttributes[i], 0, nArray[i], 0, n < this.width ? n : this.width);
            }
        }
        this.charArray = cArray;
        this.charAttributes = nArray;
        this.width = n;
        this.height = n2;
        this.topMargin = 0;
        this.bottomMargin = n2 - 1;
        this.update = new boolean[n2 + 1];
        this.update[0] = true;
    }

    public void markLine(int n, int n2) {
        n = this.checkBounds(n, 0, this.height - 1);
        for (int i = 0; i < n2 && n + i < this.height; ++i) {
            this.update[n + i + 1] = true;
        }
    }

    private int checkBounds(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public void setDisplay(Terminal terminal) {
        this.display = terminal;
    }

    protected void redraw() {
        if (this.display != null) {
            this.display.redraw();
        }
    }
}

