/* This file is part of "MidpSSH".
 * Copyright (c) 2004 Karl von Randow.
 * 
 * MidpSSH is based upon Telnet Floyd and FloydSSH by Radek Polak.
 *
 * --LICENSE NOTICE--
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * --LICENSE NOTICE--
 *
 */
package app;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

/**
 * @author Karl von Randow
 */
public class Settings extends MyRecordStore {
	
	public static final int DEFAULT_BGCOLOR = 0x000000, DEFAULT_FGCOLOR = 0xffffff;
    
    public static final int ROT_NORMAL = 0;
    
    public static final int ROT_270 = 1;
    
    public static final int ROT_90 = 2;
    
    public static final int FONT_NORMAL = 0;
    
    public static final int FONT_SMALL = 1;
    
    public static final int FONT_MEDIUM = 2;
    
    public static final int FONT_LARGE = 3;
    
    private static final String RMS_NAME = "settings";
	
	public static int bgcolor, fgcolor;
	
	public static int terminalCols, terminalRows;
	
	public static String terminalType;

	public static int terminalRotated ;
    
    public static int fontMode;
	
	private static Settings me = new Settings();

    public static boolean terminalFullscreen ;
    
    public static String sessionsImportUrl;
    
//#ifdef ssh2
    public static int sshVersionPreferred;
    
    public static boolean ssh2StoreKey;
    
    public static byte [] ssh2x, ssh2y;
    
    public static int ssh2KeySize;
//#endif
	
	public static void init() {
        defaults();
		me.load( RMS_NAME, false );
	}

	/**
	 * @param settings2
	 */
	public static void saveSettings() {
		Vector v = new Vector();
		v.addElement( null ); // doesn't matter what we pass through, it just calls write()
		me.save( RMS_NAME, v );
	}
    
    public static void defaults() {
        bgcolor = DEFAULT_BGCOLOR;
        fgcolor = DEFAULT_FGCOLOR;
        terminalCols = 0;
        terminalRows = 0;
        terminalType = "";
        terminalRotated = ROT_NORMAL;
        fontMode = FONT_NORMAL;
        terminalFullscreen = false;
//#ifdef ssh2
        sshVersionPreferred = 1;
//#endif
        sessionsImportUrl = "http://";
//#ifdef ssh2
        ssh2StoreKey = true;
        ssh2x = null;
        ssh2y = null;
        ssh2KeySize = 512;
//#endif
    }
	
    /* (non-Javadoc)
     * @see app.MyRecordStore#read(java.io.DataInputStream)
     */
    protected Object read(DataInputStream in) throws IOException {
    	fgcolor = in.readInt();
		bgcolor = in.readInt();
		terminalCols = in.readInt();
		terminalRows = in.readInt();
		terminalType = in.readUTF();
		terminalRotated = in.readInt();
        fontMode = in.readInt();
        terminalFullscreen = in.readBoolean();
//#ifdef ssh2
        sshVersionPreferred = in.readInt();
//#endif
        sessionsImportUrl = in.readUTF();
//#ifdef ssh2
        ssh2StoreKey = in.readBoolean();
        ssh2x = readByteArray(in);
        ssh2y = readByteArray(in);
        ssh2KeySize = in.readInt();
//#endif
        return null;
    }
    
    /* (non-Javadoc)
     * @see app.MyRecordStore#write(java.io.DataOutputStream, java.lang.Object)
     */
    protected void write(DataOutputStream out, Object ob) throws IOException {
    	out.writeInt( fgcolor );
		out.writeInt( bgcolor );
		out.writeInt( terminalCols );
		out.writeInt( terminalRows );
		out.writeUTF( terminalType );
		out.writeInt( terminalRotated );
        out.writeInt( fontMode );
        out.writeBoolean( terminalFullscreen );
//#ifdef ssh2
        out.writeInt(sshVersionPreferred);
//#else
        out.writeInt(1);
//#endif
        out.writeUTF(sessionsImportUrl);
//#ifdef ssh2
        out.writeBoolean(ssh2StoreKey);
        writeByteArray(out, ssh2x);
        writeByteArray(out, ssh2y);
        out.writeInt(ssh2KeySize);
//#else
        out.writeBoolean(true);
        out.writeInt(0);
        out.writeInt(0);
        out.writeInt(0);
//#endif
    }
    
//#ifdef ssh2
    private byte[] readByteArray(DataInputStream in) throws IOException {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        else {
            byte[] buf = new byte[length];
            in.readFully(buf);
            return buf;
        }
    }
    
    private void writeByteArray(DataOutputStream out, byte[] ray) throws IOException {
        if (ray != null) {
            out.writeInt(ray.length);
            out.write(ray);
        }
        else {
            out.writeInt(0);
        }
    }
//#endif   
}
