/******************************************************************************
 *
 * Copyright (c) 1999-2001 AppGate AB. All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the MindTerm Public Source License,
 * Version 1.1, (the 'License'). You may not use this file except in compliance
 * with the License.
 * 
 * You should have received a copy of the MindTerm Public Source License
 * along with this software; see the file LICENSE.  If not, write to
 * AppGate AB, Stora Badhusgatan 18-20, 41121 Goteborg, SWEDEN
 *
 *****************************************************************************/

package com.mindbright.security.publickey;

import java.math.BigInteger;

import com.mindbright.jca.security.KeyPair;
import com.mindbright.jca.security.KeyPairGenerator;
import com.mindbright.jca.security.SecureRandom;
import com.mindbright.jca.security.InvalidAlgorithmParameterException;
import com.mindbright.jca.security.spec.AlgorithmParameterSpec;

public class RSAKeyPairGenerator extends KeyPairGenerator {

    protected SecureRandom random;
    protected int          keysize;

    public RSAKeyPairGenerator() {
	super("RSA");
    }

    public void initialize(int keysize, SecureRandom random) {
	this.random  = random;
	this.keysize = keysize;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random)
	throws InvalidAlgorithmParameterException
    {
	throw new Error("Not implemented: " +
			"'RSAKeyPairGenerator.initialize(int, SecureRandom)'");
    }

    public KeyPair generateKeyPair() {
	if(random == null) {
	    random = new SecureRandom();
	}
	return RSAAlgorithm.generateKeyPair(keysize, random);
    }

}
