/******************************************************************************
 *
 * Copyright (c) 1999-2001 AppGate AB. All Rights Reserved.
 * 
 * This file contains Original Code and/or Modifications of Original Code as
 * defined in and that are subject to the MindTerm Public Source License,
 * Version 1.1, (the 'License'). You may not use this file except in compliance
 * with the License.
 * 
 * You should have received a copy of the MindTerm Public Source License
 * along with this software; see the file LICENSE.  If not, write to
 * AppGate AB, Stora Badhusgatan 18-20, 41121 Goteborg, SWEDEN
 *
 *****************************************************************************/

package com.mindbright.ssh2;

import java.util.Hashtable;
import java.util.Vector;

public class SSH2Authenticator {
    private Hashtable authModules = new Hashtable();
    private Vector    methodList  = new Vector();

    private String username;

    public SSH2Authenticator() {
    }

    public SSH2Authenticator(String username) {
	this.username = username;
    }

    public synchronized String getMethods() {
	StringBuffer buf = new StringBuffer();
	for(int i = 0; i < methodList.size(); i++) {
	    buf.append(methodList.elementAt(i));
	    if(i < methodList.size() - 1)
		buf.append(",");
	}
	return buf.toString();
    }

    public String getUsername() {
	return username;
    }

    public void setUsername(String username) {
	this.username = username;
    }

    public void displayBanner(String banner) {
    }

    public synchronized SSH2AuthModule getModule(String type) {
	return (SSH2AuthModule)authModules.get(type);
    }

    public void peerMethods(String methods) {
    }

    public void noMoreMethods() {
    }

    public void moduleFailure(String type, SSH2Exception e) {
    }

    public void moduleCancel(String type, String reason) {
    }

    public void authFailure(String type, boolean partial) {
    }

    public void authSuccess(String type) {
    }

    public void authError() {
    }

    public final synchronized void addModule(String type, SSH2AuthModule module) {
	if(type == null || module == null)
	    return;
	authModules.put(type, module);
	methodList.addElement(type);
    }

    public final synchronized void removeModule(String type) {
	authModules.remove(type);
	methodList.removeElement(type);
    }

}
