/******************************************************************************
 *
 * Copyright (c) 1998,99 by Mindbright Technology AB, Stockholm, Sweden.
 *                 www.mindbright.se, info@mindbright.se
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *****************************************************************************
 * $Author: mats $
 * $Date: 1999/08/11 11:55:02 $
 * $Name: rel1-1-5 $
 *****************************************************************************/
package mindbright.ssh;

import java.net.*;
import java.io.*;

public interface SSHClientUser {
  public String  getSrvHost() throws IOException;
  public int     getSrvPort();
  public String  getDisplay();
  public int     getMaxPacketSz();

  public boolean wantX11Forward();
  public boolean wantPrivileged();
  public boolean wantPTY();

  public void    connected(SSHClient client);
  public void    open(SSHClient client);
  public void    disconnected(SSHClient client, boolean graceful);
  public void    report(String msg);
  public void    alert(String msg);
}
