/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERInteger
extends DERObject {
    byte[] bytes;

    public static DERInteger getInstance(Object object) {
        if (object == null || object instanceof DERInteger) {
            return (DERInteger)object;
        }
        if (object instanceof ASN1OctetString) {
            return new DERInteger(((ASN1OctetString)object).getOctets());
        }
        if (object instanceof ASN1TaggedObject) {
            return DERInteger.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERInteger getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return DERInteger.getInstance(aSN1TaggedObject.getObject());
    }

    public DERInteger(int n) {
        this.bytes = BigInteger.valueOf(n).toByteArray();
    }

    public DERInteger(BigInteger bigInteger) {
        this.bytes = bigInteger.toByteArray();
    }

    public DERInteger(byte[] byArray) {
        this.bytes = byArray;
    }

    public BigInteger getValue() {
        return new BigInteger(this.bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.bytes);
    }

    void encode(DEROutputStream dEROutputStream) throws IOException {
        dEROutputStream.writeEncoded(2, this.bytes);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof DERInteger)) {
            return false;
        }
        DERInteger dERInteger = (DERInteger)object;
        if (this.bytes.length != dERInteger.bytes.length) {
            return false;
        }
        int n = 0;
        while (n != this.bytes.length) {
            if (this.bytes[n] != dERInteger.bytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

