/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicIconFactory;

public class ColorComboBox
extends JComboBox {
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ColorComboBox() {
        this((Color)null);
    }

    public ColorComboBox(Color color) {
        super(new ColorComboModel());
        this.setColor(color);
        this.setRenderer(new ColorRenderer());
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ColorComboBox.this.getSelectedItem() == null) {
                    ColorComboBox.this.chooseCustomColor();
                } else {
                    ColorComboBox.this.fireChangeEvent();
                }
            }
        });
    }

    protected void fireChangeEvent() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ColorComboBox.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        int n = changeListenerArray.length - 1;
        while (n >= 0) {
            changeListenerArray[n].stateChanged(changeEvent);
            --n;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ColorComboBox.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ColorComboBox.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    private void chooseCustomColor() {
        Color color = JColorChooser.showDialog(this, "Custom Color", Color.black);
        if (color != null) {
            this.setColor(color);
            this.fireChangeEvent();
        }
    }

    public void setColor(Color color) {
        int n = 0;
        while (n < this.getModel().getSize() - 1) {
            Color color2 = (Color)this.getModel().getElementAt(n);
            if (color2.equals(color)) {
                this.setSelectedIndex(n);
                return;
            }
            ++n;
        }
        if (color != null) {
            ((ColorComboModel)this.getModel()).addColor(color);
        }
    }

    public Color getColor() {
        return (Color)this.getSelectedItem();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ColorRenderer
    extends DefaultListCellRenderer {
        private ColorIcon icon = new ColorIcon(Color.black, new Dimension(10, 10), Color.black);

        ColorRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Color color = (Color)object;
            if (color == null) {
                this.setIcon(BasicIconFactory.getCheckBoxIcon());
                this.setText("Custom ....");
            } else {
                this.icon.setColor(color);
                this.setIcon(this.icon);
                String string = "#" + color.getRed() + "," + color.getGreen() + "," + color.getBlue();
                if (color.equals(Color.black)) {
                    string = "Black";
                } else if (color.equals(Color.white)) {
                    string = "White";
                } else if (color.equals(Color.red)) {
                    string = "Red";
                } else if (color.equals(Color.orange)) {
                    string = "Orange";
                } else if (color.equals(Color.yellow)) {
                    string = "Yellow";
                } else if (color.equals(Color.green)) {
                    string = "Green";
                } else if (color.equals(Color.blue)) {
                    string = "Blue";
                } else if (color.equals(Color.cyan)) {
                    string = "Cyan";
                } else if (color.equals(Color.magenta)) {
                    string = "Magenta";
                } else if (color.equals(Color.pink)) {
                    string = "Pink";
                } else if (color.equals(Color.lightGray)) {
                    string = "Light Gray";
                } else if (color.equals(Color.gray)) {
                    string = "Gray";
                } else if (color.equals(Color.darkGray)) {
                    string = "Dark Gray";
                }
                this.setText(string);
            }
            return this;
        }
    }

    static class ColorComboModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Vector colors = new Vector();
        private Object selected;

        ColorComboModel() {
            this.colors.addElement(Color.black);
            this.colors.addElement(Color.white);
            this.colors.addElement(Color.red.darker());
            this.colors.addElement(Color.red);
            this.colors.addElement(Color.orange.darker());
            this.colors.addElement(Color.orange);
            this.colors.addElement(Color.yellow.darker());
            this.colors.addElement(Color.yellow);
            this.colors.addElement(Color.green.darker());
            this.colors.addElement(Color.green);
            this.colors.addElement(Color.blue.darker());
            this.colors.addElement(Color.blue);
            this.colors.addElement(Color.cyan.darker());
            this.colors.addElement(Color.cyan);
            this.colors.addElement(Color.magenta.darker());
            this.colors.addElement(Color.magenta);
            this.colors.addElement(Color.pink.darker());
            this.colors.addElement(Color.pink);
            this.colors.addElement(Color.lightGray);
            this.colors.addElement(Color.gray);
            this.colors.addElement(Color.darkGray);
            this.selected = this.colors.elementAt(0);
        }

        public int getSize() {
            return this.colors.size() + 1;
        }

        public Object getElementAt(int n) {
            if (n == this.colors.size()) {
                return null;
            }
            return this.colors.elementAt(n);
        }

        public void setSelectedItem(Object object) {
            this.selected = object;
        }

        public Object getSelectedItem() {
            return this.selected;
        }

        public void addColor(Color color) {
            int n = this.colors.size();
            this.colors.addElement(color);
            this.selected = color;
            this.fireIntervalAdded(this, n, n);
        }
    }
}

