/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import com.sshtools.common.util.UIDException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class UID {
    byte[] uid;

    private UID(String string) throws UIDException {
        if (string == null) {
            throw new UIDException("UID cannot be NULL");
        }
        try {
            this.uid = new byte[string.length() / 2];
            int n = 0;
            int n2 = 0;
            while (n2 < string.length()) {
                String string2 = string.substring(n2, n2 + 2);
                this.uid[n++] = (byte)Integer.parseInt(string2, 16);
                n2 += 2;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new UIDException("Failed to parse UID String: " + numberFormatException.getMessage());
        }
    }

    private UID(byte[] byArray) {
        this.uid = byArray;
    }

    public static UID generateUniqueId(byte[] byArray) throws UIDException {
        try {
            Object object;
            Object object2;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (byArray != null) {
                object2 = new ByteArrayInputStream(byArray);
                object = new DigestInputStream((InputStream)object2, messageDigest);
                while (((DigestInputStream)object).read() != -1) {
                }
                ((FilterInputStream)object).close();
                ((ByteArrayInputStream)object2).close();
            }
            object2 = new byte[1024];
            ConfigurationLoader.getRND().nextBytes((byte[])object2);
            messageDigest.update((byte[])object2);
            object = new UID(messageDigest.digest());
            return object;
        }
        catch (Exception exception) {
            throw new UIDException("Failed to generate a unique identifier: " + exception.getMessage());
        }
    }

    public static UID fromString(String string) throws UIDException {
        return new UID(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.uid.length) {
            String string = Integer.toHexString(0xFF & this.uid[n]);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof UID) {
            return Arrays.equals(this.uid, ((UID)object).uid);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

