/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.math.BigInteger;

public class SshMsgKexDhReply
extends SshMessage {
    protected static final int SSH_MSG_KEXDH_REPLY = 31;
    private BigInteger f;
    private byte[] hostKey;
    private byte[] signature;

    public SshMsgKexDhReply(byte[] byArray, BigInteger bigInteger, byte[] byArray2) {
        super(31);
        this.hostKey = byArray;
        this.f = bigInteger;
        this.signature = byArray2;
    }

    public SshMsgKexDhReply() {
        super(31);
    }

    public BigInteger getF() {
        return this.f;
    }

    public byte[] getHostKey() {
        return this.hostKey;
    }

    public String getMessageName() {
        return "SSH_MSG_KEXDH_REPLY";
    }

    public byte[] getSignature() {
        return this.signature;
    }

    protected void constructByteArray(ByteArrayWriter byteArrayWriter) throws InvalidMessageException {
        try {
            byteArrayWriter.writeBinaryString(this.hostKey);
            byteArrayWriter.writeBigInteger(this.f);
            byteArrayWriter.writeBinaryString(this.signature);
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error writing message data: " + iOException.getMessage());
        }
    }

    protected void constructMessage(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        try {
            this.hostKey = byteArrayReader.readBinaryString();
            this.f = byteArrayReader.readBigInteger();
            this.signature = byteArrayReader.readBinaryString();
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Error reading message data: " + iOException.getMessage());
        }
    }
}

