/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import com.sshtools.j2ssh.util.SimpleASNReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SshDssPrivateKey
extends SshPrivateKey {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey = SshDssPrivateKey.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssPrivateKey")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey);
    DSAPrivateKey prvkey;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPrivateKey;

    public SshDssPrivateKey(DSAPrivateKey dSAPrivateKey) {
        this.prvkey = dSAPrivateKey;
    }

    public SshDssPrivateKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.prvkey = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof SshDssPrivateKey) {
            return this.prvkey.equals(((SshDssPrivateKey)object).prvkey);
        }
        return false;
    }

    public int hashCode() {
        return this.prvkey.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.prvkey.getX().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString("ssh-dss");
            byteArrayWriter.writeBigInteger(this.prvkey.getParams().getP());
            byteArrayWriter.writeBigInteger(this.prvkey.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.prvkey.getParams().getG());
            byteArrayWriter.writeBigInteger(this.prvkey.getX());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public SshPublicKey getPublicKey() {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.getY(), this.prvkey.getParams().getP(), this.prvkey.getParams().getQ(), this.prvkey.getParams().getG());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return new SshDssPublicKey((DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public byte[] generateSignature(byte[] byArray) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initSign(this.prvkey);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            byte[] byArray3 = new byte[40];
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            simpleASNReader.getByte();
            simpleASNReader.getLength();
            simpleASNReader.getByte();
            byte[] byArray4 = simpleASNReader.getData();
            simpleASNReader.getByte();
            byte[] byArray5 = simpleASNReader.getData();
            if (byArray4.length >= 20) {
                System.arraycopy(byArray4, byArray4.length - 20, byArray3, 0, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray3, 20 - byArray4.length, byArray4.length);
            }
            if (byArray5.length >= 20) {
                System.arraycopy(byArray5, byArray5.length - 20, byArray3, 20, 20);
            } else {
                System.arraycopy(byArray5, 0, byArray3, 20 + (20 - byArray5.length), byArray5.length);
            }
            if (log.isDebugEnabled()) {
                log.debug("s length is " + String.valueOf(byArray5.length));
                log.debug("r length is " + String.valueOf(byArray4.length));
                object = "";
                int n = 0;
                while (n < byArray2.length) {
                    object = (String)object + Integer.toHexString(byArray2[n] & 0xFF) + " ";
                    ++n;
                }
                log.debug("Java signature is " + (String)object);
                object = "";
                int n2 = 0;
                while (n2 < byArray3.length) {
                    object = (String)object + Integer.toHexString(byArray3[n2] & 0xFF) + " ";
                    ++n2;
                }
                log.debug("SSH signature is " + (String)object);
            }
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(this.getAlgorithmName());
            ((ByteArrayWriter)object).writeBinaryString(byArray3);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new InvalidSshKeySignatureException(exception);
        }
    }

    private BigInteger getY() {
        return this.prvkey.getParams().getG().modPow(this.prvkey.getX(), this.prvkey.getParams().getP());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

