/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import com.sshtools.j2ssh.transport.ConsoleHostKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.TransportProtocolClient;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SshClient {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$SshClient == null ? (class$com$sshtools$j2ssh$SshClient = SshClient.class$("com.sshtools.j2ssh.SshClient")) : class$com$sshtools$j2ssh$SshClient));
    protected AuthenticationProtocolClient authentication;
    protected ConnectionProtocol connection;
    protected ForwardingClient forwarding;
    protected List authMethods;
    protected Socket socket;
    protected String authenticationBanner;
    protected TransportProtocolClient transport;
    protected int authenticationState = 1;
    protected int connectTimeout = 10000;
    protected int socketTimeout = 0;
    protected TransportProtocolEventHandler eventHandler = null;
    protected Vector activeChannels = new Vector();
    protected ActiveChannelEventListener eventListener = new ActiveChannelEventListener();
    protected boolean useDefaultForwarding = true;
    static /* synthetic */ Class class$com$sshtools$j2ssh$SshClient;

    public String getAuthenticationBanner(int n) {
        if (this.authentication == null) {
            return "";
        }
        return this.authentication.getBannerMessage(n);
    }

    public List getAvailableAuthMethods(String string) throws IOException {
        if (this.authentication != null) {
            return this.authentication.getAvailableAuths(string, this.connection.getServiceName());
        }
        return null;
    }

    public boolean isConnected() {
        TransportProtocolState transportProtocolState = this.transport == null ? null : this.transport.getState();
        int n = transportProtocolState == null ? 5 : transportProtocolState.getValue();
        return n == 4 || n == 3;
    }

    public String getServerId() {
        return this.transport.getRemoteId();
    }

    public SshPublicKey getServerHostKey() {
        return this.transport.getServerHostKey();
    }

    public TransportProtocolState getConnectionState() {
        return this.transport.getState();
    }

    public ForwardingClient getForwardingClient() {
        return this.forwarding;
    }

    public int getRemoteEOL() {
        return this.transport.getRemoteEOL();
    }

    public void setEventHandler(TransportProtocolEventHandler transportProtocolEventHandler) {
        if (this.transport != null) {
            this.transport.addEventHandler(transportProtocolEventHandler);
        } else {
            this.eventHandler = transportProtocolEventHandler;
        }
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public String getRemoteEOLString() {
        return this.transport.getRemoteEOL() == 1 ? "\r\n" : "\n";
    }

    public int authenticate(SshAuthenticationClient sshAuthenticationClient) throws IOException {
        this.authenticationState = this.authentication.authenticate(sshAuthenticationClient, this.connection);
        return this.authenticationState;
    }

    public boolean acceptsKey(String string, SshPublicKey sshPublicKey) throws IOException {
        if (this.authenticationState != 4) {
            PublicKeyAuthenticationClient publicKeyAuthenticationClient = new PublicKeyAuthenticationClient();
            return publicKeyAuthenticationClient.acceptsKey(this.authentication, string, this.connection.getServiceName(), sshPublicKey);
        }
        throw new SshException("Authentication has been completed!");
    }

    public void connect(String string) throws IOException {
        this.connect(string, 22, new ConsoleHostKeyVerification());
    }

    public void connect(String string, HostKeyVerification hostKeyVerification) throws IOException {
        this.connect(string, 22, hostKeyVerification);
    }

    public void connect(String string, int n) throws IOException {
        this.connect(string, n, new ConsoleHostKeyVerification());
    }

    public void connect(String string, int n, HostKeyVerification hostKeyVerification) throws IOException {
        SshConnectionProperties sshConnectionProperties = new SshConnectionProperties();
        sshConnectionProperties.setHost(string);
        sshConnectionProperties.setPort(n);
        this.connect(sshConnectionProperties, hostKeyVerification);
    }

    public void connect(SshConnectionProperties sshConnectionProperties) throws IOException {
        this.connect(sshConnectionProperties, (HostKeyVerification)new ConsoleHostKeyVerification());
    }

    public void connect(SshConnectionProperties sshConnectionProperties, HostKeyVerification hostKeyVerification) throws IOException {
        this.socket = new Socket();
        this.socket.setSoTimeout(this.socketTimeout);
        this.socket.connect(new InetSocketAddress(sshConnectionProperties.getHost(), sshConnectionProperties.getPort()), this.connectTimeout);
        this.transport = new TransportProtocolClient(hostKeyVerification);
        this.transport.addEventHandler(this.eventHandler);
        this.transport.startTransportProtocol(this.socket, sshConnectionProperties);
        this.authentication = new AuthenticationProtocolClient();
        this.transport.requestService(this.authentication);
        this.connection = new ConnectionProtocol();
        if (this.useDefaultForwarding) {
            this.forwarding = new ForwardingClient(this.connection);
        }
    }

    public SshConnectionProperties getProperties() {
        return this.transport.getProperties();
    }

    public void setKexTimeout(long l) throws IOException {
        this.transport.setKexTimeout(l);
    }

    public void setKexTransferLimit(long l) throws IOException {
        this.transport.setKexTransferLimit(l);
    }

    public void setSendIgnore(boolean bl) {
        this.transport.setSendIgnore(bl);
    }

    public void setUseDefaultForwarding(boolean bl) {
        this.useDefaultForwarding = bl;
    }

    public void disconnect() {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (this.transport != null) {
            this.transport.disconnect("Terminating connection");
        }
    }

    public long getOutgoingByteCount() {
        return this.transport.getOutgoingByteCount();
    }

    public long getIncomingByteCount() {
        return this.transport.getIncomingByteCount();
    }

    public int getActiveChannelCount() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            int n = this.activeChannels.size();
            return n;
        }
    }

    public List getActiveChannels() {
        Vector vector = this.activeChannels;
        synchronized (vector) {
            List list = (List)this.activeChannels.clone();
            return list;
        }
    }

    public boolean hasActiveSession(String string) {
        Iterator iterator = ((AbstractList)this.activeChannels).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SessionChannelClient) || !((SessionChannelClient)e).getSessionType().equals(string)) continue;
            return true;
        }
        return false;
    }

    public SessionChannelClient getActiveSession(String string) throws IOException {
        Iterator iterator = ((AbstractList)this.activeChannels).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof SessionChannelClient) || !((SessionChannelClient)e).getSessionType().equals(string)) continue;
            return (SessionChannelClient)e;
        }
        throw new IOException(String.valueOf(String.valueOf(new StringBuffer("There are no active ").append(string).append(" sessions"))));
    }

    public SessionChannelClient openSessionChannel() throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        SessionChannelClient sessionChannelClient = new SessionChannelClient();
        if (!this.connection.openChannel(sessionChannelClient, this.eventListener)) {
            throw new SshException("The server refused to open a session");
        }
        return sessionChannelClient;
    }

    public SftpSubsystemClient openSftpChannel() throws IOException {
        SftpSubsystemClient sftpSubsystemClient;
        SessionChannelClient sessionChannelClient = this.openSessionChannel();
        if (!sessionChannelClient.startSubsystem(sftpSubsystemClient = new SftpSubsystemClient())) {
            throw new SshException("The SFTP subsystem failed to start");
        }
        return sftpSubsystemClient;
    }

    public boolean openChannel(Channel channel) throws IOException {
        if (this.authenticationState != 4) {
            throw new SshException("Authentication has not been completed!");
        }
        return this.connection.openChannel(channel, this.eventListener);
    }

    public void allowChannelOpen(String string, ChannelFactory channelFactory) throws IOException {
        this.connection.addChannelFactory(string, channelFactory);
    }

    public boolean sendGlobalRequest(String string, boolean bl, byte[] byArray) throws IOException {
        return this.connection.sendGlobalRequest(string, bl, byArray);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ActiveChannelEventListener
    implements ChannelEventListener {
        ActiveChannelEventListener() {
        }

        public void onChannelOpen(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.add(channel);
            }
        }

        public void onChannelEOF(Channel channel) {
        }

        public void onChannelClose(Channel channel) {
            Vector vector = SshClient.this.activeChannels;
            synchronized (vector) {
                SshClient.this.activeChannels.remove(channel);
            }
        }

        public void onDataReceived(Channel channel, int n) {
        }

        public void onDataSent(Channel channel, int n) {
        }
    }
}

