/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolServer;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.TransportProtocolServer;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class SshServer {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$SshServer == null ? (class$com$sshtools$j2ssh$SshServer = SshServer.class$("com.sshtools.j2ssh.SshServer")) : class$com$sshtools$j2ssh$SshServer));
    private ConnectionListener listener = null;
    private ServerSocket server = null;
    private boolean shutdown = false;
    static /* synthetic */ Class class$com$sshtools$j2ssh$SshServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$SshServer$ConnectionListener;

    public SshServer() throws SshException {
        String string = System.getProperty("sshtools.serverid");
        if (string != null) {
            TransportProtocolCommon.SOFTWARE_VERSION_COMMENTS = string;
        }
        if (!ConfigurationLoader.isServerConfigured()) {
            throw new SshException("Server configuration not available!");
        }
        if (!ConfigurationLoader.isPlatformConfigured()) {
            throw new SshException("Platfrom configuration not available");
        }
        if (ConfigurationLoader.getServerConfiguration().getServerHostKeys().size() <= 0) {
            throw new SshException("Server cannot start because there are no server host keys available");
        }
    }

    public void startServer() throws IOException {
        log.info((Object)"Starting server");
        this.startServerSocket();
        this.startCommandSocket();
    }

    protected void processCommand(int n, Socket socket) throws IOException {
        if (n == 58) {
            this.stopServer();
        }
    }

    protected void startCommandSocket() throws IOException {
        block3: {
            try {
                Socket socket;
                ServerSocket serverSocket = new ServerSocket(ConfigurationLoader.getServerConfiguration().getCommandPort(), 50, InetAddress.getLocalHost());
                while ((socket = serverSocket.accept()) != null) {
                    log.info((Object)"Command request received");
                    this.processCommand(socket.getInputStream().read(), socket);
                    socket.close();
                    if (!this.shutdown) continue;
                }
                serverSocket.close();
            }
            catch (Exception exception) {
                if (this.shutdown) break block3;
                log.fatal((Object)"The command socket failed", (Throwable)exception);
            }
        }
    }

    protected void startServerSocket() throws IOException {
        this.listener = new ConnectionListener(ConfigurationLoader.getServerConfiguration().getListenAddress(), ConfigurationLoader.getServerConfiguration().getPort());
        this.listener.start();
    }

    protected void stopServer() throws IOException {
        log.info((Object)"Shutting down");
        this.listener.stop();
        this.listener = null;
        System.exit(0);
    }

    protected abstract void configureServices(ConnectionProtocol var1) throws IOException;

    protected void refuseSession(Socket socket) throws IOException {
        TransportProtocolServer transportProtocolServer = new TransportProtocolServer(true);
        transportProtocolServer.startTransportProtocol(socket, new SshConnectionProperties());
    }

    protected TransportProtocolServer createSession(Socket socket) throws IOException {
        log.debug((Object)"Initializing connection");
        InetAddress inetAddress = ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress();
        log.debug((Object)"Remote Hostname: ".concat(String.valueOf(String.valueOf(inetAddress.getHostName()))));
        log.debug((Object)"Remote IP: ".concat(String.valueOf(String.valueOf(inetAddress.getHostAddress()))));
        TransportProtocolServer transportProtocolServer = new TransportProtocolServer();
        AuthenticationProtocolServer authenticationProtocolServer = new AuthenticationProtocolServer();
        ConnectionProtocol connectionProtocol = new ConnectionProtocol();
        this.configureServices(connectionProtocol);
        authenticationProtocolServer.acceptService(connectionProtocol);
        transportProtocolServer.acceptService(authenticationProtocolServer);
        transportProtocolServer.startTransportProtocol(socket, new SshConnectionProperties());
        return transportProtocolServer;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ConnectionListener
    implements Runnable {
        private List activeConnections = new Vector();
        private Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$SshServer$ConnectionListener == null ? (class$com$sshtools$j2ssh$SshServer$ConnectionListener = SshServer.class$("com.sshtools.j2ssh.SshServer$ConnectionListener")) : class$com$sshtools$j2ssh$SshServer$ConnectionListener));
        private ServerSocket server;
        private String listenAddress;
        private Thread thread;
        private int maxConnections;
        private int port;
        private StartStopState state = new StartStopState(2);

        public ConnectionListener(String string, int n) {
            this.port = n;
            this.listenAddress = string;
        }

        public List getActiveConnections() {
            return this.activeConnections;
        }

        public void run() {
            try {
                try {
                    Socket socket;
                    this.log.debug((Object)"Starting connection listener thread");
                    this.state.setValue(1);
                    this.server = new ServerSocket(this.port);
                    this.maxConnections = ConfigurationLoader.getServerConfiguration().getMaxConnections();
                    boolean bl = false;
                    TransportProtocolEventHandler transportProtocolEventHandler = new TransportProtocolEventHandler(this){
                        private final /* synthetic */ ConnectionListener this$1;
                        {
                            this.this$1 = connectionListener;
                        }

                        public void onSocketTimeout(TransportProtocol transportProtocol, boolean bl) {
                        }

                        public void onDisconnect(TransportProtocol transportProtocol) {
                            List list = ConnectionListener.access$0(this.this$1);
                            synchronized (list) {
                                ConnectionListener.access$1(this.this$1).info((Object)String.valueOf(String.valueOf(transportProtocol.getRemoteAddress().getHostName())).concat(" connection closed"));
                                ConnectionListener.access$0(this.this$1).remove(transportProtocol);
                            }
                        }
                    };
                    while ((socket = this.server.accept()) != null && this.state.getValue() == 1) {
                        this.log.debug((Object)"New connection requested");
                        if (this.maxConnections < this.activeConnections.size()) {
                            SshServer.this.refuseSession(socket);
                            continue;
                        }
                        TransportProtocolServer transportProtocolServer = SshServer.this.createSession(socket);
                        this.log.info((Object)"Monitoring active session from ".concat(String.valueOf(String.valueOf(socket.getInetAddress().getCanonicalHostName()))));
                        List list = this.activeConnections;
                        synchronized (list) {
                            this.activeConnections.add(transportProtocolServer);
                        }
                        transportProtocolServer.addEventHandler(transportProtocolEventHandler);
                    }
                    this.stop();
                    this.log.info((Object)"Exiting connection listener thread");
                }
                catch (IOException iOException) {
                    if (this.state.getValue() != 2) {
                        this.log.debug((Object)"The listening socket failed", (Throwable)iOException);
                    }
                    Object var7_8 = null;
                    this.thread = null;
                }
                Object var7_7 = null;
                this.thread = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.thread = null;
                throw throwable;
            }
        }

        public void start() {
            this.thread = new SshThread(this, "Connection listener", true);
            this.thread.start();
        }

        public void stop() {
            try {
                this.state.setValue(2);
                this.server.close();
                Iterator iterator = this.activeConnections.iterator();
                while (iterator.hasNext()) {
                    TransportProtocol transportProtocol = (TransportProtocol)iterator.next();
                    transportProtocol.disconnect("The server is shutting down");
                }
            }
            catch (IOException iOException) {
                this.log.warn((Object)"The listening socket failed to stop cleanly", (Throwable)iOException);
            }
        }

        static /* synthetic */ List access$0(ConnectionListener connectionListener) {
            return connectionListener.activeConnections;
        }

        static /* synthetic */ Logger access$1(ConnectionListener connectionListener) {
            return connectionListener.log;
        }
    }
}

