/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentForwardingChannel;
import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SshAgentForwardingListener {
    ServerSocket server;
    int port;
    String location;
    StartStopState state = new StartStopState(2);
    Thread thread;
    ConnectionProtocol connection;
    Vector references = new Vector();
    String sessionId;
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$agent$SshAgentForwardingListener == null ? (class$com$sshtools$j2ssh$agent$SshAgentForwardingListener = SshAgentForwardingListener.class$("com.sshtools.j2ssh.agent.SshAgentForwardingListener")) : class$com$sshtools$j2ssh$agent$SshAgentForwardingListener));
    private static HashMap agents = new HashMap();
    static /* synthetic */ Class class$com$sshtools$j2ssh$agent$SshAgentForwardingListener;

    SshAgentForwardingListener(String string, ConnectionProtocol connectionProtocol) {
        log.info((Object)"Forwarding agent started");
        this.sessionId = string;
        this.connection = connectionProtocol;
        this.port = this.selectPort();
        this.location = "localhost:".concat(String.valueOf(String.valueOf(String.valueOf(this.port))));
        this.thread = new Thread(new Runnable(){

            public void run() {
                block3: {
                    SshAgentForwardingListener.this.state.setValue(1);
                    try {
                        Socket socket;
                        SshAgentForwardingListener.this.server = new ServerSocket();
                        SshAgentForwardingListener.this.server.bind(new InetSocketAddress("localhost", SshAgentForwardingListener.this.port));
                        while (SshAgentForwardingListener.this.state.getValue() == 1 && (socket = SshAgentForwardingListener.this.server.accept()) != null) {
                            AgentForwardingChannel agentForwardingChannel = new AgentForwardingChannel(true);
                            agentForwardingChannel.bindSocket(socket);
                            if (SshAgentForwardingListener.this.connection.openChannel(agentForwardingChannel)) continue;
                            log.warn((Object)"Failed to open agent forwarding channel");
                        }
                    }
                    catch (Exception exception) {
                        if (SshAgentForwardingListener.this.state.getValue() != 1) break block3;
                        log.warn((Object)"Forwarding agent socket failed", (Throwable)exception);
                    }
                }
                SshAgentForwardingListener.this.state.setValue(2);
            }
        });
    }

    public String getConfiguration() {
        return this.location;
    }

    public void addReference(Object object) {
        if (!this.references.contains(object)) {
            this.references.add(object);
        }
    }

    public void removeReference(Object object) {
        if (this.references.contains(object)) {
            this.references.remove(object);
            if (this.references.size() == 0) {
                this.stop();
                agents.remove(this.sessionId);
            }
        }
    }

    public void start() throws IOException {
        this.thread.start();
    }

    public int getPort() {
        return this.port;
    }

    public void stop() {
        try {
            this.state.setValue(2);
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int selectPort() {
        return 49152 + Math.round(16383.0f * ConfigurationLoader.getRND().nextFloat());
    }

    public static SshAgentForwardingListener getInstance(String string, ConnectionProtocol connectionProtocol) throws AgentNotAvailableException {
        if (agents.containsKey(string)) {
            SshAgentForwardingListener sshAgentForwardingListener = (SshAgentForwardingListener)agents.get(string);
            return sshAgentForwardingListener;
        }
        try {
            SshAgentForwardingListener sshAgentForwardingListener = new SshAgentForwardingListener(string, connectionProtocol);
            sshAgentForwardingListener.start();
            agents.put(string, sshAgentForwardingListener);
            SshAgentForwardingListener sshAgentForwardingListener2 = sshAgentForwardingListener;
            return sshAgentForwardingListener2;
        }
        catch (IOException iOException) {
            throw new AgentNotAvailableException();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

