/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.log4j.Logger;

public class HostbasedAuthenticationClient
extends SshAuthenticationClient {
    private Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$authentication$HostbasedAuthenticationClient == null ? (class$com$sshtools$j2ssh$authentication$HostbasedAuthenticationClient = HostbasedAuthenticationClient.class$("com.sshtools.j2ssh.authentication.HostbasedAuthenticationClient")) : class$com$sshtools$j2ssh$authentication$HostbasedAuthenticationClient));
    protected SshPrivateKey key;
    private String privateKeyFile = null;
    private String passphrase = null;
    private String clientUser = null;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$HostbasedAuthenticationClient;

    public void setKey(SshPrivateKey sshPrivateKey) {
        this.key = sshPrivateKey;
    }

    public void setClientUsername(String string) {
        this.clientUser = string;
    }

    public String getMethodName() {
        return "hostbased";
    }

    public void authenticate(AuthenticationProtocolClient authenticationProtocolClient, String string) throws TerminatedStateException, IOException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        this.log.info((Object)"Generating data to sign");
        SshPublicKey sshPublicKey = this.key.getPublicKey();
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string2 = "mars";
        this.log.info((Object)"Preparing hostbased authentication request for ".concat(String.valueOf(String.valueOf(string2))));
        byteArrayWriter.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter.writeString(string2);
        if (this.clientUser != null) {
            byteArrayWriter.writeString(this.clientUser);
        } else {
            byteArrayWriter.writeString(this.getUsername());
        }
        ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
        byteArrayWriter2.writeBinaryString(authenticationProtocolClient.getSessionIdentifier());
        byteArrayWriter2.write(50);
        byteArrayWriter2.writeString(this.getUsername());
        byteArrayWriter2.writeString(string);
        byteArrayWriter2.writeString(this.getMethodName());
        byteArrayWriter2.writeString(sshPublicKey.getAlgorithmName());
        byteArrayWriter2.writeBinaryString(sshPublicKey.getEncoded());
        byteArrayWriter2.writeString(string2);
        if (this.clientUser != null) {
            byteArrayWriter2.writeString(this.clientUser);
        } else {
            byteArrayWriter2.writeString(this.getUsername());
        }
        byteArrayWriter.writeBinaryString(this.key.generateSignature(byteArrayWriter2.toByteArray()));
        SshMsgUserAuthRequest sshMsgUserAuthRequest = new SshMsgUserAuthRequest(this.getUsername(), string, this.getMethodName(), byteArrayWriter.toByteArray());
        authenticationProtocolClient.sendMessage(sshMsgUserAuthRequest);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.privateKeyFile != null) {
            properties.setProperty("PrivateKey", this.privateKeyFile);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.privateKeyFile = properties.getProperty("PrivateKey");
        }
        if (properties.getProperty("Passphrase") != null) {
            this.passphrase = properties.getProperty("Passphrase");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

