/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.SshAuthenticationServer;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SshAuthenticationServerFactory {
    private static Map auths;
    private static Logger log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$KBIPasswordAuthenticationServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PasswordAuthenticationServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$authentication$SshAuthenticationServerFactory;

    protected SshAuthenticationServerFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList arrayList = new ArrayList(auths.keySet());
        return arrayList;
    }

    public static SshAuthenticationServer newInstance(String string) throws AlgorithmNotSupportedException {
        try {
            SshAuthenticationServer sshAuthenticationServer = (SshAuthenticationServer)((Class)auths.get(string)).newInstance();
            return sshAuthenticationServer;
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(String.valueOf(string)).concat(" is not supported!"));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$authentication$SshAuthenticationServerFactory == null ? (class$com$sshtools$j2ssh$authentication$SshAuthenticationServerFactory = SshAuthenticationServerFactory.class$("com.sshtools.j2ssh.authentication.SshAuthenticationServerFactory")) : class$com$sshtools$j2ssh$authentication$SshAuthenticationServerFactory));
        auths = new HashMap();
        log.info((Object)"Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, class$com$sshtools$j2ssh$authentication$PasswordAuthenticationServer == null ? (class$com$sshtools$j2ssh$authentication$PasswordAuthenticationServer = SshAuthenticationServerFactory.class$("com.sshtools.j2ssh.authentication.PasswordAuthenticationServer")) : class$com$sshtools$j2ssh$authentication$PasswordAuthenticationServer);
        auths.put(AUTH_PK, class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationServer == null ? (class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationServer = SshAuthenticationServerFactory.class$("com.sshtools.j2ssh.authentication.PublicKeyAuthenticationServer")) : class$com$sshtools$j2ssh$authentication$PublicKeyAuthenticationServer);
        auths.put(AUTH_KBI, class$com$sshtools$j2ssh$authentication$KBIPasswordAuthenticationServer == null ? (class$com$sshtools$j2ssh$authentication$KBIPasswordAuthenticationServer = SshAuthenticationServerFactory.class$("com.sshtools.j2ssh.authentication.KBIPasswordAuthenticationServer")) : class$com$sshtools$j2ssh$authentication$KBIPasswordAuthenticationServer);
        try {
            SshAPIConfiguration sshAPIConfiguration = ConfigurationLoader.getAPIConfiguration();
            if (sshAPIConfiguration != null) {
                List list = sshAPIConfiguration.getAuthenticationExtensions();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ExtensionAlgorithm extensionAlgorithm = (ExtensionAlgorithm)iterator.next();
                    String string = extensionAlgorithm.getAlgorithmName();
                    if (auths.containsKey(string)) {
                        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Standard authentication implementation for ").append(string).append(" is being overidden by ").append(extensionAlgorithm.getImplementationClass()))));
                    } else {
                        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(" authentication is implemented by ").append(extensionAlgorithm.getImplementationClass()))));
                    }
                    try {
                        Class clazz = ConfigurationLoader.getExtensionClass(extensionAlgorithm.getImplementationClass());
                        Object t = clazz.newInstance();
                        if (!(t instanceof SshAuthenticationServer)) continue;
                        auths.put(string, clazz);
                    }
                    catch (Exception exception) {
                        log.warn((Object)"Failed to load extension authentication implementation ".concat(String.valueOf(String.valueOf(extensionAlgorithm.getImplementationClass()))), (Throwable)exception);
                    }
                }
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

