/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.authentication.SshAuthenticationServerFactory;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.PlatformConfiguration;
import com.sshtools.j2ssh.configuration.ServerConfiguration;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.configuration.automate.AutomationConfiguration;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.util.DynamicClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.PropertyPermission;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class ConfigurationLoader {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader));
    private static SshAPIConfiguration config;
    private static ServerConfiguration server;
    private static PlatformConfiguration platform;
    private static AutomationConfiguration automation;
    private static String configDirectory;
    private static String configResource;
    private static String hostsResource;
    private static String serverResource;
    private static String platformResource;
    private static String automationResource;
    private static String homeDir;
    private static ClassLoader ext;
    private static ClassLoader clsLoader;
    private static SecureRandom rnd;
    private static String logfile;
    private static boolean initialized;
    private static boolean performingInitialization;
    private static Object initializationLock;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$ConfigurationLoader;

    protected ConfigurationLoader() {
    }

    public static SecureRandom getRND() {
        if (rnd == null) {
            rnd = new SecureRandom();
            rnd.nextInt();
        }
        return rnd;
    }

    public static String getVersionString(String string, String string2) {
        Properties properties = new Properties();
        String string3 = string;
        try {
            properties.load(ConfigurationLoader.loadFile(string2));
            String string4 = string.toLowerCase();
            String string5 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".version.major"));
            String string6 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".version.minor"));
            String string7 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".version.build"));
            String string8 = properties.getProperty(String.valueOf(String.valueOf(string4)).concat(".project.type"));
            if (string5 != null && string6 != null && string7 != null) {
                string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer(" ").append(string5).append(".").append(string6).append(".").append(string7))))));
            }
            if (string8 != null) {
                string3 = String.valueOf(String.valueOf(string3)).concat(String.valueOf(String.valueOf(" ".concat(String.valueOf(String.valueOf(string8))))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public static String checkAndGetProperty(String string, String string2) {
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new PropertyPermission(string, "read"));
            }
            String string3 = System.getProperty(string, string2);
            return string3;
        }
        catch (AccessControlException accessControlException) {
            String string4 = string2;
            return string4;
        }
    }

    public static void setLogfile(String string) throws IOException {
        logfile = string;
        if (string.equals("@console@")) {
            BasicConfigurator.configure();
        } else {
            RollingFileAppender rollingFileAppender = new RollingFileAppender((Layout)new PatternLayout("%-5p [%t]: %m%n"), string, true);
            rollingFileAppender.setMaxFileSize("100KB");
            BasicConfigurator.configure((Appender)rollingFileAppender);
        }
    }

    public static void initialize(boolean bl) {
        Object object = initializationLock;
        synchronized (object) {
            if (initialized && !bl) {
                return;
            }
            performingInitialization = true;
            try {
                File file = new File(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(homeDir))).append("lib").append(File.separator).append("ext"))));
                FilenameFilter filenameFilter = new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                };
                File[] fileArray = file.listFiles(filenameFilter);
                Vector<String> vector = new Vector<String>();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Extension ").append(fileArray[i].getAbsolutePath()).append(" being added to classpath"))));
                        vector.add(fileArray[i].getAbsolutePath());
                    }
                }
                ext = new DynamicClassLoader((class$com$sshtools$j2ssh$configuration$ConfigurationLoader == null ? (class$com$sshtools$j2ssh$configuration$ConfigurationLoader = ConfigurationLoader.class$("com.sshtools.j2ssh.configuration.ConfigurationLoader")) : class$com$sshtools$j2ssh$configuration$ConfigurationLoader).getClassLoader(), vector);
            }
            catch (AccessControlException accessControlException) {
                log.info((Object)"Cannot access lib/ext directory, extension classes will not be loaded");
            }
            ConfigurationLoader.loadAPIConfiguration();
            ConfigurationLoader.loadServerConfiguration();
            ConfigurationLoader.loadPlatformConfiguration();
            ConfigurationLoader.loadAutomationConfiguration();
            SshCipherFactory.initialize();
            SshAuthenticationClientFactory.initialize();
            SshAuthenticationServerFactory.initialize();
            SshHmacFactory.initialize();
            SshCompressionFactory.initialize();
            SshKeyExchangeFactory.initialize();
            SshKeyPairFactory.initialize();
            performingInitialization = false;
            initialized = true;
        }
    }

    public static boolean isAPIConfigured() {
        return config != null;
    }

    public static SshAPIConfiguration getAPIConfiguration() throws ConfigurationException {
        Object object = initializationLock;
        synchronized (object) {
            if (!initialized && !performingInitialization) {
                ConfigurationLoader.initialize(true);
            }
            if (config == null) {
                throw new ConfigurationException("No valid API configuration is available");
            }
            SshAPIConfiguration sshAPIConfiguration = config;
            return sshAPIConfiguration;
        }
    }

    public static void setAPIConfigurationResource(String string) {
        configResource = string;
    }

    public static String getConfigurationDirectory() {
        return configDirectory;
    }

    public static Class getExtensionClass(String string) throws ClassNotFoundException {
        if (ext == null) {
            throw new ClassNotFoundException("Configuration not initialized");
        }
        return ext.loadClass(string);
    }

    public static String getHomeDirectory() {
        return homeDir;
    }

    public static boolean isPlatformConfigured() {
        return platform != null;
    }

    public static PlatformConfiguration getPlatformConfiguration() throws ConfigurationException {
        Object object = initializationLock;
        synchronized (object) {
            if (!initialized && !performingInitialization) {
                ConfigurationLoader.initialize(true);
            }
            if (platform == null) {
                throw new ConfigurationException("No valid platform configuration exists");
            }
            PlatformConfiguration platformConfiguration = platform;
            return platformConfiguration;
        }
    }

    public static boolean isAutomationConfigured() {
        return automation != null;
    }

    public static AutomationConfiguration getAutomationConfiguration() throws ConfigurationException {
        Object object = initializationLock;
        synchronized (object) {
            if (!initialized && !performingInitialization) {
                ConfigurationLoader.initialize(true);
            }
            if (automation == null) {
                throw new ConfigurationException("Automation configuration not available");
            }
            AutomationConfiguration automationConfiguration = automation;
            return automationConfiguration;
        }
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        clsLoader = classLoader;
    }

    public static ClassLoader getContextClassLoader() {
        return clsLoader;
    }

    public static boolean isContextClassLoader() {
        return clsLoader != null;
    }

    public static boolean isServerConfigured() {
        return server != null;
    }

    public static ServerConfiguration getServerConfiguration() throws ConfigurationException {
        Object object = initializationLock;
        synchronized (object) {
            if (!initialized && !performingInitialization) {
                ConfigurationLoader.initialize(true);
            }
            if (server == null) {
                throw new ConfigurationException("No valid server configuration is available");
            }
            ServerConfiguration serverConfiguration = server;
            return serverConfiguration;
        }
    }

    public static void setServerConfigurationResource(String string) {
        serverResource = string;
    }

    public static void setPlatformConfigurationResource(String string) {
        platformResource = string;
    }

    public static void setHomeDirectory(String string) {
        homeDir = string;
    }

    public static void setAutomationConfigurationResource(String string) {
        automationResource = string;
    }

    public static InputStream loadFile(String string) throws FileNotFoundException {
        log.info((Object)"Attempting to load ".concat(String.valueOf(String.valueOf(string))));
        try {
            FileInputStream fileInputStream;
            FileInputStream fileInputStream2 = fileInputStream = new FileInputStream(String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(string))));
            return fileInputStream2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info((Object)"Failed to load file from configuration directory, trying SSHTools home");
            try {
                FileInputStream fileInputStream;
                FileInputStream fileInputStream3 = fileInputStream = new FileInputStream(String.valueOf(String.valueOf(homeDir)).concat(String.valueOf(String.valueOf(string))));
                return fileInputStream3;
            }
            catch (FileNotFoundException fileNotFoundException2) {
                log.info((Object)"Failed to load file from SSHTools home directory, trying as absolute path");
                FileInputStream fileInputStream = new FileInputStream(string);
                return fileInputStream;
            }
        }
    }

    public static OutputStream saveFile(String string) throws FileNotFoundException {
        File file = new File(String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(string))));
        if (file.exists()) {
            return new FileOutputStream(file);
        }
        file = new File(string);
        if (file.exists()) {
            return new FileOutputStream(string);
        }
        return new FileOutputStream(string.indexOf(File.pathSeparator) >= 0 ? string : String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(string))));
    }

    private static URL getResourceURL(String string) {
        try {
            URL uRL = new URL(string);
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                URL uRL = new File(string).toURL();
                return uRL;
            }
            catch (MalformedURLException malformedURLException2) {
                URL uRL = null;
                return uRL;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadAPIConfiguration() {
        InputStream inputStream = null;
        URL uRL = ConfigurationLoader.getResourceURL(configResource);
        log.info((Object)"Loading api configuration from ".concat(String.valueOf(String.valueOf(uRL.toExternalForm()))));
        inputStream = uRL.openStream();
        config = new SshAPIConfiguration(inputStream);
        Object var3_3 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                log.warn((Object)"Api configuration not available");
                config = null;
                Object var3_4 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadPlatformConfiguration() {
        InputStream inputStream = null;
        URL uRL = ConfigurationLoader.getResourceURL(platformResource);
        log.info((Object)"Loading platform configuration from ".concat(String.valueOf(String.valueOf(uRL.toExternalForm()))));
        inputStream = uRL.openStream();
        platform = new PlatformConfiguration(inputStream);
        Object var3_3 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                log.warn((Object)"Platform configuration not available");
                platform = null;
                Object var3_4 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadAutomationConfiguration() {
        InputStream inputStream = null;
        URL uRL = ConfigurationLoader.getResourceURL(automationResource);
        log.info((Object)"Loading automation configuration from ".concat(String.valueOf(String.valueOf(uRL.toExternalForm()))));
        inputStream = uRL.openStream();
        automation = new AutomationConfiguration(inputStream);
        Object var3_3 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                log.warn((Object)"Automation configuration not available");
                automation = null;
                Object var3_4 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadServerConfiguration() {
        InputStream inputStream = null;
        URL uRL = ConfigurationLoader.getResourceURL(serverResource);
        log.info((Object)"Loading server configuration from ".concat(String.valueOf(String.valueOf(uRL.toExternalForm()))));
        inputStream = uRL.openStream();
        server = new ServerConfiguration(inputStream);
        Object var3_3 = null;
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (Exception exception) {
                log.warn((Object)"Server configuration not available");
                server = null;
                Object var3_4 = null;
                if (inputStream == null) return;
                try {
                    inputStream.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        clsLoader = null;
        logfile = null;
        initialized = false;
        performingInitialization = false;
        initializationLock = new Object();
        try {
            File file;
            homeDir = ConfigurationLoader.checkAndGetProperty("sshtools.home", null);
            configResource = ConfigurationLoader.checkAndGetProperty("sshtools.config", null);
            serverResource = ConfigurationLoader.checkAndGetProperty("sshtools.server", null);
            platformResource = ConfigurationLoader.checkAndGetProperty("sshtools.platform", null);
            automationResource = ConfigurationLoader.checkAndGetProperty("sshtools.automation", null);
            logfile = ConfigurationLoader.checkAndGetProperty("sshtools.logfile", null);
            try {
                if (logfile != null) {
                    ConfigurationLoader.setLogfile(logfile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (homeDir == null) {
                homeDir = System.getProperty("java.home");
                if (!homeDir.endsWith(File.separator)) {
                    homeDir = String.valueOf(String.valueOf(homeDir)).concat(String.valueOf(String.valueOf(File.separator)));
                }
                configDirectory = String.valueOf(String.valueOf(homeDir)).concat("lib");
            } else {
                file = new File(homeDir);
                try {
                    homeDir = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    log.warn((Object)"Failed to canonicalize home directory ".concat(String.valueOf(String.valueOf(homeDir))));
                }
                if (!homeDir.endsWith(File.separator)) {
                    homeDir = String.valueOf(String.valueOf(homeDir)).concat(String.valueOf(String.valueOf(File.separator)));
                }
                configDirectory = String.valueOf(String.valueOf(homeDir)).concat("conf");
            }
            if (!configDirectory.endsWith(File.separator)) {
                configDirectory = String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(File.separator)));
            }
            if (configResource == null) {
                configResource = String.valueOf(String.valueOf(configDirectory)).concat("sshtools.xml");
            } else {
                file = new File(configResource);
                if (!file.exists()) {
                    file = new File(String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(configResource))));
                    configResource = file.exists() ? String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(configResource))) : String.valueOf(String.valueOf(configDirectory)).concat("sshtools.xml");
                }
            }
            if (serverResource == null) {
                serverResource = String.valueOf(String.valueOf(configDirectory)).concat("server.xml");
            } else {
                file = new File(serverResource);
                if (!file.exists()) {
                    file = new File(String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(serverResource))));
                    serverResource = file.exists() ? String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(serverResource))) : String.valueOf(String.valueOf(configDirectory)).concat("server.xml");
                }
            }
            if (platformResource == null) {
                platformResource = String.valueOf(String.valueOf(configDirectory)).concat("platform.xml");
            } else {
                file = new File(platformResource);
                if (!file.exists()) {
                    file = new File(String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(platformResource))));
                    platformResource = file.exists() ? String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(platformResource))) : String.valueOf(String.valueOf(configDirectory)).concat("platform.xml");
                }
            }
            if (automationResource == null) {
                automationResource = String.valueOf(String.valueOf(configDirectory)).concat("automation.xml");
            } else {
                file = new File(automationResource);
                if (!file.exists()) {
                    file = new File(String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(automationResource))));
                    automationResource = file.exists() ? String.valueOf(String.valueOf(configDirectory)).concat(String.valueOf(String.valueOf(automationResource))) : String.valueOf(String.valueOf(configDirectory)).concat("automation.xml");
                }
            }
        }
        catch (AccessControlException accessControlException) {
            log.info((Object)"No access to system properties. Must use setAPIConfigurationResource() and / or setServerConfigurationResource() before using getAPIConfiguration() or getServerConfiguration()");
        }
    }
}

