/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.configuration.AllowedSubsystem;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerConfiguration
extends DefaultHandler {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$configuration$ServerConfiguration == null ? (class$com$sshtools$j2ssh$configuration$ServerConfiguration = ServerConfiguration.class$("com.sshtools.j2ssh.configuration.ServerConfiguration")) : class$com$sshtools$j2ssh$configuration$ServerConfiguration));
    private Map allowedSubsystems = new HashMap();
    private Map serverHostKeys = new HashMap();
    private List allowedAuthentications = new ArrayList();
    private List requiredAuthentications = new ArrayList();
    private int commandPort = 12222;
    private int port = 22;
    private String listenAddress = "0.0.0.0";
    private int maxConnections = 10;
    private int maxAuthentications = 5;
    private String terminalProvider = "";
    private String authorizationFile = "authorization.xml";
    private String userConfigDirectory = "%D/.ssh2";
    private String authenticationBanner = "";
    private boolean allowTcpForwarding = true;
    private String currentElement = null;
    private Class sessionChannelImpl = class$com$sshtools$j2ssh$session$SessionChannelServer == null ? (class$com$sshtools$j2ssh$session$SessionChannelServer = ServerConfiguration.class$("com.sshtools.j2ssh.session.SessionChannelServer")) : class$com$sshtools$j2ssh$session$SessionChannelServer;
    static /* synthetic */ Class class$com$sshtools$j2ssh$configuration$ServerConfiguration;
    static /* synthetic */ Class class$com$sshtools$j2ssh$session$SessionChannelServer;

    public ServerConfiguration(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.reload(inputStream);
    }

    public void reload(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        this.allowedSubsystems.clear();
        this.serverHostKeys.clear();
        this.allowedAuthentications.clear();
        this.requiredAuthentications.clear();
        this.commandPort = 12222;
        this.port = 22;
        this.listenAddress = "0.0.0.0";
        this.maxConnections = 10;
        this.maxAuthentications = 5;
        this.terminalProvider = "";
        this.authorizationFile = "authorization.xml";
        this.userConfigDirectory = "%D/.ssh2";
        this.authenticationBanner = "";
        this.allowTcpForwarding = true;
        this.currentElement = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)this);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block16: {
            if (this.currentElement == null) {
                if (!string3.equals("ServerConfiguration")) {
                    throw new SAXException("Unexpected root element ".concat(String.valueOf(String.valueOf(string3))));
                }
            } else if (this.currentElement.equals("ServerConfiguration")) {
                if (string3.equals("ServerHostKey")) {
                    String string4 = attributes.getValue("PrivateKeyFile");
                    if (string4 == null) {
                        throw new SAXException("Required attributes missing from <ServerHostKey> element");
                    }
                    log.debug((Object)"ServerHostKey PrivateKeyFile=".concat(String.valueOf(String.valueOf(string4))));
                    File file = new File(string4);
                    if (!file.exists()) {
                        string4 = String.valueOf(String.valueOf(ConfigurationLoader.getConfigurationDirectory())).concat(String.valueOf(String.valueOf(string4)));
                        file = new File(string4);
                    }
                    try {
                        if (file.exists()) {
                            SshPrivateKeyFile sshPrivateKeyFile = SshPrivateKeyFile.parse(file);
                            SshPrivateKey sshPrivateKey = sshPrivateKeyFile.toPrivateKey(null);
                            this.serverHostKeys.put(sshPrivateKey.getAlgorithmName(), sshPrivateKey);
                            break block16;
                        }
                        log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("Private key file '").append(string4).append("' could not be found"))));
                    }
                    catch (InvalidSshKeyException invalidSshKeyException) {
                        log.warn((Object)"Failed to load private key '".concat(String.valueOf(String.valueOf(string4))), (Throwable)invalidSshKeyException);
                    }
                    catch (IOException iOException) {
                        log.warn((Object)"Failed to load private key '".concat(String.valueOf(String.valueOf(string4))), (Throwable)iOException);
                    }
                } else if (string3.equals("Subsystem")) {
                    String string5 = attributes.getValue("Type");
                    String string6 = attributes.getValue("Name");
                    String string7 = attributes.getValue("Provider");
                    if (string5 == null || string6 == null || string7 == null) {
                        throw new SAXException("Required attributes missing from <Subsystem> element");
                    }
                    log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Subsystem Type=").append(string5).append(" Name=").append(string6).append(" Provider=").append(string7))));
                    this.allowedSubsystems.put(string6, new AllowedSubsystem(string5, string6, string7));
                } else if (!(string3.equals("AuthenticationBanner") || string3.equals("MaxConnections") || string3.equals("MaxAuthentications") || string3.equals("ListenAddress") || string3.equals("Port") || string3.equals("CommandPort") || string3.equals("TerminalProvider") || string3.equals("AllowedAuthentication") || string3.equals("RequiredAuthentication") || string3.equals("AuthorizationFile") || string3.equals("UserConfigDirectory") || string3.equals("AllowTcpForwarding"))) {
                    throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected <").append(string3).append("> element after SshAPIConfiguration"))));
                }
            }
        }
        this.currentElement = string3;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.currentElement != null) {
            if (this.currentElement.equals("AuthenticationBanner")) {
                this.authenticationBanner = string;
                log.debug((Object)"AuthenticationBanner=".concat(String.valueOf(String.valueOf(this.authenticationBanner))));
            } else if (this.currentElement.equals("MaxConnections")) {
                this.maxConnections = Integer.parseInt(string);
                log.debug((Object)"MaxConnections=".concat(String.valueOf(String.valueOf(string))));
            } else if (this.currentElement.equals("ListenAddress")) {
                this.listenAddress = string;
                log.debug((Object)"ListenAddress=".concat(String.valueOf(String.valueOf(this.listenAddress))));
            } else if (this.currentElement.equals("Port")) {
                this.port = Integer.parseInt(string);
                log.debug((Object)"Port=".concat(String.valueOf(String.valueOf(string))));
            } else if (this.currentElement.equals("CommandPort")) {
                this.commandPort = Integer.parseInt(string);
                log.debug((Object)"CommandPort=".concat(String.valueOf(String.valueOf(string))));
            } else if (this.currentElement.equals("TerminalProvider")) {
                this.terminalProvider = string;
                log.debug((Object)"TerminalProvider=".concat(String.valueOf(String.valueOf(this.terminalProvider))));
            } else if (this.currentElement.equals("AllowedAuthentication")) {
                if (!this.allowedAuthentications.contains(string)) {
                    this.allowedAuthentications.add(string);
                    log.debug((Object)"AllowedAuthentication=".concat(String.valueOf(String.valueOf(string))));
                }
            } else if (this.currentElement.equals("RequiredAuthentication")) {
                if (!this.requiredAuthentications.contains(string)) {
                    this.requiredAuthentications.add(string);
                    log.debug((Object)"RequiredAuthentication=".concat(String.valueOf(String.valueOf(string))));
                }
            } else if (this.currentElement.equals("AuthorizationFile")) {
                this.authorizationFile = string;
                log.debug((Object)"AuthorizationFile=".concat(String.valueOf(String.valueOf(this.authorizationFile))));
            } else if (this.currentElement.equals("UserConfigDirectory")) {
                this.userConfigDirectory = string;
                log.debug((Object)"UserConfigDirectory=".concat(String.valueOf(String.valueOf(this.userConfigDirectory))));
            } else if (this.currentElement.equals("SessionChannelImpl")) {
                try {
                    this.sessionChannelImpl = ConfigurationLoader.getExtensionClass(string);
                }
                catch (Exception exception) {
                    log.error((Object)"Failed to load SessionChannelImpl ".concat(String.valueOf(String.valueOf(string))), (Throwable)exception);
                }
            } else if (this.currentElement.equals("MaxAuthentications")) {
                this.maxAuthentications = Integer.parseInt(string);
                log.debug((Object)"MaxAuthentications=".concat(String.valueOf(String.valueOf(string))));
            } else if (this.currentElement.equals("AllowTcpForwarding")) {
                this.allowTcpForwarding = Boolean.valueOf(string);
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentElement != null) {
            if (!this.currentElement.equals(string3)) {
                throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected end element found <").append(string3).append(">"))));
            }
            if (this.currentElement.equals("ServerConfiguration")) {
                this.currentElement = null;
            } else if (this.currentElement.equals("AuthenticationBanner") || this.currentElement.equals("ServerHostKey") || this.currentElement.equals("Subsystem") || this.currentElement.equals("MaxConnections") || this.currentElement.equals("MaxAuthentications") || this.currentElement.equals("ListenAddress") || this.currentElement.equals("Port") || this.currentElement.equals("CommandPort") || this.currentElement.equals("TerminalProvider") || this.currentElement.equals("AllowedAuthentication") || this.currentElement.equals("RequiredAuthentication") || this.currentElement.equals("AuthorizationFile") || this.currentElement.equals("UserConfigDirectory") || this.currentElement.equals("AllowTcpForwarding")) {
                this.currentElement = "ServerConfiguration";
            }
        } else {
            throw new SAXException(String.valueOf(String.valueOf(new StringBuffer("Unexpected end element <").append(string3).append("> found"))));
        }
    }

    public List getRequiredAuthentications() {
        return this.requiredAuthentications;
    }

    public List getAllowedAuthentications() {
        return this.allowedAuthentications;
    }

    public boolean getAllowTcpForwarding() {
        return this.allowTcpForwarding;
    }

    public String getAuthenticationBanner() {
        return this.authenticationBanner;
    }

    public int getCommandPort() {
        return this.commandPort;
    }

    public String getUserConfigDirectory() {
        return this.userConfigDirectory;
    }

    public String getAuthorizationFile() {
        return this.authorizationFile;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxAuthentications() {
        return this.maxAuthentications;
    }

    public int getPort() {
        return this.port;
    }

    public Map getServerHostKeys() {
        return this.serverHostKeys;
    }

    public Map getSubsystems() {
        return this.allowedSubsystems;
    }

    public String getTerminalProvider() {
        return this.terminalProvider;
    }

    public String toString() {
        String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        string = String.valueOf(String.valueOf(string)).concat("<!-- Server configuration file - If filenames are not absolute they are assummed to be in the same directory as this configuration file. -->\n");
        string = String.valueOf(String.valueOf(string)).concat("<ServerConfiguration>\n");
        string = String.valueOf(String.valueOf(string)).concat("   <!-- The available host keys for server authentication -->\n");
        Iterator iterator = this.serverHostKeys.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <ServerHostKey PrivateKeyFile=\"").append(entry.getValue()).append("\"/>\n"))))));
        }
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Add any number of subsystem elements here -->\n");
        iterator = this.allowedSubsystems.entrySet().iterator();
        while (iterator.hasNext()) {
            AllowedSubsystem allowedSubsystem = (AllowedSubsystem)iterator.next().getValue();
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <Subsystem Name=\"").append(allowedSubsystem.getName()).append("\" Type=\"").append(allowedSubsystem.getType()).append("\" Provider=\"").append(allowedSubsystem.getProvider()).append("\"/>\n"))))));
        }
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Display the following authentication banner before authentication -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <AuthenticationBanner>").append(this.authenticationBanner).append("</AuthenticationBanner>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- The maximum number of connected sessions available -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <MaxConnections>").append(String.valueOf(this.maxConnections)).append("</MaxConnections>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- The maximum number of authentication attemtps for each connection -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <MaxAuthentications>").append(String.valueOf(this.maxAuthentications)).append("</MaxAuthentications>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Bind to the following address to listen for connections -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <ListenAddress>").append(this.listenAddress).append("</ListenAddress>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- The port to listen to -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <Port>").append(String.valueOf(this.port)).append("</Port>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Listen on the following port (on localhost) for server commands such as stop -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <CommandPort>").append(String.valueOf(this.commandPort)).append("</CommandPort>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Specify the executable that provides the default shell -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <TerminalProvider>").append(this.terminalProvider).append("</TerminalProvider>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Specify any number of allowed authentications -->\n");
        iterator = this.allowedAuthentications.iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <AllowedAuthentication>").append(iterator.next().toString()).append("</AllowedAuthentication>\n"))))));
        }
        string = String.valueOf(String.valueOf(string)).concat("   <!-- Specify any number of required authentications -->\n");
        iterator = this.requiredAuthentications.iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <RequiredAuthentication>").append(iterator.next().toString()).append("</RequiredAuthentication>\n"))))));
        }
        string = String.valueOf(String.valueOf(string)).concat("   <!-- The users authorizations file -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <AuthorizationFile>").append(this.authorizationFile).append("</AuthorizationFile>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("   <!-- The users configuration directory where files such as AuthorizationFile are found. For users home directory specify %D For users name specify %U  -->\n");
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("   <UserConfigDirectory>").append(this.userConfigDirectory).append("</UserConfigDirectory>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(new StringBuffer("<AllowTcpForwarding>").append(String.valueOf(this.allowTcpForwarding)).append("</AllowTcpForwarding>\n"))))));
        string = String.valueOf(String.valueOf(string)).concat("</ServerConfiguration>\n");
        return string;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

