/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFileLoader;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFileSaver;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.configuration.automate.RemoteIdentificationException;
import com.sshtools.j2ssh.configuration.automate.RemoteIdentificationFactory;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class AuthorizedKeys {
    private HashMap keys = new HashMap();

    public Map getAuthorizedKeys() {
        return this.keys;
    }

    public void addKey(String string, SshPublicKey sshPublicKey) {
        if (!this.containsKey(sshPublicKey)) {
            this.keys.put(string, sshPublicKey);
        }
    }

    public void removeKey(String string) {
        this.keys.remove(string);
    }

    public boolean containsKey(SshPublicKey sshPublicKey) {
        return this.keys.containsValue(sshPublicKey);
    }

    public static AuthorizedKeys parse(byte[] byArray, String string, AuthorizedKeysFileLoader authorizedKeysFileLoader) throws InvalidSshKeyException, IOException, RemoteIdentificationException {
        AuthorizedKeysFormat authorizedKeysFormat = RemoteIdentificationFactory.getInstance(string).getAuthorizedKeysFormat();
        if (authorizedKeysFormat.requiresKeyFiles()) {
            return authorizedKeysFormat.unformat(byArray, authorizedKeysFileLoader);
        }
        return authorizedKeysFormat.unformat(byArray);
    }

    public static byte[] create(AuthorizedKeys authorizedKeys, String string, AuthorizedKeysFileSaver authorizedKeysFileSaver) throws InvalidSshKeyException, IOException, RemoteIdentificationException {
        AuthorizedKeysFormat authorizedKeysFormat = RemoteIdentificationFactory.getInstance(string).getAuthorizedKeysFormat();
        if (authorizedKeysFormat.requiresKeyFiles()) {
            return authorizedKeysFormat.format(authorizedKeys, authorizedKeysFileSaver);
        }
        return authorizedKeysFormat.format(authorizedKeys);
    }
}

