/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.automate.AuthorizedKeys;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFileLoader;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFileSaver;
import com.sshtools.j2ssh.configuration.automate.AuthorizedKeysFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;

public class OpenSSHAuthorizedKeysFormat
implements AuthorizedKeysFormat {
    public byte[] format(AuthorizedKeys authorizedKeys, AuthorizedKeysFileSaver authorizedKeysFileSaver) throws InvalidSshKeyException, IOException {
        throw new UnsupportedOperationException("The OpenSSH authorized key file does not support additional key files!");
    }

    public AuthorizedKeys unformat(byte[] byArray, AuthorizedKeysFileLoader authorizedKeysFileLoader) throws InvalidSshKeyException, IOException {
        throw new UnsupportedOperationException("The OpenSSH authorized key file does not support additional key files!");
    }

    public byte[] format(AuthorizedKeys authorizedKeys) throws InvalidSshKeyException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OpenSSHPublicKeyFormat openSSHPublicKeyFormat = new OpenSSHPublicKeyFormat();
        Iterator iterator = authorizedKeys.getAuthorizedKeys().entrySet().iterator();
        while (iterator != null && iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            openSSHPublicKeyFormat.setComment((String)entry.getKey());
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.create((SshPublicKey)entry.getValue(), openSSHPublicKeyFormat);
            byteArrayOutputStream.write(sshPublicKeyFile.toString().getBytes());
            byteArrayOutputStream.write(10);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public AuthorizedKeys unformat(byte[] byArray) throws InvalidSshKeyException, IOException {
        String string;
        AuthorizedKeys authorizedKeys = new AuthorizedKeys();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(byArray)));
        while ((string = bufferedReader.readLine()) != null) {
            SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(string.getBytes());
            authorizedKeys.addKey(sshPublicKeyFile.getComment(), sshPublicKeyFile.toPublicKey());
        }
        return authorizedKeys;
    }

    public boolean requiresKeyFiles() {
        return false;
    }
}

