/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration.automate;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.automate.RemoteIdentification;
import com.sshtools.j2ssh.configuration.automate.RemoteIdentificationException;
import java.util.Iterator;
import java.util.Map;

public class RemoteIdentificationFactory {
    private static Map remoteIdentifications = null;

    public static synchronized RemoteIdentification getInstance(String string) throws RemoteIdentificationException {
        if (remoteIdentifications == null) {
            throw new RemoteIdentificationException("There are no remote identification rules!");
        }
        Iterator iterator = remoteIdentifications.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RemoteIdentification remoteIdentification = (RemoteIdentification)entry.getValue();
            if (!remoteIdentification.testRules(string)) continue;
            return remoteIdentification;
        }
        throw new RemoteIdentificationException("Failed to find a remote identification rule");
    }

    public static void main(String[] stringArray) {
        try {
            String string = "http://www.sshtools.com J2SSH 0.1.1 beta [CLIENT]";
            RemoteIdentification remoteIdentification = RemoteIdentificationFactory.getInstance(string);
            System.out.println("Remote Identification: ".concat(String.valueOf(String.valueOf(remoteIdentification.getName(string)))));
            string = "OpenSSH_3.4p1";
            remoteIdentification = RemoteIdentificationFactory.getInstance(string);
            System.out.println("Remote Identification: ".concat(String.valueOf(String.valueOf(remoteIdentification.getName(string)))));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            remoteIdentifications = ConfigurationLoader.getAutomationConfiguration().getRemoteIdentifications();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }
}

