/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;

public class ChannelInputStream
extends InputStream {
    int[] filter;
    byte[] msgdata;
    int currentPos = 0;
    private SshMessageStore messageStore;
    private Integer type = null;

    public ChannelInputStream(SshMessageStore sshMessageStore, Integer n) {
        this.messageStore = sshMessageStore;
        this.filter = new int[1];
        this.type = n;
        this.filter[0] = n != null ? 95 : 94;
    }

    public ChannelInputStream(SshMessageStore sshMessageStore) {
        this(sshMessageStore, null);
    }

    public int available() {
        int n = 0;
        if (this.msgdata != null) {
            n = this.msgdata.length - this.currentPos;
        }
        if (n == 0) {
            try {
                if (this.type != null) {
                    SshMsgChannelExtendedData sshMsgChannelExtendedData = (SshMsgChannelExtendedData)this.messageStore.peekMessage(this.filter);
                    n = sshMsgChannelExtendedData.getChannelData().length;
                } else {
                    SshMsgChannelData sshMsgChannelData = (SshMsgChannelData)this.messageStore.peekMessage(this.filter);
                    n = sshMsgChannelData.getChannelData().length;
                }
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                n = -1;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                n = 0;
            }
        }
        return n;
    }

    public void close() throws IOException {
        this.messageStore.close();
    }

    public boolean isClosed() {
        return this.messageStore.isClosed();
    }

    public int read() throws IOException {
        try {
            this.block();
            int n = this.msgdata[this.currentPos++] & 0xFF;
            return n;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            int n = -1;
            return n;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.block();
            int n3 = this.available() < n2 ? this.available() : n2;
            System.arraycopy(this.msgdata, this.currentPos, byArray, n, n3);
            this.currentPos += n3;
            int n4 = n3;
            return n4;
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            int n5 = -1;
            return n5;
        }
    }

    private void block() throws MessageStoreEOFException {
        if (this.msgdata == null) {
            this.collectNextMessage();
        }
        if (this.currentPos >= this.msgdata.length) {
            this.collectNextMessage();
        }
    }

    private void collectNextMessage() throws MessageStoreEOFException {
        if (this.type != null) {
            SshMsgChannelExtendedData sshMsgChannelExtendedData = (SshMsgChannelExtendedData)this.messageStore.getMessage(this.filter);
            if (sshMsgChannelExtendedData != null) {
                this.msgdata = sshMsgChannelExtendedData.getChannelData();
                this.currentPos = 0;
            }
        } else {
            SshMsgChannelData sshMsgChannelData = (SshMsgChannelData)this.messageStore.getMessage(this.filter);
            if (sshMsgChannelData != null) {
                this.msgdata = sshMsgChannelData.getChannelData();
                this.currentPos = 0;
            }
        }
    }
}

