/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingChannel;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingListener;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketPermission;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ForwardingServer
implements ChannelFactory,
GlobalRequestHandler {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$forwarding$ForwardingServer == null ? (class$com$sshtools$j2ssh$forwarding$ForwardingServer = ForwardingServer.class$("com.sshtools.j2ssh.forwarding.ForwardingServer")) : class$com$sshtools$j2ssh$forwarding$ForwardingServer));
    public static final String REMOTE_FORWARD_REQUEST = "tcpip-forward";
    public static final String REMOTE_FORWARD_CANCEL_REQUEST = "cancel-tcpip-forward";
    private ConnectionProtocol connection;
    private List channelTypes = new Vector();
    private List localForwardings = new Vector();
    private List remoteForwardings = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$forwarding$ForwardingServer;

    public ForwardingServer(ConnectionProtocol connectionProtocol) throws IOException {
        this.connection = connectionProtocol;
        this.channelTypes.add("direct-tcpip");
        connectionProtocol.addChannelFactory("direct-tcpip", this);
        connectionProtocol.allowGlobalRequest(REMOTE_FORWARD_REQUEST, this);
        connectionProtocol.allowGlobalRequest(REMOTE_FORWARD_CANCEL_REQUEST, this);
    }

    public Channel createChannel(String string, byte[] byArray) throws InvalidChannelException {
        if (!string.equals("direct-tcpip")) {
            throw new InvalidChannelException("The client can only request the opening of a local forwarding channel");
        }
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            int n = (int)byteArrayReader.readInt();
            String string3 = byteArrayReader.readString();
            int n2 = (int)byteArrayReader.readInt();
            ForwardingConfiguration forwardingConfiguration = this.getLocalForwardingByAddress(string3, n2);
            Socket socket = new Socket(string2, n);
            ForwardingChannel forwardingChannel = forwardingConfiguration.createForwardingChannel(string, string2, n, string3, n2);
            forwardingChannel.bindSocket(socket);
            ForwardingChannel forwardingChannel2 = forwardingChannel;
            return forwardingChannel2;
        }
        catch (ForwardingConfigurationException forwardingConfigurationException) {
            throw new InvalidChannelException("No valid forwarding configuration was available for the request");
        }
        catch (IOException iOException) {
            throw new InvalidChannelException("The channel request data is invalid/or corrupt for channel type ".concat(String.valueOf(String.valueOf(string))));
        }
    }

    public GlobalRequestResponse processGlobalRequest(String string, byte[] byArray) {
        GlobalRequestResponse globalRequestResponse = GlobalRequestResponse.REQUEST_FAILED;
        String string2 = null;
        int n = -1;
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("Processing ").append(string).append(" global request"))));
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            string2 = byteArrayReader.readString();
            n = (int)byteArrayReader.readInt();
            if (string.equals(REMOTE_FORWARD_REQUEST)) {
                this.addRemoteForwardingConfiguration(string2, n);
                globalRequestResponse = GlobalRequestResponse.REQUEST_SUCCEEDED;
            }
            if (string.equals(REMOTE_FORWARD_CANCEL_REQUEST)) {
                this.removeRemoteForwarding(string2, n);
                globalRequestResponse = GlobalRequestResponse.REQUEST_SUCCEEDED;
            }
        }
        catch (IOException iOException) {
            log.warn((Object)String.valueOf(String.valueOf(new StringBuffer("The client failed to request ").append(string).append(" for ").append(string2).append(":").append(String.valueOf(n)))), (Throwable)iOException);
        }
        return globalRequestResponse;
    }

    protected ForwardingConfiguration getLocalForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        try {
            ForwardingConfiguration forwardingConfiguration;
            Iterator iterator = this.localForwardings.iterator();
            while (iterator.hasNext()) {
                forwardingConfiguration = (ForwardingConfiguration)iterator.next();
                if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
                ForwardingConfiguration forwardingConfiguration2 = forwardingConfiguration;
                return forwardingConfiguration2;
            }
            forwardingConfiguration = new ForwardingConfiguration(string, n);
            forwardingConfiguration.start();
            this.localForwardings.add(forwardingConfiguration);
            ForwardingConfiguration forwardingConfiguration3 = forwardingConfiguration;
            return forwardingConfiguration3;
        }
        catch (IOException iOException) {
            throw new ForwardingConfigurationException(iOException.getMessage());
        }
    }

    protected ForwardingConfiguration getRemoteForwardingByAddress(String string, int n) throws ForwardingConfigurationException {
        Iterator iterator = this.remoteForwardings.iterator();
        while (iterator.hasNext()) {
            ForwardingConfiguration forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            return forwardingConfiguration;
        }
        throw new ForwardingConfigurationException("The remote forwarding does not exist!");
    }

    protected void addRemoteForwardingConfiguration(String string, int n) throws ForwardingConfigurationException {
        ForwardingConfiguration forwardingConfiguration;
        Iterator iterator = this.remoteForwardings.iterator();
        while (iterator.hasNext()) {
            forwardingConfiguration = (ForwardingConfiguration)iterator.next();
            if (!forwardingConfiguration.getAddressToBind().equals(string) || forwardingConfiguration.getPortToBind() != n) continue;
            throw new ForwardingConfigurationException("The address and port are already in use!");
        }
        forwardingConfiguration = new ForwardingConfiguration(string, n);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SocketPermission(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(":").append(String.valueOf(n)))), "accept,listen"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException(String.valueOf(String.valueOf(new StringBuffer("The security manager has denied listen permision on ").append(string).append(":").append(String.valueOf(n)))));
            }
        }
        try {
            ServerForwardingListener serverForwardingListener = new ServerForwardingListener(this, this.connection, string, n);
            this.remoteForwardings.add(serverForwardingListener);
            serverForwardingListener.start();
        }
        catch (IOException iOException) {
            throw new ForwardingConfigurationException(iOException.getMessage());
        }
    }

    protected void removeRemoteForwarding(String string, int n) throws ForwardingConfigurationException {
        ForwardingConfiguration forwardingConfiguration = this.getRemoteForwardingByAddress(string, n);
        forwardingConfiguration.stop();
        this.remoteForwardings.remove(forwardingConfiguration);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ServerForwardingListener
    extends ForwardingListener {
        public ServerForwardingListener(ForwardingServer forwardingServer, ConnectionProtocol connectionProtocol, String string, int n) {
            super(connectionProtocol, string, n);
        }

        public ForwardingChannel createChannel(String string, int n, Socket socket) throws ForwardingConfigurationException {
            try {
                ForwardingChannel forwardingChannel = this.createForwardingChannel("forwarded-tcpip", string, n, ((InetSocketAddress)socket.getRemoteSocketAddress()).getAddress().getHostAddress(), ((InetSocketAddress)socket.getRemoteSocketAddress()).getPort());
                forwardingChannel.bindSocket(socket);
                ForwardingChannel forwardingChannel2 = forwardingChannel;
                return forwardingChannel2;
            }
            catch (IOException iOException) {
                throw new ForwardingConfigurationException(iOException.getMessage());
            }
        }
    }
}

