/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.io.SocketConnectorState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class SocketConnector
implements Runnable {
    private SocketConnectorState state = new SocketConnectorState();
    private Thread thread;
    private SocketChannel socketChannel;
    private InputStream in;
    private OutputStream out;
    private ByteBuffer readbuf = ByteBuffer.allocateDirect(32768);
    private ByteBuffer writebuf = ByteBuffer.allocateDirect(32768);

    public SocketConnector(SocketChannel socketChannel, InputStream inputStream, OutputStream outputStream) {
        this.socketChannel = socketChannel;
        this.in = inputStream;
        this.out = outputStream;
        this.thread = new Thread(this);
        this.thread.run();
    }

    public void run() {
        Selector selector = null;
        try {
            int n;
            selector = Selector.open();
            this.socketChannel.configureBlocking(false);
            this.socketChannel.register(selector, 1);
            this.state.setValue(2);
            block4: while ((n = selector.select()) > 0) {
                System.out.println(n);
                Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    try {
                        this.processSelectionKey(selectionKey);
                    }
                    catch (IOException iOException) {
                        this.state.setValue(4);
                        selectionKey.cancel();
                        continue block4;
                    }
                }
            }
        }
        catch (IOException iOException) {
            this.state.setValue(4);
        }
    }

    public static SocketChannel createSocketChannel(String string, int n) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(false);
        socketChannel.connect(new InetSocketAddress(string, n));
        return socketChannel;
    }

    public static ServerSocketChannel createServerSocketChannel(int n) throws IOException {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.socket().bind(new InetSocketAddress(n));
        return serverSocketChannel;
    }

    public static SocketChannel acceptNextConnection(ServerSocketChannel serverSocketChannel) throws IOException {
        SelectionKey selectionKey;
        Selector selector = Selector.open();
        serverSocketChannel.register(selector, 16);
        block0: while (true) {
            selector.select();
            Iterator<SelectionKey> iterator = selector.selectedKeys().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
                selectionKey = iterator.next();
                iterator.remove();
            } while (!selectionKey.isAcceptable());
            break;
        }
        ServerSocketChannel serverSocketChannel2 = (ServerSocketChannel)selectionKey.channel();
        return serverSocketChannel2.accept();
    }

    public SocketConnectorState getState() {
        return this.state;
    }

    public void processSelectionKey(SelectionKey selectionKey) throws IOException {
        byte[] byArray;
        SocketChannel socketChannel;
        int n;
        if (selectionKey.isConnectable() && (n = (socketChannel = (SocketChannel)selectionKey.channel()).finishConnect()) == 0) {
            this.state.setValue(4);
            selectionKey.cancel();
        }
        if (selectionKey.isReadable() && (socketChannel = (SocketChannel)selectionKey.channel()).equals(this.socketChannel)) {
            try {
                ((Buffer)this.readbuf).clear();
                n = socketChannel.read(this.readbuf);
                if (n == -1) {
                    this.state.setValue(3);
                    socketChannel.close();
                } else {
                    ((Buffer)this.readbuf).flip();
                    byArray = new byte[this.readbuf.remaining()];
                    this.readbuf.get(byArray);
                    this.out.write(byArray);
                }
            }
            catch (IOException iOException) {
                this.state.setValue(4);
            }
        }
        if (selectionKey.isWritable() && (socketChannel = (SocketChannel)selectionKey.channel()).equals(this.socketChannel)) {
            try {
                int n2 = this.in.available();
                if (n2 > 0) {
                    byArray = new byte[n2];
                    this.in.read(byArray);
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    int n3 = socketChannel.write(byteBuffer);
                }
            }
            catch (IOException iOException) {
                this.state.setValue(4);
            }
        }
    }
}

