/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import java.io.IOException;

public class ACL {
    public static final int ACE4_ACCESS_ALLOWED_ACE_TYPE = 0;
    public static final int ACE4_ACCESS_DENIED_ACE_TYPE = 1;
    public static final int ACE4_SYSTEM_AUDIT_ACE_TYPE = 2;
    public static final int ACE4_SYSTEM_ALARM_ACE_TYPE = 3;
    public static final int ACE4_FILE_INHERIT_ACE = 1;
    public static final int ACE4_DIRECTORY_INHERIT_ACE = 2;
    public static final int ACE4_NO_PROPAGATE_INHERIT_ACE = 4;
    public static final int ACE4_INHERIT_ONLY_ACE = 8;
    public static final int ACE4_SUCCESSFUL_ACCESS_ACE_FLAG = 16;
    public static final int ACE4_FAILED_ACCESS_ACE_FLAG = 32;
    public static final int ACE4_IDENTIFIER_GROUP = 64;
    public static final int ACE4_READ_DATA = 1;
    public static final int ACE4_WRITE_DATA = 2;
    public static final int ACE4_APPEND_DATA = 4;
    public static final int ACE4_READ_NAMED_ATTRS = 8;
    public static final int ACE4_WRITE_NAMED_ATTRS = 16;
    public static final int ACE4_EXECUTE = 32;
    public static final int ACE4_DELETE_CHILD = 64;
    public static final int ACE4_READ_ATTRIBUTES = 128;
    public static final int ACE4_WRITE_ATTRIBUTES = 256;
    public static final int ACE4_DELETE = 4096;
    public static final int ACE4_READ_ACL = 8192;
    public static final int ACE4_WRITE_ACL = 16384;
    public static final int ACE4_WRITE_OWNER = 32768;
    public static final int ACE4_SYNCHRONIZE = 65536;
    private int type;
    private int flags = 0;
    private int masks = 0;
    String who;

    public ACL(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException("Invalid ACL type!");
        }
        this.type = n;
    }

    public ACL(ByteArrayReader byteArrayReader) throws IOException {
        this.type = (int)byteArrayReader.readInt();
        this.flags = (int)byteArrayReader.readInt();
        this.masks = (int)byteArrayReader.readInt();
        this.who = byteArrayReader.readString();
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public boolean isFlagSet(int n) {
        return (this.flags & n) == n;
    }

    public void setMask(int n) {
        this.masks |= n;
    }

    public boolean isMaskSet(int n) {
        return (this.masks & n) == n;
    }

    public void setWho(String string) {
        this.who = string;
    }

    public String getWho() {
        return this.who;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeInt(this.type);
        byteArrayWriter.writeInt(this.flags);
        byteArrayWriter.writeInt(this.masks);
        byteArrayWriter.writeString(this.who);
        return byteArrayWriter.toByteArray();
    }
}

