/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageNotRegisteredException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public final class SshMessageStore {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$SshMessageStore == null ? (class$com$sshtools$j2ssh$transport$SshMessageStore = SshMessageStore.class$("com.sshtools.j2ssh.transport.SshMessageStore")) : class$com$sshtools$j2ssh$transport$SshMessageStore));
    private List messages = new ArrayList();
    private Map register = new HashMap();
    private boolean isClosed = false;
    private int[] singleIdFilter = new int[1];
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMessageStore;

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized SshMessage getMessage(int[] nArray) throws MessageStoreEOFException {
        try {
            SshMessage sshMessage = this.getMessage(nArray, 0);
            return sshMessage;
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new MessageStoreEOFException();
        }
    }

    public synchronized SshMessage getMessage(int[] nArray, int n) throws MessageNotAvailableException, MessageStoreEOFException {
        if (this.messages.size() <= 0 && this.isClosed) {
            throw new MessageStoreEOFException();
        }
        if (nArray == null) {
            return this.nextMessage();
        }
        boolean bl = true;
        if (n < 0) {
            n = 0;
        }
        while (this.messages.size() > 0 || !this.isClosed) {
            SshMessage sshMessage = this.lookupMessage(nArray, true);
            if (sshMessage != null) {
                return sshMessage;
            }
            try {
                if (!this.isClosed) {
                    this.wait(n);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (bl && n > 0) {
                throw new MessageNotAvailableException();
            }
            bl = false;
        }
        throw new MessageStoreEOFException();
    }

    public synchronized SshMessage getMessage(int n) throws MessageStoreEOFException {
        try {
            SshMessage sshMessage = this.getMessage(n, 0);
            return sshMessage;
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            throw new MessageStoreEOFException();
        }
    }

    public synchronized SshMessage getMessage(int n, int n2) throws MessageNotAvailableException, MessageStoreEOFException {
        this.singleIdFilter[0] = n;
        return this.getMessage(this.singleIdFilter, n2);
    }

    public boolean hasMessages() {
        return this.messages.size() > 0;
    }

    public int size() {
        return this.messages.size();
    }

    public boolean isRegisteredMessage(Integer n) {
        return this.register.containsKey(n);
    }

    public void addMessage(byte[] byArray) throws InvalidMessageException, MessageNotRegisteredException {
        Integer n = new Integer(byArray[5]);
        if (!this.isRegisteredMessage(n)) {
            throw new MessageNotRegisteredException(n);
        }
        Class clazz = (Class)this.register.get(SshMessage.getMessageId(byArray));
        try {
            SshMessage sshMessage = (SshMessage)clazz.newInstance();
            sshMessage.fromByteArray(new ByteArrayReader(byArray));
            this.addMessage(sshMessage);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidMessageException("Illegal access for implementation class ".concat(String.valueOf(String.valueOf(clazz.getName()))));
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidMessageException("Instantiation failed for class ".concat(String.valueOf(String.valueOf(clazz.getName()))));
        }
    }

    public synchronized void addMessage(SshMessage sshMessage) throws MessageNotRegisteredException {
        this.messages.add(this.messages.size(), sshMessage);
        this.notifyAll();
    }

    public synchronized void close() {
        this.isClosed = true;
        this.notifyAll();
    }

    public synchronized SshMessage nextMessage() throws MessageStoreEOFException {
        if (this.messages.size() <= 0 && this.isClosed) {
            throw new MessageStoreEOFException();
        }
        while (this.messages.size() <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.messages.size() > 0) {
            return (SshMessage)this.messages.remove(0);
        }
        throw new MessageStoreEOFException();
    }

    public synchronized SshMessage peekMessage(int[] nArray) throws MessageNotAvailableException, MessageStoreEOFException {
        return this.peekMessage(nArray, 0);
    }

    public synchronized SshMessage peekMessage(int[] nArray, int n) throws MessageNotAvailableException, MessageStoreEOFException {
        SshMessage sshMessage = this.lookupMessage(nArray, false);
        if (sshMessage != null) {
            return sshMessage;
        }
        if (n > 0) {
            log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("No message so waiting for ").append(String.valueOf(n)).append(" milliseconds"))));
            try {
                this.wait(n);
                sshMessage = this.lookupMessage(nArray, false);
                if (sshMessage != null) {
                    SshMessage sshMessage2 = sshMessage;
                    return sshMessage2;
                }
            }
            catch (InterruptedException interruptedException) {
                log.debug((Object)"peekMessage was interrupted");
            }
        }
        if (this.isClosed) {
            throw new MessageStoreEOFException();
        }
        throw new MessageNotAvailableException();
    }

    private SshMessage lookupMessage(int[] nArray, boolean bl) {
        for (int i = 0; i < this.messages.size(); ++i) {
            SshMessage sshMessage = (SshMessage)this.messages.get(i);
            for (int j = 0; j < nArray.length; ++j) {
                if (sshMessage.getMessageId() != nArray[j]) continue;
                if (bl) {
                    this.messages.remove(sshMessage);
                }
                return sshMessage;
            }
        }
        return null;
    }

    public synchronized SshMessage peekMessage(int n) throws MessageNotAvailableException, MessageStoreEOFException {
        return this.peekMessage(n, 0);
    }

    public synchronized void removeMessage(SshMessage sshMessage) {
        this.messages.remove(sshMessage);
    }

    public synchronized SshMessage peekMessage(int n, int n2) throws MessageNotAvailableException, MessageStoreEOFException {
        this.singleIdFilter[0] = n;
        return this.peekMessage(this.singleIdFilter, n2);
    }

    public void registerMessage(int n, Class clazz) {
        Integer n2 = new Integer(n);
        this.register.put(n2, clazz);
    }

    public Object[] getRegisteredMessageIds() {
        return this.register.keySet().toArray();
    }

    public SshMessage createMessage(byte[] byArray) throws InvalidMessageException, MessageNotRegisteredException {
        Integer n = SshMessage.getMessageId(byArray);
        if (!this.isRegisteredMessage(n)) {
            throw new MessageNotRegisteredException(n);
        }
        Class clazz = (Class)this.register.get(SshMessage.getMessageId(byArray));
        try {
            SshMessage sshMessage = (SshMessage)clazz.newInstance();
            sshMessage.fromByteArray(new ByteArrayReader(byArray));
            SshMessage sshMessage2 = sshMessage;
            return sshMessage2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidMessageException("Illegal access for implementation class ".concat(String.valueOf(String.valueOf(clazz.getName()))));
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidMessageException("Instantiation failed for class ".concat(String.valueOf(String.valueOf(clazz.getName()))));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

