/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.MessageNotRegisteredException;
import com.sshtools.j2ssh.transport.ServiceOperationException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgDebug;
import com.sshtools.j2ssh.transport.SshMsgDisconnect;
import com.sshtools.j2ssh.transport.SshMsgIgnore;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgNewKeys;
import com.sshtools.j2ssh.transport.SshMsgUnimplemented;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.TransportProtocolInputStream;
import com.sshtools.j2ssh.transport.TransportProtocolOutputStream;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$TransportProtocolCommon == null ? (class$com$sshtools$j2ssh$transport$TransportProtocolCommon = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.TransportProtocolCommon")) : class$com$sshtools$j2ssh$transport$TransportProtocolCommon));
    private static int nextThreadNo = 1;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static String SOFTWARE_VERSION_COMMENTS = "http://www.sshtools.com ".concat(String.valueOf(String.valueOf(ConfigurationLoader.getVersionString("J2SSH", "j2ssh.properties"))));
    private int threadNo = nextThreadNo++;
    protected BigInteger k = null;
    protected Boolean completeOnNewKeys = new Boolean(false);
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean sendIgnore = false;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] exchangeHash = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector eventHandlers = new Vector();
    private List messageStack = new ArrayList();
    private Map messageNotifications = new HashMap();
    private Object kexLock = new Object();
    private Object keyLock = new Object();
    private Socket socket;
    private SshThread thread;
    private long kexTimeout = 3600000L;
    private long kexTransferLimit = 0x40000000L;
    private long startTime = System.currentTimeMillis();
    protected TransportProtocolInputStream sshIn;
    protected TransportProtocolOutputStream sshOut;
    private int remoteEOL = 1;
    private Vector messageStores = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgDebug;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgDisconnect;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgIgnore;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgKexInit;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgNewKeys;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$SshMsgUnimplemented;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$TransportProtocolCommon;

    public int getConnectionId() {
        return this.threadNo;
    }

    public int getRemoteEOL() {
        return this.remoteEOL;
    }

    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    public void disconnect(String string) {
        log.debug((Object)"Disconnect: ".concat(String.valueOf(String.valueOf(string))));
        try {
            this.sendDisconnect(11, string);
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to send disconnect", (Throwable)exception);
        }
    }

    public void setSendIgnore(boolean bl) {
        this.sendIgnore = bl;
    }

    public void setKexTimeout(long l) throws TransportProtocolException {
        if (l < (long)60) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.kexTimeout = l * (long)1000;
    }

    public void setKexTransferLimit(long l) throws TransportProtocolException {
        if (l < (long)5) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.kexTransferLimit = l * (long)1024;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    public long getOutgoingByteCount() {
        return this.sshOut.getNumBytesTransfered();
    }

    public long getIncomingByteCount() {
        return this.sshIn.getNumBytesTransfered();
    }

    public void addEventHandler(TransportProtocolEventHandler transportProtocolEventHandler) {
        if (transportProtocolEventHandler != null) {
            this.eventHandlers.add(transportProtocolEventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    public void run() {
        try {
            try {
                this.state.setValue(2);
                log.info((Object)"Registering transport protocol messages with inputstream");
                this.algorithmsOut = new TransportProtocolAlgorithmSync();
                this.algorithmsIn = new TransportProtocolAlgorithmSync();
                this.sshIn = new TransportProtocolInputStream(this.socket, this.algorithmsIn);
                this.sshOut = new TransportProtocolOutputStream(this.socket, this, this.algorithmsOut);
                this.messageStore.registerMessage(1, class$com$sshtools$j2ssh$transport$SshMsgDisconnect == null ? (class$com$sshtools$j2ssh$transport$SshMsgDisconnect = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgDisconnect")) : class$com$sshtools$j2ssh$transport$SshMsgDisconnect);
                this.messageStore.registerMessage(2, class$com$sshtools$j2ssh$transport$SshMsgIgnore == null ? (class$com$sshtools$j2ssh$transport$SshMsgIgnore = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgIgnore")) : class$com$sshtools$j2ssh$transport$SshMsgIgnore);
                this.messageStore.registerMessage(3, class$com$sshtools$j2ssh$transport$SshMsgUnimplemented == null ? (class$com$sshtools$j2ssh$transport$SshMsgUnimplemented = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgUnimplemented")) : class$com$sshtools$j2ssh$transport$SshMsgUnimplemented);
                this.messageStore.registerMessage(4, class$com$sshtools$j2ssh$transport$SshMsgDebug == null ? (class$com$sshtools$j2ssh$transport$SshMsgDebug = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgDebug")) : class$com$sshtools$j2ssh$transport$SshMsgDebug);
                this.messageStore.registerMessage(20, class$com$sshtools$j2ssh$transport$SshMsgKexInit == null ? (class$com$sshtools$j2ssh$transport$SshMsgKexInit = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgKexInit")) : class$com$sshtools$j2ssh$transport$SshMsgKexInit);
                this.messageStore.registerMessage(21, class$com$sshtools$j2ssh$transport$SshMsgNewKeys == null ? (class$com$sshtools$j2ssh$transport$SshMsgNewKeys = TransportProtocolCommon.class$("com.sshtools.j2ssh.transport.SshMsgNewKeys")) : class$com$sshtools$j2ssh$transport$SshMsgNewKeys);
                this.registerTransportMessages();
                List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    SshKeyExchange sshKeyExchange = SshKeyExchangeFactory.newInstance(string);
                    sshKeyExchange.init(this);
                    this.kexs.put(string, sshKeyExchange);
                }
                this.setLocalIdent();
                this.negotiateVersion();
                this.startBinaryPacketProtocol();
            }
            catch (Throwable throwable) {
                if (throwable instanceof IOException) {
                    this.state.setLastError((IOException)throwable);
                }
                if (this.state.getValue() != 5) {
                    log.error((Object)"The Transport Protocol thread failed", throwable);
                    this.stop();
                }
                Object var6_7 = null;
                this.thread = null;
            }
            Object var6_6 = null;
            this.thread = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.thread = null;
            throw throwable;
        }
        log.debug((Object)"The Transport Protocol has been stopped");
    }

    public synchronized void sendMessage(SshMessage sshMessage, Object object) throws IOException {
        log.debug((Object)"Sending ".concat(String.valueOf(String.valueOf(sshMessage.getMessageName()))));
        int n = this.state.getValue();
        if (object instanceof SshKeyExchange || object instanceof TransportProtocolCommon || n == 4) {
            this.sshOut.sendMessage(sshMessage);
            if (n == 4 && this.sendIgnore) {
                byte[] byArray = new byte[1];
                ConfigurationLoader.getRND().nextBytes(byArray);
                byte[] byArray2 = new byte[(byArray[0] & 0xFF) + 1];
                ConfigurationLoader.getRND().nextBytes(byArray2);
                SshMsgIgnore sshMsgIgnore = new SshMsgIgnore(new String(byArray2));
                log.debug((Object)"Sending ".concat(String.valueOf(String.valueOf(sshMsgIgnore.getMessageName()))));
                this.sshOut.sendMessage(sshMsgIgnore);
            }
        } else if (n == 3) {
            log.debug((Object)"Adding to message queue whilst in key exchange");
            List list = this.messageStack;
            synchronized (list) {
                this.messageStack.add(sshMessage);
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(Socket socket, SshConnectionProperties sshConnectionProperties) throws IOException {
        this.socket = socket;
        this.properties = sshConnectionProperties;
        log.info((Object)"Starting transport protocol");
        this.thread = new SshThread(this, "Transport protocol", true);
        this.thread.start();
        this.onStartTransportProtocol();
    }

    public void unregisterMessage(Integer n, SshMessageStore sshMessageStore) throws MessageNotRegisteredException {
        log.debug((Object)"Unregistering message Id ".concat(String.valueOf(String.valueOf(n.toString()))));
        if (!this.messageNotifications.containsKey(n)) {
            throw new MessageNotRegisteredException(n);
        }
        SshMessageStore sshMessageStore2 = (SshMessageStore)this.messageNotifications.get(n);
        if (!sshMessageStore.equals(sshMessageStore2)) {
            throw new MessageNotRegisteredException(n, sshMessageStore);
        }
        this.messageNotifications.remove(n);
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgortihm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1) throws KeyExchangeException, IOException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    protected void beginKeyExchange() throws KeyExchangeException, IOException {
        log.info((Object)"Starting key exchange");
        String string = "";
        try {
            string = this.getKexAlgorithm();
            log.debug((Object)"Key exchange algorithm: ".concat(String.valueOf(String.valueOf(string))));
            SshKeyExchange sshKeyExchange = (SshKeyExchange)this.kexs.get(string);
            this.performKeyExchange(sshKeyExchange);
            this.exchangeHash = sshKeyExchange.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.exchangeHash.length];
                System.arraycopy(this.exchangeHash, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.thread.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = sshKeyExchange.getHostKey();
            this.signature = sshKeyExchange.getSignature();
            this.k = sshKeyExchange.getSecret();
            this.sendNewKeys();
            sshKeyExchange.reset();
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.");
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal((Object)"Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected abstract void onMessageReceived(SshMessage var1) throws ServiceOperationException, IOException;

    protected void sendDisconnect(int n, String string) {
        SshMsgDisconnect sshMsgDisconnect = new SshMsgDisconnect(n, string, "");
        try {
            this.sendMessage(sshMsgDisconnect, this);
            this.stop();
        }
        catch (Exception exception) {
            log.warn((Object)"Failed to send disconnect", (Throwable)exception);
        }
    }

    protected void sendDisconnect(int n, String string, IOException iOException) {
        this.state.setLastError(iOException);
        this.sendDisconnect(n, string);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.setLocalKexInit(this.createLocalKexInit());
        this.sendMessage(this.getLocalKexInit(), this);
        this.state.setValue(3);
    }

    protected void sendNewKeys() throws IOException {
        SshMsgNewKeys sshMsgNewKeys = new SshMsgNewKeys();
        this.sendMessage(sshMsgNewKeys, this);
        this.algorithmsOut.lock();
        int[] nArray = new int[]{21};
        sshMsgNewKeys = (SshMsgNewKeys)this.readMessage(nArray);
        log.debug((Object)"Received ".concat(String.valueOf(String.valueOf(sshMsgNewKeys.getMessageName()))));
        this.completeKeyExchange();
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmInitializationException, AlgorithmNotSupportedException, AlgorithmOperationException, AlgorithmNotAgreedException;

    protected void completeKeyExchange() throws IOException {
        log.info((Object)"Completing key exchange");
        try {
            log.debug((Object)"Making keys from key exchange output");
            byte[] byArray = this.makeSshKey('C');
            byte[] byArray2 = this.makeSshKey('A');
            byte[] byArray3 = this.makeSshKey('D');
            byte[] byArray4 = this.makeSshKey('B');
            byte[] byArray5 = this.makeSshKey('E');
            byte[] byArray6 = this.makeSshKey('F');
            log.debug((Object)"Creating algorithm objects");
            this.setupNewKeys(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
            this.clientKexInit = null;
            this.serverKexInit = null;
            this.algorithmsOut.release();
            this.state.setValue(4);
            List list = this.messageStack;
            synchronized (list) {
                Iterator iterator = this.messageStack.iterator();
                log.debug((Object)"Sending queued messages");
                while (iterator.hasNext()) {
                    SshMessage sshMessage = (SshMessage)iterator.next();
                    this.sendMessage(sshMessage, this);
                }
                this.messageStack.clear();
            }
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed");
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded");
        }
        catch (AlgorithmOperationException algorithmOperationException) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error");
        }
        catch (AlgorithmInitializationException algorithmInitializationException) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error");
        }
    }

    protected String determineAlgorithm(List list, List list2) throws AlgorithmNotAgreedException {
        log.debug((Object)"Determine Algorithm");
        log.debug((Object)"Client Algorithms: ".concat(String.valueOf(String.valueOf(list.toString()))));
        log.debug((Object)"Server Algorithms: ".concat(String.valueOf(String.valueOf(list2.toString()))));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string.equals(string2)) continue;
                log.debug((Object)"Returning ".concat(String.valueOf(String.valueOf(string))));
                return string;
            }
        }
        throw new AlgorithmNotAgreedException("Could not agree algorithm");
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        block7: while (this.state.getValue() != 5) {
            SshMessage sshMessage = this.processMessages();
            log.debug((Object)"Transport Protocol is processing ".concat(String.valueOf(String.valueOf(sshMessage.getMessageName()))));
            switch (sshMessage.getMessageId()) {
                case 20: {
                    this.onMsgKexInit((SshMsgKexInit)sshMessage);
                    continue block7;
                }
                case 1: {
                    this.onMsgDisconnect((SshMsgDisconnect)sshMessage);
                    continue block7;
                }
                case 2: {
                    this.onMsgIgnore((SshMsgIgnore)sshMessage);
                    continue block7;
                }
                case 3: {
                    this.onMsgUnimplemented((SshMsgUnimplemented)sshMessage);
                    continue block7;
                }
                case 4: {
                    this.onMsgDebug((SshMsgDebug)sshMessage);
                    continue block7;
                }
            }
            this.onMessageReceived(sshMessage);
        }
    }

    protected final void stop() {
        this.state.setValue(5);
        this.onDisconnect();
        Iterator iterator = ((AbstractList)this.eventHandlers).iterator();
        while (iterator.hasNext()) {
            TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
            transportProtocolEventHandler.onDisconnect(this);
        }
        this.messageStore.close();
        iterator = ((AbstractList)this.messageStores).iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            try {
                sshMessageStore.close();
            }
            catch (Exception exception) {}
        }
        this.messageStore = null;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] makeSshKey(char c) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = new byte[20];
            Hash hash = new Hash("SHA");
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putByte((byte)c);
            hash.putBytes(this.sessionIdentifier);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putBytes(byArray);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            byte[] byArray2 = byteArrayWriter.toByteArray();
            return byArray2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported");
        }
        catch (IOException iOException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data");
        }
    }

    private void negotiateVersion() throws IOException {
        String string = "";
        log.info((Object)"Negotiating protocol version");
        log.debug((Object)"Local identification: ".concat(String.valueOf(String.valueOf(this.getLocalId()))));
        String string2 = String.valueOf(String.valueOf(this.getLocalId())).concat("\r\n");
        this.socket.getOutputStream().write(string2.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        int n = 255;
        while (!string.startsWith("SSH-") && stringBuffer.length() < n) {
            char c;
            while ((c = (char)this.socket.getInputStream().read()) != '\n' && stringBuffer.length() < n) {
                stringBuffer.append(c);
            }
            string = stringBuffer.toString();
            this.remoteEOL = string.endsWith("\r") ? 1 : 2;
            log.debug((Object)"EOL is guessed at ".concat(String.valueOf(String.valueOf(this.remoteEOL == 1 ? "CR+LF" : "LF"))));
            string = string.trim();
        }
        int n2 = string.indexOf("-");
        int n3 = string.indexOf("-", n2 + 1);
        this.setRemoteIdent(string.trim());
        log.debug((Object)"Remote identification: ".concat(String.valueOf(String.valueOf(this.getRemoteId()))));
        String string3 = string.substring(n2 + 1, n3);
        if (!string3.equals(PROTOCOL_VERSION) && !string3.equals("1.99")) {
            log.fatal((Object)"The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        log.info((Object)"Protocol negotiation complete");
    }

    private void onMsgDebug(SshMsgDebug sshMsgDebug) {
        log.debug((Object)sshMsgDebug.getMessage());
    }

    private void onMsgDisconnect(SshMsgDisconnect sshMsgDisconnect) throws IOException {
        log.info((Object)"The remote computer disconnected");
        log.debug((Object)sshMsgDisconnect.getDescription());
        this.stop();
    }

    private void onMsgIgnore(SshMsgIgnore sshMsgIgnore) {
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("SSH_MSG_IGNORE with ").append(String.valueOf(sshMsgIgnore.getData().length())).append(" bytes of data"))));
    }

    private void onMsgKexInit(SshMsgKexInit sshMsgKexInit) throws IOException {
        log.debug((Object)"Received remote key exchange init message");
        log.debug((Object)sshMsgKexInit.toString());
        Object object = this.kexLock;
        synchronized (object) {
            this.setRemoteKexInit(sshMsgKexInit);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.beginKeyExchange();
        }
    }

    private void onMsgNewKeys(SshMsgNewKeys sshMsgNewKeys) throws IOException {
        log.debug((Object)"Received New Keys");
        this.algorithmsIn.lock();
        Boolean bl = this.completeOnNewKeys;
        synchronized (bl) {
            if (this.completeOnNewKeys.booleanValue()) {
                this.completeKeyExchange();
            } else {
                this.completeOnNewKeys = new Boolean(true);
            }
        }
    }

    private void onMsgUnimplemented(SshMsgUnimplemented sshMsgUnimplemented) {
        log.debug((Object)String.valueOf(String.valueOf(new StringBuffer("The message with sequence no ").append(sshMsgUnimplemented.getSequenceNo()).append(" was reported as unimplemented by the remote end."))));
    }

    public SshMessage readMessage(int[] nArray) throws IOException {
        byte[] byArray = null;
        block8: while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            Object object;
            boolean bl = false;
            while (!bl) {
                try {
                    byArray = this.sshIn.readMessage();
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Iterator iterator = ((AbstractList)this.eventHandlers).iterator();
                    while (iterator.hasNext()) {
                        object = (TransportProtocolEventHandler)iterator.next();
                        object.onSocketTimeout(this, this.socket.isConnected());
                    }
                }
            }
            Integer n = SshMessage.getMessageId(byArray);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                if (this.messageStore.isRegisteredMessage(n)) {
                    return this.messageStore.createMessage(byArray);
                }
                object = this.getMessageStore(n);
                sshMessage = ((SshMessageStore)object).createMessage(byArray);
                log.debug((Object)"Processing ".concat(String.valueOf(String.valueOf(sshMessage.getMessageName()))));
                return sshMessage;
            }
            if (this.messageStore.isRegisteredMessage(n)) {
                sshMessage = this.messageStore.createMessage(byArray);
                switch (n) {
                    case 1: {
                        this.onMsgDisconnect((SshMsgDisconnect)sshMessage);
                        continue block8;
                    }
                    case 2: {
                        this.onMsgIgnore((SshMsgIgnore)sshMessage);
                        continue block8;
                    }
                    case 3: {
                        this.onMsgUnimplemented((SshMsgUnimplemented)sshMessage);
                        continue block8;
                    }
                    case 4: {
                        this.onMsgDebug((SshMsgDebug)sshMessage);
                        continue block8;
                    }
                }
                throw new IOException("Unexpected transport protocol message");
            }
            throw new IOException("Unexpected message received");
        }
        throw new IOException("The transport protocol disconnected");
    }

    protected SshMessage processMessages() throws IOException {
        byte[] byArray = null;
        while (this.state.getValue() != 5) {
            long l = System.currentTimeMillis();
            if (l - this.startTime > this.kexTimeout || this.sshIn.getNumBytesTransfered() + this.sshOut.getNumBytesTransfered() > this.kexTransferLimit) {
                this.startTime = l;
                this.sendKeyExchangeInit();
            }
            boolean bl = false;
            while (!bl) {
                try {
                    byArray = this.sshIn.readMessage();
                    bl = true;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    Iterator iterator = ((AbstractList)this.eventHandlers).iterator();
                    while (iterator.hasNext()) {
                        TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
                        transportProtocolEventHandler.onSocketTimeout(this, this.socket.isConnected());
                    }
                }
            }
            Integer n = SshMessage.getMessageId(byArray);
            if (!this.messageStore.isRegisteredMessage(n)) {
                SshMessage sshMessage;
                try {
                    SshMessageStore sshMessageStore = this.getMessageStore(n);
                    sshMessage = sshMessageStore.createMessage(byArray);
                    log.debug((Object)"Processing ".concat(String.valueOf(String.valueOf(sshMessage.getMessageName()))));
                    sshMessageStore.addMessage(sshMessage);
                }
                catch (MessageNotRegisteredException messageNotRegisteredException) {
                    log.info((Object)"Unimplemented message received ".concat(String.valueOf(String.valueOf(String.valueOf(n)))));
                    sshMessage = new SshMsgUnimplemented(this.sshIn.getSequenceNo());
                    this.sendMessage(sshMessage, this);
                }
                continue;
            }
            return this.messageStore.createMessage(byArray);
        }
        throw new ServiceOperationException("The transport protocol has disconnected");
    }

    public void addMessageStore(SshMessageStore sshMessageStore) throws MessageAlreadyRegisteredException {
        this.messageStores.add(sshMessageStore);
    }

    private SshMessageStore getMessageStore(Integer n) throws MessageNotRegisteredException {
        Iterator iterator = ((AbstractList)this.messageStores).iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            if (!sshMessageStore.isRegisteredMessage(n)) continue;
            return sshMessageStore;
        }
        throw new MessageNotRegisteredException(n);
    }

    public void removeMessageStore(SshMessageStore sshMessageStore) {
        this.messageStores.remove(sshMessageStore);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

