/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhInit;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhReply;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.log4j.Logger;

public class DhGroup1Sha1
extends SshKeyExchange {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1 == null ? (class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1 = DhGroup1Sha1.class$("com.sshtools.j2ssh.transport.kex.DhGroup1Sha1")) : class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1));
    private BigInteger e = null;
    private BigInteger f = null;
    private BigInteger g = new BigInteger("2");
    private BigInteger p = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private BigInteger q = new BigInteger("7FFFFFFFFFFFFFFFE487ED5110B4611A62633145C06E0E68948127044533E63A0105DF531D89CD9128A5043CC71A026EF7CA8CD9E69D218D98158536F92F8A1BA7F09AB6B6A8E122F242DABB312F3F637A262174D31BF6B585FFAE5B7A035BF6F71C35FDAD44CFD2D74F9208BE258FF324943323F67329C0FFFFFFFFFFFFFFFF", 16);
    private BigInteger x = null;
    private BigInteger y = null;
    private String clientId;
    private String serverId;
    private byte[] clientKexInit;
    private byte[] serverKexInit;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$kex$DhGroup1Sha1;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply;

    protected void onInit() {
        this.messageStore.registerMessage(30, class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit == null ? (class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit = DhGroup1Sha1.class$("com.sshtools.j2ssh.transport.kex.SshMsgKexDhInit")) : class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhInit);
        this.messageStore.registerMessage(31, class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply == null ? (class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply = DhGroup1Sha1.class$("com.sshtools.j2ssh.transport.kex.SshMsgKexDhReply")) : class$com$sshtools$j2ssh$transport$kex$SshMsgKexDhReply);
    }

    public void performClientExchange(String string, String string2, byte[] byArray, byte[] byArray2) throws IOException {
        log.info((Object)"Starting client side key exchange.");
        this.clientId = string;
        this.serverId = string2;
        this.clientKexInit = byArray;
        this.serverKexInit = byArray2;
        int n = this.g.bitLength();
        int n2 = this.q.bitLength();
        SecureRandom secureRandom = ConfigurationLoader.getRND();
        int n3 = (int)((float)(n2 - n + 1) * secureRandom.nextFloat() + (float)n);
        this.x = new BigInteger(n3, secureRandom);
        this.e = this.g.modPow(this.x, this.p);
        SshMsgKexDhInit sshMsgKexDhInit = new SshMsgKexDhInit(this.e);
        try {
            this.transport.sendMessage(sshMsgKexDhInit, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initailaztion message");
        }
        int[] nArray = new int[]{31};
        SshMsgKexDhReply sshMsgKexDhReply = (SshMsgKexDhReply)this.transport.readMessage(nArray);
        this.hostKey = sshMsgKexDhReply.getHostKey();
        this.signature = sshMsgKexDhReply.getSignature();
        this.f = sshMsgKexDhReply.getF();
        this.secret = this.f.modPow(this.x, this.p);
        this.calculateExchangeHash();
    }

    public void performServerExchange(String string, String string2, byte[] byArray, byte[] byArray2, SshPrivateKey sshPrivateKey) throws IOException {
        try {
            this.clientId = string;
            this.serverId = string2;
            this.clientKexInit = byArray;
            this.serverKexInit = byArray2;
            int n = this.g.bitLength();
            int n2 = this.q.bitLength();
            SecureRandom secureRandom = ConfigurationLoader.getRND();
            int n3 = (int)((float)(n2 - n + 1) * secureRandom.nextFloat() + (float)n);
            this.y = new BigInteger(n3, secureRandom);
            this.f = this.g.modPow(this.y, this.p);
            int[] nArray = new int[]{30};
            SshMsgKexDhInit sshMsgKexDhInit = (SshMsgKexDhInit)this.transport.readMessage(nArray);
            this.e = sshMsgKexDhInit.getE();
            this.secret = this.e.modPow(this.y, this.p);
            this.hostKey = sshPrivateKey.getPublicKey().getEncoded();
            this.calculateExchangeHash();
            this.signature = sshPrivateKey.generateSignature(this.exchangeHash);
            SshMsgKexDhReply sshMsgKexDhReply = new SshMsgKexDhReply(this.hostKey, this.f, this.signature);
            this.transport.sendMessage(sshMsgKexDhReply, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException(sshException.getMessage());
        }
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        Hash hash;
        try {
            hash = new Hash("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

