/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;

public class SshtoolsPrivateKeyFormat
extends Base64EncodedFileFormat
implements SshPrivateKeyFormat {
    private static String BEGIN = "---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private static String END = "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----";
    private int cookie = 1391688382;

    public SshtoolsPrivateKeyFormat(String string, String string2) {
        super(BEGIN, END);
        this.setHeaderValue("Subject", string);
        this.setHeaderValue("Comment", string2);
    }

    public SshtoolsPrivateKeyFormat() {
        super(BEGIN, END);
    }

    public String getFormatType() {
        return "SSHTools-PrivateKey-".concat(String.valueOf(String.valueOf(super.getFormatType())));
    }

    public boolean isPassphraseProtected(byte[] byArray) {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.getKeyBlob(byArray));
            String string = byteArrayReader.readString();
            if (string.equals("none")) {
                boolean bl = false;
                return bl;
            }
            if (string.equals("3des-cbc")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public byte[] decryptKeyblob(byte[] byArray, String string) throws InvalidSshKeyException {
        try {
            byte[] byArray2;
            byte[] byArray3 = this.getKeyBlob(byArray);
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray3);
            String string2 = byteArrayReader.readString();
            byArray3 = byteArrayReader.readBinaryString();
            if (string2.equals("3des-cbc")) {
                byArray2 = this.makePassphraseKey(string);
                byte[] byArray4 = new byte[8];
                Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray2);
                SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
                cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray4, 0, cipher.getBlockSize()));
                ByteArrayReader byteArrayReader2 = new ByteArrayReader(cipher.doFinal(byArray3));
                if (byteArrayReader2.readInt() == (long)this.cookie) {
                    byArray3 = byteArrayReader2.readBinaryString();
                } else {
                    throw new InvalidSshKeyException("The host key is invalid, check the passphrase supplied");
                }
            }
            byArray2 = byArray3;
            return byArray2;
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException("Failed to read host key");
        }
    }

    public byte[] encryptKeyblob(byte[] byArray, String string) {
        try {
            byte[] byArray2;
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            String string2 = "none";
            if (string != null && !string.trim().equals("")) {
                string2 = "3des-cbc";
                byArray2 = this.makePassphraseKey(string);
                byte[] byArray3 = new byte[8];
                Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray2);
                SecretKey secretKey = SecretKeyFactory.getInstance("DESede").generateSecret(dESedeKeySpec);
                cipher.init(1, (Key)secretKey, new IvParameterSpec(byArray3, 0, cipher.getBlockSize()));
                ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
                byteArrayWriter2.writeInt(this.cookie);
                byteArrayWriter2.writeBinaryString(byArray);
                byArray = cipher.doFinal(byteArrayWriter2.toByteArray());
            }
            byteArrayWriter.writeString(string2);
            byteArrayWriter.writeBinaryString(byArray);
            byArray2 = this.formatKey(byteArrayWriter.toByteArray());
            return byArray2;
        }
        catch (Exception exception) {
            byte[] byArray4 = null;
            return byArray4;
        }
    }

    public boolean supportsAlgorithm(String string) {
        return true;
    }

    private byte[] makePassphraseKey(String string) {
        try {
            Hash hash = new Hash("MD5");
            hash.putBytes(string.getBytes());
            byte[] byArray = hash.doFinal();
            hash.reset();
            hash.putBytes(string.getBytes());
            hash.putBytes(byArray);
            byte[] byArray2 = hash.doFinal();
            byte[] byArray3 = new byte[8];
            byte[] byArray4 = new byte[32];
            System.arraycopy(byArray, 0, byArray4, 0, 16);
            System.arraycopy(byArray2, 0, byArray4, 16, 16);
            byte[] byArray5 = byArray4;
            return byArray5;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            byte[] byArray = null;
            return byArray;
        }
    }
}

