/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey.dsa;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import org.apache.log4j.Logger;

public class SshDssPublicKey
extends SshPublicKey {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey == null ? (class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey = SshDssPublicKey.class$("com.sshtools.j2ssh.transport.publickey.dsa.SshDssPublicKey")) : class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey));
    private DSAPublicKey pubkey;
    static /* synthetic */ Class class$com$sshtools$j2ssh$transport$publickey$dsa$SshDssPublicKey;

    public SshDssPublicKey(DSAPublicKey dSAPublicKey) {
        this.pubkey = dSAPublicKey;
    }

    public SshDssPublicKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                throw new InvalidSshKeyException();
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.pubkey = (DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException();
        }
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.pubkey.getY().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getP());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.pubkey.getParams().getG());
            byteArrayWriter.writeBigInteger(this.pubkey.getY());
            byte[] byArray = byteArrayWriter.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws InvalidSshKeySignatureException {
        try {
            int n;
            Object object;
            log.debug((Object)"Verifying host key signature");
            log.debug((Object)"Signature length is ".concat(String.valueOf(String.valueOf(String.valueOf(byArray.length)))));
            if (byArray.length != 40) {
                object = new ByteArrayReader(byArray);
                byte[] byArray3 = ((ByteArrayReader)object).readBinaryString();
                String string = new String(byArray3);
                log.debug((Object)"Header is ".concat(String.valueOf(String.valueOf(string))));
                if (!string.equals("ssh-dss")) {
                    throw new InvalidSshKeySignatureException();
                }
                byArray = ((ByteArrayReader)object).readBinaryString();
                log.debug((Object)"Read signature from blob: ".concat(String.valueOf(String.valueOf(new String(byArray)))));
            }
            object = "";
            for (n = 0; n < byArray.length; ++n) {
                object = String.valueOf(String.valueOf(object)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Integer.toHexString(byArray[n] & 0xFF))).concat(": "))));
            }
            log.debug((Object)"Decoding signature ".concat(String.valueOf(String.valueOf(object))));
            object = "";
            for (n = 0; n < byArray.length; ++n) {
                object = String.valueOf(String.valueOf(object)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Integer.toString(byArray[n]))).concat(": "))));
            }
            log.debug((Object)"Decoding signature ".concat(String.valueOf(String.valueOf(object))));
            int n2 = (byArray[0] & 0x80) == 128 ? 21 : 20;
            log.debug((Object)"rlen=".concat(String.valueOf(String.valueOf(String.valueOf(n2)))));
            int n3 = (byArray[20] & 0x80) == 128 ? 21 : 20;
            log.debug((Object)"slen=".concat(String.valueOf(String.valueOf(String.valueOf(n3)))));
            byte[] byArray4 = new byte[]{48, (byte)(n2 + n3 + 4), 2, (byte)n2};
            byte[] byArray5 = new byte[]{2, (byte)n3};
            byte[] byArray6 = new byte[byArray4.length + n2 + byArray5.length + n3];
            System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
            int n4 = (byArray[0] & 0x80) == 128 ? 1 : 0;
            System.arraycopy(byArray, 0, byArray6, byArray4.length + n4, 20);
            System.arraycopy(byArray5, 0, byArray6, byArray4.length + n4 + 20, byArray5.length);
            int n5 = (byArray[20] & 0x80) == 128 ? 1 : 0;
            System.arraycopy(byArray, 20, byArray6, byArray4.length + n4 + 20 + byArray5.length + n5, 20);
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(this.pubkey);
            signature.update(byArray2);
            boolean bl = signature.verify(byArray6);
            return bl;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (IOException iOException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (SignatureException signatureException) {
            throw new InvalidSshKeySignatureException();
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

