/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.windows;

import com.sshtools.daemon.windows.WindowsAuthenticationInfo;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.PlatformConfiguration;
import com.sshtools.j2ssh.platform.NativeAuthenticationProvider;
import java.io.IOException;
import org.apache.log4j.Logger;

public class WindowsAuthentication
extends NativeAuthenticationProvider {
    private static Logger log = Logger.getLogger((Class)(class$com$sshtools$daemon$windows$WindowsAuthentication == null ? (class$com$sshtools$daemon$windows$WindowsAuthentication = WindowsAuthentication.class$("com.sshtools.daemon.windows.WindowsAuthentication")) : class$com$sshtools$daemon$windows$WindowsAuthentication));
    static /* synthetic */ Class class$com$sshtools$daemon$windows$WindowsAuthentication;

    public String getHomeDirectory(String string) throws IOException {
        String string2 = null;
        if (Thread.currentThread() instanceof SshThread) {
            string2 = (String)SshThread.getCurrentThread().getProperty("user.home");
        }
        if (string2 == null) {
            SshThread sshThread;
            string2 = this.getNativeHomeDirectory(this.getDomain(), string);
            if (string2 == null && Thread.currentThread() instanceof SshThread) {
                sshThread = SshThread.getCurrentThread();
                if (!sshThread.containsProperty("Win32UserAuthInfo")) {
                    int n = this.createToken(string, this.getDomain());
                    string2 = this.getNativeProfileDirectory(n);
                    this.closeHandle(n);
                } else {
                    WindowsAuthenticationInfo windowsAuthenticationInfo = (WindowsAuthenticationInfo)sshThread.getProperty("Win32UserAuthInfo");
                    string2 = this.getNativeProfileDirectory(windowsAuthenticationInfo.getLogonToken());
                }
                if (string2 == null) {
                    string2 = ConfigurationLoader.getPlatformConfiguration().getSetting("DefaultHomeDir");
                }
            }
            if (Thread.currentThread() instanceof SshThread) {
                sshThread = SshThread.getCurrentThread();
                sshThread.setProperty("user.home", (Object)string2);
            }
        }
        return string2;
    }

    public void logoffUser() throws IOException {
        SshThread sshThread = SshThread.getCurrentThread();
        log.info((Object)String.valueOf(String.valueOf(new StringBuffer("Logging off user ").append(sshThread.getUsername()).append(" from session ").append(String.valueOf(sshThread.getSessionIdString())))));
        this.nativeLogoffUser((WindowsAuthenticationInfo)sshThread.getProperty("Win32UserAuthInfo"));
    }

    public boolean logonUser(String string, String string2) throws IOException {
        WindowsAuthenticationInfo windowsAuthenticationInfo = this.nativeLogonUser(string, string2, this.getDomain());
        if (windowsAuthenticationInfo != null) {
            log.debug((Object)"Authenticated handle is ".concat(String.valueOf(String.valueOf(String.valueOf(windowsAuthenticationInfo.getLogonToken())))));
            if (!(Thread.currentThread() instanceof SshThread)) {
                log.error((Object)"Calling process is not an instance of SshThread, cannot set token handle");
                return false;
            }
            ((SshThread)Thread.currentThread()).setProperty("Win32UserAuthInfo", (Object)windowsAuthenticationInfo);
            return true;
        }
        log.error((Object)"nativeLogonUser returned a null handle!");
        return false;
    }

    public boolean changePassword(String string, String string2, String string3) {
        return false;
    }

    public boolean logonUser(String string) throws IOException {
        WindowsAuthenticationInfo windowsAuthenticationInfo = this.nativeLogonUserWOPassword(string, this.getDomain());
        if (windowsAuthenticationInfo != null) {
            log.debug((Object)"Authenticated handle is ".concat(String.valueOf(String.valueOf(String.valueOf(windowsAuthenticationInfo.getLogonToken())))));
            if (!(Thread.currentThread() instanceof SshThread)) {
                log.error((Object)"Calling process is not an instance of SshThread, cannot set token handle");
                return false;
            }
            ((SshThread)Thread.currentThread()).setProperty("Win32UserAuthInfo", (Object)windowsAuthenticationInfo);
            return true;
        }
        log.error((Object)"nativeLogonUser returned a null handle!");
        return false;
    }

    protected String getDomain() throws IOException {
        String string = ".";
        PlatformConfiguration platformConfiguration = ConfigurationLoader.getPlatformConfiguration();
        if (platformConfiguration.containsSetting("AuthenticateOnDomain") && (string = platformConfiguration.getSetting("AuthenticateOnDomain")).trim().length() == 0) {
            string = ".";
        }
        return string;
    }

    private native String getNativeHomeDirectory(String var1, String var2);

    public native String getNativeProfileDirectory(int var1);

    private native WindowsAuthenticationInfo nativeLogonUser(String var1, String var2, String var3);

    private native WindowsAuthenticationInfo nativeLogonUserWOPassword(String var1, String var2);

    private native void nativeLogoffUser(WindowsAuthenticationInfo var1);

    private native int createToken(String var1, String var2);

    private native void closeHandle(int var1);

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.loadLibrary("sshtools-daemon-win32");
    }
}

